/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.util;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.object.WorldCoord;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.RegionAccessor;
import org.bukkit.World;
import org.bukkit.block.Biome;

public class BiomeUtil {
    private static final Set<NamespacedKey> UNWANTED_BIOME_KEYS = new HashSet<NamespacedKey>();
    private static final Predicate<NamespacedKey> IS_OCEAN = biome -> biome.getKey().contains("ocean");
    private static final Predicate<NamespacedKey> IS_UNWANTED_BIOME = UNWANTED_BIOME_KEYS::contains;

    public static double getWorldCoordOceanBiomePercent(WorldCoord worldCoord) {
        return BiomeUtil.getWorldCoordBiomePercent(worldCoord, IS_OCEAN);
    }

    public static double getWorldCoordUnwantedBiomePercent(WorldCoord worldCoord) {
        return BiomeUtil.getWorldCoordBiomePercent(worldCoord, IS_UNWANTED_BIOME);
    }

    public static double getWorldCoordBiomePercent(WorldCoord worldCoord, Predicate<NamespacedKey> biomePredicate) {
        World world = worldCoord.getBukkitWorld();
        if (world == null) {
            return 0.0;
        }
        int plotSize = TownySettings.getTownBlockSize();
        int worldX = worldCoord.getX() * plotSize;
        int worldZ = worldCoord.getZ() * plotSize;
        int total = plotSize * plotSize;
        int badBiomeBlocks = 0;
        for (int z = 0; z < plotSize; ++z) {
            for (int x = 0; x < plotSize; ++x) {
                if (!biomePredicate.test(BiomeUtil.getBiomeKey(world, worldX, world.getHighestBlockYAt(worldX + x, worldZ + z), worldZ))) continue;
                ++badBiomeBlocks;
            }
        }
        return (double)badBiomeBlocks / (double)total;
    }

    public static NamespacedKey getBiomeKey(World world, int x, int y, int z) {
        if (Biome.class.isEnum()) {
            return Bukkit.getUnsafe().getBiomeKey((RegionAccessor)world, x, y, z);
        }
        return world.getBiome(x, y, z).getKey();
    }

    static {
        TownySettings.addReloadListener(NamespacedKey.fromString((String)"towny:unwanted_chunks"), () -> {
            UNWANTED_BIOME_KEYS.clear();
            for (String unwantedBiomeName : TownySettings.getUnwantedBiomeNames()) {
                NamespacedKey key = NamespacedKey.fromString((String)unwantedBiomeName.toLowerCase(Locale.ROOT));
                if (key == null) {
                    Towny.getPlugin().getLogger().warning("Unwanted biome name is not a valid key: " + unwantedBiomeName);
                    continue;
                }
                UNWANTED_BIOME_KEYS.add(key);
            }
        });
    }
}

