/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.util;

import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;

public class BlockUtil {
    public static List<BlockFace> CARDINAL_BLOCKFACES = new ArrayList<BlockFace>(Arrays.asList(BlockFace.EAST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.WEST));

    public static boolean sameOwner(Block b1, Block b2) {
        WorldCoord wc2;
        WorldCoord wc = WorldCoord.parseWorldCoord(b1);
        if (BlockUtil.sameWorldCoord(wc, wc2 = WorldCoord.parseWorldCoord(b2)) || BlockUtil.bothWilderness(wc, wc2)) {
            return true;
        }
        if (wc.hasTownBlock() && wc2.hasTownBlock()) {
            TownBlock tb = wc.getTownBlockOrNull();
            TownBlock tb2 = wc2.getTownBlockOrNull();
            Town town1 = wc.getTownOrNull();
            Town town2 = wc2.getTownOrNull();
            if (!town1.getUUID().equals(town2.getUUID())) {
                return false;
            }
            if (tb.hasResident() != tb2.hasResident()) {
                return false;
            }
            if (!tb.hasResident() && !tb2.hasResident() && town1.getUUID().equals(town2.getUUID())) {
                return true;
            }
            if (tb.hasResident() && tb2.hasResident() && tb.getResidentOrNull().getName().equals(tb2.getResidentOrNull().getName())) {
                return true;
            }
        }
        return false;
    }

    public static boolean sameOwnerOrHasMayorOverride(Block b1, Block b2, Player player) {
        WorldCoord wc2;
        WorldCoord wc = WorldCoord.parseWorldCoord(b1);
        if (BlockUtil.sameWorldCoord(wc, wc2 = WorldCoord.parseWorldCoord(b2)) || BlockUtil.bothWilderness(wc, wc2)) {
            return true;
        }
        if (wc.hasTownBlock() && wc2.hasTownBlock()) {
            TownBlock tb = wc.getTownBlockOrNull();
            TownBlock tb2 = wc2.getTownBlockOrNull();
            Town town1 = wc.getTownOrNull();
            Town town2 = wc2.getTownOrNull();
            Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
            if (resident == null) {
                return false;
            }
            if (!town1.getUUID().equals(town2.getUUID())) {
                return false;
            }
            if (tb.hasResident() != tb2.hasResident()) {
                return BlockUtil.isResidentActingMayorOfTown(resident, tb.getTownOrNull());
            }
            if (!tb.hasResident() && !tb2.hasResident()) {
                return true;
            }
            if (tb.hasResident() && tb2.hasResident() && tb.getResidentOrNull().getName().equals(tb2.getResidentOrNull().getName())) {
                return true;
            }
        }
        return false;
    }

    private static boolean bothWilderness(WorldCoord wc, WorldCoord wc2) {
        return !wc.hasTownBlock() && !wc2.hasTownBlock();
    }

    private static boolean isResidentActingMayorOfTown(Resident resident, Town town) {
        return resident.hasPermissionNode(PermissionNodes.TOWNY_COMMAND_PLOT_ASMAYOR.getNode()) && resident.hasTown() && town.hasResident(resident);
    }

    public static boolean sameWorldCoord(Block b1, Block b2) {
        return BlockUtil.sameWorldCoord(WorldCoord.parseWorldCoord(b1), WorldCoord.parseWorldCoord(b2));
    }

    public static boolean sameWorldCoord(WorldCoord wc, WorldCoord wc2) {
        return wc.getCoord().equals(wc2.getCoord());
    }
}

