/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.util;

import com.palmergames.bukkit.towny.utils.TownyComponents;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.bukkit.util.FontUtil;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;

public class BookFactory {
    private static final float MAX_LINE_WIDTH = FontUtil.measureWidth("LLLLLLLLLLLLLLLLLLL");

    public static ItemStack makeBook(String title, String author, String rawText) {
        ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
        book.editMeta(BookMeta.class, meta -> {
            meta.setTitle(title);
            meta.setAuthor(author);
            List<Component> pages = BookFactory.getPages(rawText);
            for (Component page : pages) {
                meta.addPages(new Component[]{page});
            }
        });
        return book;
    }

    public static ItemStack makeBook(String title, String author, List<String> pages) {
        ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
        book.editMeta(BookMeta.class, meta -> {
            meta.setTitle(title);
            meta.setAuthor(author);
            for (String page : pages) {
                meta.addPages(new Component[]{TownyComponents.miniMessage(page)});
            }
        });
        return book;
    }

    private static List<Component> getLines(String rawText) {
        ArrayList<Component> lines = new ArrayList<Component>();
        try {
            for (String section : rawText.split("\n")) {
                if (section.isEmpty()) {
                    lines.add((Component)Component.newline());
                    continue;
                }
                String[] words = Colors.strip(section).split(" ");
                TextComponent line = Component.empty();
                for (int index = 0; index < words.length; ++index) {
                    TextComponent word = Component.text((String)words[index]);
                    if (line.equals((Object)Component.empty())) {
                        line = word;
                        continue;
                    }
                    if (FontUtil.measureWidth(line.appendSpace().append((Component)word)) > MAX_LINE_WIDTH) {
                        lines.add(line.appendNewline());
                        line = word;
                        continue;
                    }
                    line = line.appendSpace().append((Component)word);
                }
                if (line.equals((Object)Component.empty())) continue;
                lines.add(line.appendNewline());
            }
        }
        catch (IllegalArgumentException ex) {
            lines.clear();
        }
        return lines;
    }

    private static List<Component> getPages(String rawText) {
        rawText = "\n" + (String)rawText;
        ArrayList<Component> pages = new ArrayList<Component>();
        List<Component> lines = BookFactory.getLines((String)rawText);
        TextComponent.Builder pageText = Component.text();
        for (int i = 1; i < lines.size(); ++i) {
            pageText.append(lines.get(i));
            if (i == 1 || i % 14 != 0) continue;
            pages.add((Component)pageText.build());
            pageText = Component.text();
        }
        BuildableComponent finalPage = pageText.build();
        if (!finalPage.equals((Object)Component.empty())) {
            pages.add((Component)finalPage);
        }
        return pages;
    }
}

