/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.util;

import com.google.common.base.Charsets;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.event.CancellableTownyEvent;
import com.palmergames.bukkit.towny.exceptions.CancelledEventException;
import com.palmergames.bukkit.towny.hooks.PluginIntegrations;
import com.palmergames.bukkit.towny.utils.MinecraftVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Registry;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.generator.WorldInfo;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.PluginManager;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitTools {
    private static Towny plugin = null;

    public static void initialize(Towny plugin) {
        BukkitTools.plugin = plugin;
    }

    public static Collection<? extends Player> getOnlinePlayers() {
        return BukkitTools.getServer().getOnlinePlayers();
    }

    public static List<Player> matchPlayer(String name) {
        ArrayList<Player> matchedPlayers = new ArrayList<Player>();
        for (Player iterPlayer : Bukkit.getOnlinePlayers()) {
            String iterPlayerName = iterPlayer.getName();
            if (PluginIntegrations.getInstance().isNPC((Entity)iterPlayer)) continue;
            if (name.equalsIgnoreCase(iterPlayerName)) {
                matchedPlayers.clear();
                matchedPlayers.add(iterPlayer);
                break;
            }
            if (!iterPlayerName.toLowerCase(Locale.ENGLISH).contains(name.toLowerCase(Locale.ENGLISH))) continue;
            matchedPlayers.add(iterPlayer);
        }
        return matchedPlayers;
    }

    public static UUID getUUIDSafely(String name) {
        OfflinePlayer cached = BukkitTools.getOfflinePlayerIfCached(name);
        return cached != null ? cached.getUniqueId() : null;
    }

    @Nullable
    public static Player getPlayerExact(String name) {
        return BukkitTools.getServer().getPlayerExact(name);
    }

    @Nullable
    public static Player getPlayer(String playerId) {
        return BukkitTools.getServer().getPlayer(playerId);
    }

    @Nullable
    public static Player getPlayer(UUID playerUUID) {
        return BukkitTools.getServer().getPlayer(playerUUID);
    }

    public static boolean hasVanishedMeta(@NotNull Player player) {
        for (MetadataValue meta : player.getMetadata("vanished")) {
            if (!meta.asBoolean()) continue;
            return true;
        }
        return false;
    }

    public static boolean playerCanSeePlayer(Player seeing, Player seen) {
        if (Bukkit.getPluginManager().isPluginEnabled("PremiumVanish") && MinecraftVersion.CURRENT_VERSION.isOlderThanOrEquals(MinecraftVersion.MINECRAFT_1_19_3)) {
            return !BukkitTools.hasVanishedMeta(seen);
        }
        return seeing.canSee(seen);
    }

    public static Collection<? extends Player> getVisibleOnlinePlayers(CommandSender sender) {
        if (!(sender instanceof Player)) {
            return Bukkit.getOnlinePlayers();
        }
        Player player = (Player)sender;
        return Bukkit.getOnlinePlayers().stream().filter(p -> BukkitTools.playerCanSeePlayer(player, p)).collect(Collectors.toCollection(ArrayList::new));
    }

    public static boolean isOnline(String name) {
        return Bukkit.getPlayerExact((String)name) != null;
    }

    public static List<World> getWorlds() {
        return BukkitTools.getServer().getWorlds();
    }

    public static World getWorld(String name) {
        return BukkitTools.getServer().getWorld(name);
    }

    public static World getWorld(UUID worldUID) {
        return BukkitTools.getServer().getWorld(worldUID);
    }

    public static UUID getWorldUUID(String name) {
        World world = BukkitTools.getWorld(name);
        return world != null ? world.getUID() : null;
    }

    public static Server getServer() {
        return Bukkit.getServer();
    }

    public static PluginManager getPluginManager() {
        return BukkitTools.getServer().getPluginManager();
    }

    public static HashMap<String, Integer> getPlayersPerWorld() {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        for (World world : BukkitTools.getServer().getWorlds()) {
            m.put(world.getName(), 0);
        }
        for (Player player : BukkitTools.getServer().getOnlinePlayers()) {
            m.put(player.getWorld().getName(), m.get(player.getWorld().getName()) + 1);
        }
        return m;
    }

    public static int calcChunk(int value) {
        return value * TownySettings.getTownBlockSize() / 16;
    }

    public static boolean hasPlayedBefore(String name) {
        return BukkitTools.getServer().getOfflinePlayer(name).hasPlayedBefore();
    }

    public static OfflinePlayer getOfflinePlayer(String name) {
        return Bukkit.getOfflinePlayer((String)name);
    }

    @Nullable
    public static OfflinePlayer getOfflinePlayerIfCached(@NotNull String name) {
        return BukkitTools.getServer().getOfflinePlayerIfCached(name);
    }

    public static OfflinePlayer getOfflinePlayerForVault(String name) {
        return Bukkit.getOfflinePlayer((UUID)UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(Charsets.UTF_8)));
    }

    public static String convertCoordtoXYZ(Location loc) {
        return loc.getWorld().getName() + " " + loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ();
    }

    public static List<String> getWorldNames() {
        return BukkitTools.getWorlds().stream().map(WorldInfo::getName).collect(Collectors.toList());
    }

    public static List<String> getWorldNames(boolean lowercased) {
        return lowercased ? BukkitTools.getWorlds().stream().map(world -> world.getName().toLowerCase(Locale.ROOT)).collect(Collectors.toList()) : BukkitTools.getWorldNames();
    }

    public static Location getBedOrRespawnLocation(Player player) {
        return MinecraftVersion.CURRENT_VERSION.isOlderThanOrEquals(MinecraftVersion.MINECRAFT_1_20_3) ? player.getBedSpawnLocation() : player.getRespawnLocation();
    }

    public static String potionEffectName(@NotNull PotionEffectType type) {
        return (type instanceof Keyed ? type.getKey().getKey() : type.getName()).toLowerCase(Locale.ROOT);
    }

    public static Objective objective(Scoreboard board, @NotNull String name, @NotNull String displayName) {
        return MinecraftVersion.CURRENT_VERSION.isOlderThanOrEquals(MinecraftVersion.MINECRAFT_1_19_1) ? board.registerNewObjective(name, "dummy", displayName) : board.registerNewObjective(name, Criteria.DUMMY, displayName);
    }

    public static boolean isEventCancelled(@NotNull Event event) {
        BukkitTools.fireEvent(event);
        if (event instanceof Cancellable) {
            Cancellable cancellable = (Cancellable)event;
            return cancellable.isCancelled();
        }
        return false;
    }

    public static void ifCancelledThenThrow(@NotNull CancellableTownyEvent event) throws CancelledEventException {
        BukkitTools.fireEvent(event);
        if (event.isCancelled()) {
            throw new CancelledEventException(event);
        }
    }

    public static void fireEvent(@NotNull Event event) {
        Bukkit.getPluginManager().callEvent(event);
    }

    @Nullable
    public static String matchMaterialName(String name) {
        Material mat = (Material)BukkitTools.matchRegistry(Registry.MATERIAL, name);
        return mat == null ? null : mat.getKey().getKey().toUpperCase(Locale.ROOT);
    }

    @Nullable
    public static <T extends Keyed> T matchRegistry(@NotNull Registry<T> registry, @NotNull String input) {
        String filtered = input.toLowerCase(Locale.ROOT).replaceAll("\\s+", "_");
        if (filtered.isEmpty()) {
            return null;
        }
        NamespacedKey key = NamespacedKey.fromString((String)filtered);
        return (T)(key != null ? registry.get(key) : null);
    }

    public static String keyAsString(@NotNull NamespacedKey key) {
        return key.getNamespace().equals("minecraft") ? key.getKey() : key.toString();
    }

    @Deprecated
    @NotNull
    public static CommandMap getCommandMap() throws ReflectiveOperationException {
        return BukkitTools.getServer().getCommandMap();
    }

    public static CompletableFuture<Location> getRespawnLocation(Player player) {
        if (MinecraftVersion.CURRENT_VERSION.isOlderThan(MinecraftVersion.MINECRAFT_1_21_5)) {
            return BukkitTools.getRespawnLocationOld(player);
        }
        Location potentialLocation = player.getRespawnLocation(false);
        if (potentialLocation == null) {
            return CompletableFuture.completedFuture(null);
        }
        return potentialLocation.getWorld().getChunkAtAsync(potentialLocation).thenApply(chunk -> player.getRespawnLocation(true));
    }

    private static CompletableFuture<Location> getRespawnLocationOld(Player player) {
        Location potentialLocation = player.getPotentialBedLocation();
        if (potentialLocation == null) {
            return CompletableFuture.completedFuture(null);
        }
        return potentialLocation.getWorld().getChunkAtAsync(potentialLocation).thenApply(chunk -> player.getBedSpawnLocation());
    }

    @ApiStatus.Internal
    public static Collection<String> convertKeyedToString(@NotNull Collection<? extends Keyed> keys) {
        HashSet<String> set = new HashSet<String>();
        for (Keyed keyed : keys) {
            set.add(BukkitTools.keyAsString(keyed.getKey()));
        }
        return set;
    }
}

