/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.util;

import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.utils.TownyComponents;
import com.palmergames.util.StringMgmt;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Colors {
    private static final Map<String, String> LEGACY_LOOKUP = new HashMap<String, String>();
    private static final Pattern LEGACY_PATTERN = Pattern.compile("[\u00a7&][0-9a-fk-or]");
    @Deprecated(since="0.101.2.6")
    public static final String Black = "\u00a70";
    @Deprecated(since="0.101.2.6")
    public static final String Navy = "\u00a71";
    @Deprecated(since="0.101.2.6")
    public static final String Green = "\u00a72";
    @Deprecated(since="0.101.2.6")
    public static final String Blue = "\u00a73";
    @Deprecated(since="0.101.2.6")
    public static final String Red = "\u00a74";
    @Deprecated(since="0.101.2.6")
    public static final String Purple = "\u00a75";
    @Deprecated(since="0.101.2.6")
    public static final String Gold = "\u00a76";
    @Deprecated(since="0.101.2.6")
    public static final String LightGray = "\u00a77";
    @Deprecated(since="0.101.2.6")
    public static final String Gray = "\u00a78";
    @Deprecated(since="0.101.2.6")
    public static final String DarkPurple = "\u00a79";
    @Deprecated(since="0.101.2.6")
    public static final String LightGreen = "\u00a7a";
    @Deprecated(since="0.101.2.6")
    public static final String LightBlue = "\u00a7b";
    @Deprecated(since="0.101.2.6")
    public static final String Rose = "\u00a7c";
    @Deprecated(since="0.101.2.6")
    public static final String LightPurple = "\u00a7d";
    @Deprecated(since="0.101.2.6")
    public static final String Yellow = "\u00a7e";
    @Deprecated(since="0.101.2.6")
    public static final String White = "\u00a7f";
    public static final String DARK_RED = "<dark_red>";
    public static final String RED = "<red>";
    public static final String GOLD = "<gold>";
    public static final String YELLOW = "<yellow>";
    public static final String DARK_GREEN = "<dark_green>";
    public static final String GREEN = "<green>";
    public static final String DARK_AQUA = "<dark_aqua>";
    public static final String AQUA = "<aqua>";
    public static final String DARK_BLUE = "<dark_blue>";
    public static final String BLUE = "<blue>";
    public static final String LIGHT_PURPLE = "<light_purple>";
    public static final String DARK_PURPLE = "<dark_purple>";
    public static final String WHITE = "<white>";
    public static final String GRAY = "<gray>";
    public static final String DARK_GRAY = "<dark_gray>";
    public static final String BLACK = "<black>";
    public static final String OBFUSCATED = "<obfuscated>";
    public static final String BOLD = "<bold>";
    public static final String STRIKETHROUGH = "<strikethrough>";
    public static final String UNDERLINED = "<underlined>";
    public static final String ITALIC = "<italic>";
    public static final String RESET = "<reset>";
    private static final Function<String, String> modernHexFunction = hex -> "<#" + hex + ">";

    public static String strip(String line) {
        return TownyComponents.stripTags(ChatColor.stripColor((String)line));
    }

    public static String translateColorCodes(String str) {
        return StringMgmt.translateHexColors(ChatColor.translateAlternateColorCodes((char)'&', (String)str));
    }

    public static String translateLegacyCharacters(String input) {
        Matcher matcher = LEGACY_PATTERN.matcher(input);
        while (matcher.find()) {
            String legacy = matcher.group();
            input = input.replace(legacy, LEGACY_LOOKUP.getOrDefault(legacy.substring(1), legacy));
        }
        return input;
    }

    public static String translateLegacyHex(String input) {
        return StringMgmt.translateHexColors(input, modernHexFunction);
    }

    @Nullable
    public static NamedTextColor toNamedTextColor(@NotNull String color) {
        return switch (color) {
            case Black, BLACK -> NamedTextColor.BLACK;
            case Navy, DARK_BLUE -> NamedTextColor.DARK_BLUE;
            case Green, DARK_GREEN -> NamedTextColor.DARK_GREEN;
            case Blue, DARK_AQUA -> NamedTextColor.DARK_AQUA;
            case Red, DARK_RED -> NamedTextColor.DARK_RED;
            case Purple, DARK_PURPLE -> NamedTextColor.DARK_PURPLE;
            case Gold, GOLD -> NamedTextColor.GOLD;
            case LightGray, GRAY -> NamedTextColor.GRAY;
            case Gray, DARK_GRAY -> NamedTextColor.DARK_GRAY;
            case DarkPurple, BLUE -> NamedTextColor.BLUE;
            case LightGreen, GREEN -> NamedTextColor.GREEN;
            case LightBlue, AQUA -> NamedTextColor.AQUA;
            case Rose, RED -> NamedTextColor.RED;
            case LightPurple, LIGHT_PURPLE -> NamedTextColor.LIGHT_PURPLE;
            case Yellow, YELLOW -> NamedTextColor.YELLOW;
            case White, WHITE -> NamedTextColor.WHITE;
            default -> null;
        };
    }

    public static String colorTown(String townName) {
        return Colors.translateColorCodes(Colors.getTownColor() + townName);
    }

    public static String colorTown(Town town) {
        return Colors.translateColorCodes(Colors.getTownColor() + String.valueOf(town));
    }

    public static String colorNation(String nationName) {
        return Colors.translateColorCodes(Colors.getNationColor() + nationName);
    }

    public static String colorNation(Nation nation) {
        return Colors.translateColorCodes(Colors.getNationColor() + String.valueOf(nation));
    }

    public static String getTownColor() {
        return TownySettings.getPAPIFormattingMayor();
    }

    public static String getNationColor() {
        return TownySettings.getPAPIFormattingKing();
    }

    public static boolean containsColourCode(String input) {
        return LEGACY_PATTERN.matcher(input).find() || input.length() != Colors.strip(input).length();
    }

    public static String getLegacyFromNamedTextColor(NamedTextColor colour) {
        return switch ("<" + colour.toString() + ">") {
            case BLACK -> Black;
            case DARK_BLUE -> Navy;
            case DARK_GREEN -> Green;
            case DARK_AQUA -> Blue;
            case DARK_RED -> Red;
            case DARK_PURPLE -> Purple;
            case GOLD -> Gold;
            case GRAY -> LightGray;
            case DARK_GRAY -> Gray;
            case BLUE -> DarkPurple;
            case GREEN -> LightGreen;
            case AQUA -> LightBlue;
            case RED -> Rose;
            case LIGHT_PURPLE -> LightPurple;
            case YELLOW -> Yellow;
            case WHITE -> White;
            default -> null;
        };
    }

    static {
        LEGACY_LOOKUP.put("0", BLACK);
        LEGACY_LOOKUP.put("1", DARK_BLUE);
        LEGACY_LOOKUP.put("2", DARK_GREEN);
        LEGACY_LOOKUP.put("3", DARK_AQUA);
        LEGACY_LOOKUP.put("4", DARK_RED);
        LEGACY_LOOKUP.put("5", DARK_PURPLE);
        LEGACY_LOOKUP.put("6", GOLD);
        LEGACY_LOOKUP.put("7", GRAY);
        LEGACY_LOOKUP.put("8", DARK_GRAY);
        LEGACY_LOOKUP.put("9", BLUE);
        LEGACY_LOOKUP.put("a", GREEN);
        LEGACY_LOOKUP.put("b", AQUA);
        LEGACY_LOOKUP.put("c", RED);
        LEGACY_LOOKUP.put("d", LIGHT_PURPLE);
        LEGACY_LOOKUP.put("e", YELLOW);
        LEGACY_LOOKUP.put("f", WHITE);
        LEGACY_LOOKUP.put("k", OBFUSCATED);
        LEGACY_LOOKUP.put("l", BOLD);
        LEGACY_LOOKUP.put("m", STRIKETHROUGH);
        LEGACY_LOOKUP.put("n", UNDERLINED);
        LEGACY_LOOKUP.put("o", ITALIC);
        LEGACY_LOOKUP.put("r", RESET);
    }
}

