/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.util;

import com.google.common.collect.ImmutableSet;
import com.palmergames.bukkit.towny.object.AbstractRegistryList;
import com.palmergames.bukkit.towny.utils.MinecraftVersion;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class ItemLists
extends AbstractRegistryList<Material> {
    public static final ItemLists AXES = ItemLists.newBuilder().withTag("items", NamespacedKey.minecraft((String)"axes")).endsWith("_AXE").build();
    public static final ItemLists SWORDS = ItemLists.newBuilder().withTag("items", NamespacedKey.minecraft((String)"swords")).endsWith("_SWORD").build();
    public static final ItemLists BOWS = ItemLists.newBuilder().add("BOW", "CROSSBOW").build();
    public static final ItemLists WEAPONS = ItemLists.newBuilder().includeList(AXES).includeList(SWORDS).includeList(BOWS).build();
    public static final ItemLists ARMOURS = ItemLists.newBuilder().withTag("items", NamespacedKey.minecraft((String)"chest_armor")).withTag("items", NamespacedKey.minecraft((String)"head_armor")).withTag("items", NamespacedKey.minecraft((String)"foot_armor")).withTag("items", NamespacedKey.minecraft((String)"leg_armor")).endsWith("_CHESTPLATE").endsWith("_HELMET").endsWith("_LEGGINGS").endsWith("_BOOTS").build();
    public static final ItemLists DYES = ItemLists.newBuilder().endsWith("_DYE").endsWith("INK_SAC").build();
    public static final ItemLists REDSTONE_INTERACTABLES = ItemLists.newBuilder().add("COMPARATOR", "REPEATER", "DAYLIGHT_DETECTOR", "NOTE_BLOCK", "REDSTONE_WIRE").build();
    public static final ItemLists POTTED_PLANTS = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"potted_plants")).startsWith("POTTED_").build();
    public static final ItemLists FLOWERS = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"flowers")).build();
    public static final ItemLists ORES = ItemLists.newBuilder().endsWith("_ORE").add("RAW_IRON_BLOCK", "RAW_GOLD_BLOCK", "RAW_COPPER_BLOCK", "ANCIENT_DEBRIS", "CLAY", "GLOWSTONE", "GILDED_BLACKSTONE").build();
    public static final ItemLists SAPLINGS = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"saplings")).endsWith("_SAPLING").add("MANGROVE_PROPAGULE", "CRIMSON_FUNGUS", "WARPED_FUNGUS").build();
    public static final ItemLists PLANTABLES = ItemLists.newBuilder().add("BAMBOO", "BEETROOT_SEEDS", "BROWN_MUSHROOM", "CACTUS", "CARROTS", "CHORUS_FRUIT", "COCOA_BEANS", "CRIMSON_FUNGUS", "KELP", "MELON_SEEDS", "NETHER_WART", "PITCHER_POD", "POTATOES", "PUMPKIN_SEEDS", "RED_MUSHROOM", "SEA_PICKLE", "SUGAR_CANE", "TORCHFLOWER_SEEDS", "WARPED_FUNGUS", "WHEAT_SEEDS").build();
    public static final ItemLists CROPS = ItemLists.newBuilder().add("ATTACHED_MELON_STEM", "ATTACHED_PUMPKIN_STEM", "BEETROOTS", "CARROTS", "COCOA", "MELON", "MELON_STEM", "PITCHER_CROP", "PITCHER_PLANT", "POTATOES", "PUMPKIN", "PUMPKIN_STEM", "SWEET_BERRY_BUSH", "WHEAT").build();
    public static final ItemLists TREES = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"logs")).withTag("blocks", NamespacedKey.minecraft((String)"leaves")).endsWith("_WOOD").endsWith("_HYPHAE").notStartsWith("STRIPPED_").endsWith("_LEAVES").endsWith("_WART_BLOCK").endsWith("_LOG").add("CRIMSON_STEM", "WARPED_STEM").add("BAMBOO_BLOCK").build();
    public static final ItemLists LEAVES = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"leaves")).endsWith("_LEAVES").endsWith("_WART_BLOCK").build();
    public static final ItemLists BEDS = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"beds")).endsWith("_BED").build();
    public static final ItemLists SIGNS = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"signs")).withTag("blocks", NamespacedKey.minecraft((String)"all_signs")).endsWith("_SIGN").build();
    public static final ItemLists TORCHES = ItemLists.newBuilder().endsWith("TORCH").build();
    public static final ItemLists SKULLS = ItemLists.newBuilder().endsWith("_HEAD").endsWith("_SKULL").build();
    public static final ItemLists BOATS = ItemLists.newBuilder().withTag("items", NamespacedKey.minecraft((String)"boats")).endsWith("_BOAT").endsWith("_RAFT").build();
    public static final ItemLists MINECARTS = ItemLists.newBuilder().endsWith("MINECART").build();
    public static final ItemLists WOOD_DOORS = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"wooden_doors")).endsWith("_DOOR").not("IRON_DOOR").build();
    public static final ItemLists DOORS = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"doors")).endsWith("_DOOR").build();
    public static final ItemLists FENCE_GATES = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"fence_gates")).endsWith("_FENCE_GATE").build();
    public static final ItemLists TRAPDOORS = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"trapdoors")).endsWith("_TRAPDOOR").build();
    public static final ItemLists SHULKER_BOXES = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"shulker_boxes")).endsWith("SHULKER_BOX").build();
    public static final ItemLists PRESSURE_PLATES = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"pressure_plates")).endsWith("_PRESSURE_PLATE").build();
    public static final ItemLists NON_WOODEN_PRESSURE_PLATES = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"pressure_plates")).excludeTag("blocks", NamespacedKey.minecraft((String)"wooden_pressure_plates")).build();
    public static final ItemLists BUTTONS = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"buttons")).endsWith("_BUTTON").build();
    public static final ItemLists PROJECTILE_TRIGGERED_REDSTONE = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"wooden_buttons")).endsWith("_BUTTON").not("STONE_BUTTON").withTag("blocks", NamespacedKey.minecraft((String)"wooden_pressure_plates")).endsWith("_PRESSURE_PLATE").not("STONE_PRESSURE_PLATE").build();
    public static final ItemLists BUCKETS = ItemLists.newBuilder().endsWith("BUCKET").build();
    public static final ItemLists WEATHERABLE_BLOCKS = ItemLists.newBuilder().add("COPPER_BLOCK", "CUT_COPPER", "CUT_COPPER_SLAB", "CUT_COPPER_STAIRS", "COPPER_TRAPDOOR").add("COPPER_CHEST", "COPPER_GOLEM_STATUE", "COPPER_BARS", "COPPER_CHAIN", "COPPER_LANTERN").conditionally(() -> MinecraftVersion.CURRENT_VERSION.isNewerThanOrEquals(MinecraftVersion.MINECRAFT_1_21_9), builder -> builder.add("LIGHTNING_ROD")).startsWith("EXPOSED_").startsWith("OXIDIZED_").startsWith("WEATHERED_").build();
    public static final ItemLists WAXED_BLOCKS = ItemLists.newBuilder().startsWith("WAXED_").build();
    public static final ItemLists COPPER_BLOCKS = ItemLists.concat(WEATHERABLE_BLOCKS, WAXED_BLOCKS);
    public static final ItemLists COPPER_CHEST = ItemLists.newBuilder().add("COPPER_CHEST", "EXPOSED_COPPER_CHEST", "OXIDIZED_COPPER_CHEST", "WEATHERED_COPPER_CHEST").build();
    public static final ItemLists COPPER_GOLEM_STATUE = ItemLists.newBuilder().add("COPPER_GOLEM_STATUE", "EXPOSED_COPPER_GOLEM_STATUE", "OXIDIZED_COPPER_GOLEM_STATUE", "WEATHERED_COPPER_GOLEM_STATUE").build();
    public static final ItemLists CANDLES = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"candles")).withTag("blocks", NamespacedKey.minecraft((String)"candle_cakes")).endsWith("CANDLE").endsWith("_CANDLE_CAKE").build();
    public static final ItemLists ITEM_FRAMES = ItemLists.newBuilder().add("ITEM_FRAME", "GLOW_ITEM_FRAME").build();
    public static final ItemLists HANGING_ENTITIES = ItemLists.newBuilder().add("ITEM_FRAME", "GLOW_ITEM_FRAME", "PAINTING").build();
    public static final ItemLists CAMPFIRES = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"campfires")).add("CAMPFIRE", "SOUL_CAMPFIRE").build();
    public static final ItemLists BOOK_CONTAINERS = ItemLists.newBuilder().add("CHISELED_BOOKSHELF", "LECTERN").build();
    public static final ItemLists PLACEABLE_BOOKS = ItemLists.newBuilder().add("BOOK", "ENCHANTED_BOOK", "WRITABLE_BOOK", "WRITTEN_BOOK").build();
    public static final ItemLists HARVESTABLE_BERRIES = ItemLists.newBuilder().add("CAVE_VINES_PLANT", "CAVE_VINES", "SWEET_BERRY_BUSH").build();
    public static final ItemLists MINECART_KILLERS = ItemLists.newBuilder().add("CACTUS").build();
    public static final ItemLists UNSTRIPPED_WOOD = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"logs")).endsWith("_LOG").notStartsWith("STRIPPED_").add("CRIMSON_STEM", "WARPED_STEM").add("BAMBOO_BLOCK").build();
    public static final ItemLists CAULDRONS = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"cauldrons")).endsWith("CAULDRON").build();
    public static final ItemLists FILLED_CAULDRONS = ItemLists.newBuilder().withTag("blocks", NamespacedKey.minecraft((String)"cauldrons")).endsWith("CAULDRON").not("CAULDRON").build();
    public static final ItemLists CAULDRON_FILLABLE = ItemLists.newBuilder().add("WATER_BUCKET", "LAVA_BUCKET", "POWDER_SNOW_BUCKET").build();
    public static final ItemLists LIQUID_BLOCKS = ItemLists.newBuilder().add("WATER", "LAVA", "BUBBLE_COLUMN").build();
    public static final ItemLists HOES = ItemLists.newBuilder().withTag("items", NamespacedKey.minecraft((String)"hoes")).endsWith("_hoe").build();
    public static final ItemLists BRUSHABLE_BLOCKS = ItemLists.newBuilder().add("SUSPICIOUS_SAND", "SUSPICIOUS_GRAVEL").build();
    public static final ItemLists PROJECTILE_BREAKABLE_BLOCKS = ItemLists.newBuilder().add("CHORUS_FLOWER", "POINTED_DRIPSTONE").conditionally(() -> MinecraftVersion.CURRENT_VERSION.isNewerThanOrEquals(MinecraftVersion.MINECRAFT_1_20_3), builder -> builder.add("DECORATED_POT")).build();
    public static final ItemLists CARPETS = ItemLists.newBuilder().endsWith("_CARPET").build();
    public static final ItemLists PLANTS = ItemLists.newBuilder().includeList(FLOWERS).includeList(CROPS).includeList(PLANTABLES).add("SHORT_GRASS", "TALL_GRASS", "LARGE_FERN", "VINE", "TWISTING_VINES_PLANT", "WEEPING_VINES_PLANT", "NETHER_WART_BLOCK", "CRIMSON_ROOTS", "WARPED_ROOTS", "NETHER_SPROUTS", "BIG_DRIPLEAF", "SMALL_DRIPLEAF").build();
    public static final ItemLists AIR_TYPES = ItemLists.newBuilder().add("AIR").add("CAVE_AIR").add("VOID_AIR").build();
    public static final ItemLists BANNERS = ItemLists.newBuilder().endsWith("_BANNER").build();
    public static final ItemLists CORAL_FANS = ItemLists.newBuilder().endsWith("_WALL_FAN").build();
    public static final ItemLists NOT_SOLID_BLOCKS = ItemLists.newBuilder().add("TRIPWIRE", "TRIPWIRE_HOOK").add("REDSTONE_WIRE", "COMPARATOR", "REPEATER", "LEVER").includeList(CORAL_FANS).includeList(AIR_TYPES).includeList(SIGNS).includeList(BUTTONS).includeList(PRESSURE_PLATES).includeList(FENCE_GATES).includeList(TRAPDOORS).includeList(DOORS).includeList(TORCHES).includeList(BANNERS).includeList(CARPETS).includeList(PLANTS).build();
    public static final ItemLists FALLING_BLOCKS = ItemLists.newBuilder().add("SAND", "RED_SAND", "GRAVEL", "SUSPICIOUS_SAND", "SUSPICIOUS_GRAVEL").endsWith("_CONCRETE_POWDER").build();
    public static final ItemLists EXPLODABLE_ATTACHABLES = ItemLists.newBuilder().add("LANTERN", "SOUL_LANTERN").add("REDSTONE_WIRE", "COMPARATOR", "REPEATER", "LEVER").endsWith("_CARPET").endsWith("_BANNER").endsWith("_BUTTON").endsWith("RAIL").endsWith("PUMPKIN_STEM").endsWith("MELON_STEM").endsWith("_AMETHYST_BUD").add("AMETHYST_CLUSTER").includeList(FLOWERS).includeList(SAPLINGS).includeList(PRESSURE_PLATES).includeList(WOOD_DOORS).build();
    public static final ItemLists INFESTED_BLOCKS = ItemLists.newBuilder().startsWith("INFESTED_").build();
    public static final ItemLists CHESTS = ItemLists.newBuilder().endsWith("CHEST").build();
    public static final ItemLists SHELVES = ItemLists.newBuilder().endsWith("SHELF").build();
    public static final Set<String> GROUPS = Arrays.stream(ItemLists.class.getFields()).filter(field -> Modifier.isStatic(field.getModifiers())).map(Field::getName).filter(name -> !name.equals("GROUPS")).collect(Collectors.toSet());

    private ItemLists(Collection<Material> taggedMaterials) {
        super(Registry.MATERIAL, taggedMaterials);
    }

    @Override
    public boolean contains(@NotNull ItemStack itemStack) {
        return this.contains(itemStack.getType());
    }

    @ApiStatus.Internal
    public Collection<String> getMaterialNameCollection() {
        return this.tagged.stream().map(Enum::name).collect(Collectors.toList());
    }

    @NotNull
    public static @Unmodifiable Set<Material> getGrouping(String groupName) {
        if (!GROUPS.contains(groupName)) {
            return ImmutableSet.of();
        }
        try {
            return ImmutableSet.copyOf((Collection)((ItemLists)ItemLists.class.getField((String)groupName).get(null)).tagged);
        }
        catch (Exception e) {
            return ImmutableSet.of();
        }
    }

    public static AbstractRegistryList.Builder<Material, ItemLists> newBuilder() {
        return new AbstractRegistryList.Builder<Material, ItemLists>(Registry.MATERIAL, Material.class, ItemLists::new).notStartsWith("LEGACY_");
    }

    private static ItemLists concat(ItemLists first, ItemLists ... others) {
        HashSet<Material> values = new HashSet<Material>(first.tagged);
        for (ItemLists other : others) {
            values.addAll(other.tagged);
        }
        return new ItemLists(values);
    }
}

