/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.util;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.InvalidNameException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Government;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.util.StringMgmt;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.bukkit.NamespacedKey;

public class NameValidation {
    private static Pattern namePattern = null;
    private static Pattern stringPattern = null;
    private static final Collection<String> bannedNames;
    private static final Pattern numberPattern;

    public static String checkAndFilterPlayerName(String name) throws InvalidNameException {
        String out = NameValidation.filterName(name);
        NameValidation.testForBadSymbols(name);
        if (!NameValidation.isNameAllowedViaRegex(out)) {
            throw new InvalidNameException(Translatable.of("msg_err_name_validation_invalid_characters", out));
        }
        return out;
    }

    public static String checkAndFilterTownNameOrThrow(String name) throws InvalidNameException {
        String out = NameValidation.filterName(name);
        NameValidation.testNameLength(out);
        NameValidation.testForNumbersInTownName(out);
        NameValidation.testForImproperNameAndThrow(out);
        NameValidation.testCapitalization(out);
        NameValidation.testForSubcommand(out);
        if (out.startsWith(TownySettings.getTownAccountPrefix())) {
            throw new InvalidNameException(Translatable.of("msg_err_name_validation_begins_with_eco_prefix", out));
        }
        return out;
    }

    public static String checkAndFilterNationNameOrThrow(String name) throws InvalidNameException {
        String out = NameValidation.filterName(name);
        NameValidation.testNameLength(out);
        NameValidation.testForNumbersInNationName(out);
        NameValidation.testForImproperNameAndThrow(out);
        NameValidation.testCapitalization(out);
        NameValidation.testForSubcommand(out);
        if (out.startsWith(TownySettings.getNationAccountPrefix())) {
            throw new InvalidNameException(Translatable.of("msg_err_name_validation_begins_with_eco_prefix", out));
        }
        return out;
    }

    public static String checkAndFilterGovernmentNameOrThrow(String name, Government gov) throws InvalidNameException {
        if (gov instanceof Town) {
            return NameValidation.checkAndFilterTownNameOrThrow(name);
        }
        if (gov instanceof Nation) {
            return NameValidation.checkAndFilterNationNameOrThrow(name);
        }
        return name;
    }

    public static String checkAndFilterPlotNameOrThrow(String name) throws InvalidNameException {
        name = NameValidation.filterName(name);
        NameValidation.testNameLength(name);
        NameValidation.testForImproperNameAndThrow(name);
        return name;
    }

    public static String checkAndFilterPlotGroupNameOrThrow(String name) throws InvalidNameException {
        return NameValidation.checkAndFilterPlotNameOrThrow(NameValidation.filterCommas(name));
    }

    public static String checkAndFilterDistrictNameOrThrow(String name) throws InvalidNameException {
        return NameValidation.checkAndFilterPlotNameOrThrow(NameValidation.filterCommas(name));
    }

    public static String checkAndFilterTitlesSurnameOrThrow(String[] words) throws InvalidNameException {
        String title = StringMgmt.join(NameValidation.filterNameArray(words));
        NameValidation.testForConfigBlacklistedName(title);
        if (title.length() > TownySettings.getMaxTitleLength()) {
            throw new InvalidNameException(Translatable.of("msg_err_name_validation_title_too_long", title));
        }
        return title;
    }

    public static String checkAndFilterTagOrThrow(String tag) throws TownyException {
        if ((tag = NameValidation.filterName(tag)).length() > TownySettings.getMaxTagLength()) {
            throw new TownyException(Translatable.of("msg_err_tag_too_long"));
        }
        NameValidation.testForEmptyName(tag);
        NameValidation.testAllUnderscores(tag);
        NameValidation.testForImproperNameAndThrow(tag);
        return tag;
    }

    public static boolean isValidBoardString(String message) {
        try {
            NameValidation.testForBadSymbols(message);
            NameValidation.testForConfigBlacklistedName(message);
        }
        catch (InvalidNameException e1) {
            return false;
        }
        try {
            if (stringPattern == null) {
                stringPattern = Pattern.compile(TownySettings.getStringCheckRegex(), 258);
            }
            return stringPattern.matcher(message).find();
        }
        catch (PatternSyntaxException e) {
            Towny.getPlugin().getLogger().log(Level.WARNING, "Failed to compile the string check regex pattern because it contains errors (" + TownySettings.getStringCheckRegex() + ")", e);
            return false;
        }
    }

    public static void testForImproperNameAndThrow(String name) throws InvalidNameException {
        NameValidation.testForEmptyName(name);
        NameValidation.testForConfigBlacklistedName(name);
        NameValidation.testAllUnderscores(name);
        NameValidation.testForBadSymbols(name);
        if (!NameValidation.isNameAllowedViaRegex(name)) {
            throw new InvalidNameException(Translatable.of("msg_err_name_validation_invalid_characters", name));
        }
    }

    private static void testForEmptyName(String name) throws InvalidNameException {
        if (name.isEmpty()) {
            throw new InvalidNameException(Translatable.of("msg_err_name_validation_is_empty"));
        }
    }

    private static void testForConfigBlacklistedName(String line) throws InvalidNameException {
        String[] words;
        for (String word : words = line.split(" ")) {
            if (word.isEmpty()) continue;
            if (!TownySettings.getBlacklistedNames().stream().anyMatch(word::equalsIgnoreCase)) continue;
            throw new InvalidNameException(Translatable.of("msg_err_name_validation_is_not_permitted", word));
        }
    }

    private static void testAllUnderscores(String name) throws InvalidNameException {
        for (char letter : name.toCharArray()) {
            if (letter == '_') continue;
            return;
        }
        throw new InvalidNameException(Translatable.of("msg_err_name_validation_is_all_underscores", name));
    }

    private static void testCapitalization(String name) throws InvalidNameException {
        int maxCapitals = TownySettings.getMaxNameCapitalLetters();
        if (maxCapitals == -1) {
            return;
        }
        int capitals = 0;
        boolean skip = true;
        for (char letter : name.toCharArray()) {
            if (skip) {
                skip = false;
                continue;
            }
            if (letter == '_') {
                skip = true;
                continue;
            }
            if (Character.isLowerCase(letter)) continue;
            ++capitals;
        }
        if (capitals > maxCapitals) {
            throw new InvalidNameException(Translatable.of("msg_err_name_validation_too_many_capitals", name, capitals, maxCapitals));
        }
    }

    private static void testForBadSymbols(String message) throws InvalidNameException {
        if (message.contains("'") || message.contains("`")) {
            throw new InvalidNameException(Translatable.of("msg_err_name_validation_contains_harmful_characters", message));
        }
    }

    private static void testForSubcommand(String name) throws InvalidNameException {
        if (NameValidation.isBannedName(name)) {
            throw new InvalidNameException(Translatable.of("msg_err_name_validation_used_in_command_structure", name));
        }
    }

    private static void testNameLength(String name) throws InvalidNameException {
        if (name.length() > TownySettings.getMaxNameLength()) {
            throw new InvalidNameException(Translatable.of("msg_err_name_validation_name_too_long", name));
        }
    }

    private static void testForNumbersInNationName(String name) throws InvalidNameException {
        if (!TownySettings.areNumbersAllowedInNationNames() && NameValidation.nameContainsNumbers(name)) {
            throw new InvalidNameException(Translatable.of("msg_err_name_validation_contains_numbers", name));
        }
    }

    private static void testForNumbersInTownName(String name) throws InvalidNameException {
        if (!TownySettings.areNumbersAllowedInTownNames() && NameValidation.nameContainsNumbers(name)) {
            throw new InvalidNameException(Translatable.of("msg_err_name_validation_contains_numbers", name));
        }
    }

    private static boolean nameContainsNumbers(String name) {
        return numberPattern.matcher(name).find();
    }

    private static boolean isNameAllowedViaRegex(String name) {
        try {
            if (namePattern == null) {
                namePattern = Pattern.compile(TownySettings.getNameCheckRegex(), 258);
            }
            return namePattern.matcher(name).find();
        }
        catch (PatternSyntaxException e) {
            Towny.getPlugin().getLogger().log(Level.WARNING, "Failed to compile the name check regex pattern because it contains errors (" + TownySettings.getNameCheckRegex() + ")", e);
            return false;
        }
    }

    private static String filterName(String input) {
        return input.replaceAll(TownySettings.getNameFilterRegex(), "_").replaceAll(TownySettings.getNameRemoveRegex(), "").replace("&k", "");
    }

    private static String[] filterNameArray(String[] arr) {
        int count = 0;
        for (String word : arr) {
            arr[count] = NameValidation.filterName(word);
            ++count;
        }
        return arr;
    }

    private static String filterCommas(String input) {
        return input.replace(",", "_");
    }

    static boolean isBannedName(String name) {
        return bannedNames.contains(name.toLowerCase(Locale.ROOT));
    }

    @Deprecated
    public static String checkAndFilterName(String name) throws InvalidNameException {
        String out = NameValidation.filterName(name);
        NameValidation.testForEmptyName(out);
        NameValidation.testAllUnderscores(out);
        NameValidation.testForImproperNameAndThrow(out);
        return out;
    }

    static {
        numberPattern = Pattern.compile("\\d");
        bannedNames = new HashSet<String>(Arrays.asList("here", "leave", "list", "online", "new", "plots", "add", "kick", "claim", "unclaim", "withdraw", "delete", "outlawlist", "deposit", "outlaw", "outpost", "ranklist", "rank", "reclaim", "reslist", "say", "set", "toggle", "join", "invite", "buy", "mayor", "bankhistory", "enemy", "ally", "townlist", "allylist", "enemylist", "king", "merge", "jail", "plotgrouplist", "trust", "purge", "leader", "baltop", "all", "help", "spawn", "takeoverclaim", "ban", "unjail", "trusttown", "forsale", "fs", "notforsale", "nfs", "buytown", "sanctiontown", "create", "cede"));
        TownySettings.addReloadListener(NamespacedKey.fromString((String)"towny:regex-patterns"), () -> {
            namePattern = null;
            stringPattern = null;
        });
    }
}

