/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaUtil {
    public static boolean isSubInterface(Class<?> sup, Class<?> sub) {
        if (sup.isInterface() && sub.isInterface()) {
            if (sup.equals(sub)) {
                return true;
            }
            for (Class<?> c : sub.getInterfaces()) {
                if (!JavaUtil.isSubInterface(sup, c)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<String> readTextFromJar(String path) throws IOException {
        try (InputStream is = JavaUtil.readResource(path);){
            List<String> list;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                list = reader.lines().collect(Collectors.toList());
            }
            return list;
        }
    }

    @NotNull
    public static InputStream readResource(String resource) throws IOException {
        InputStream is = JavaUtil.class.getResourceAsStream(resource);
        if (is == null) {
            throw new FileNotFoundException("Could not find '" + resource + "' inside the jar as a resource.");
        }
        return is;
    }

    public static void saveResource(String resource, Path destination, CopyOption ... options) throws IOException {
        try (InputStream is = JavaUtil.readResource(resource);){
            Files.copy(is, destination, options);
        }
    }

    public static boolean classExists(@NotNull String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static <T> T make(Supplier<T> supplier) {
        return supplier.get();
    }

    public static <T> T make(T initial, Consumer<T> initializer) {
        initializer.accept(initial);
        return initial;
    }

    @Nullable
    public static MethodHandle getMethodHandle(@NotNull String className, @NotNull String methodName) {
        try {
            return JavaUtil.getMethodHandle(Class.forName(className), methodName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Nullable
    public static MethodHandle getMethodHandle(@NotNull Class<?> clazz, @NotNull String methodName) {
        try {
            Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
            method.setAccessible(true);
            return MethodHandles.publicLookup().unreflect(method);
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    @Nullable
    public static MethodHandle getMethodHandle(@NotNull Class<?> clazz, @NotNull String methodName, Class<?> ... paramTypes) {
        try {
            Method method = clazz.getDeclaredMethod(methodName, paramTypes);
            method.setAccessible(true);
            return MethodHandles.publicLookup().unreflect(method);
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    @Nullable
    public static MethodHandle getFieldHandle(@NotNull Class<?> clazz, @NotNull String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return MethodHandles.publicLookup().unreflectGetter(field);
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    @NotNull
    @Contract(pure=true)
    public static UUID changeUUIDVersion(@NotNull UUID uuid, int version) {
        if (uuid.version() == version) {
            return uuid;
        }
        ByteBuffer buffer = ByteBuffer.wrap(new byte[16]);
        buffer.putLong(uuid.getMostSignificantBits());
        buffer.putLong(uuid.getLeastSignificantBits());
        byte[] bytes = buffer.array();
        bytes[6] = (byte)(version << 4);
        ByteBuffer rewrapped = ByteBuffer.wrap(bytes);
        long mostSig = rewrapped.getLong();
        long leastSig = rewrapped.getLong();
        return new UUID(mostSig, leastSig);
    }
}

