/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.util;

import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Translatable;

public class MathUtil {
    public static double sqr(double a) {
        return a * a;
    }

    public static double distanceSquared(double a, double b) {
        return MathUtil.sqr(a) + MathUtil.sqr(b);
    }

    public static double distance(double a, double b) {
        return Math.sqrt(MathUtil.distanceSquared(a, b));
    }

    public static double distance(double x1, double x2, double y1, double y2) {
        return MathUtil.distance(x1 - x2, y1 - y2);
    }

    public static double distance(Coord coord1, Coord coord2) {
        return MathUtil.distance(coord1.getX(), coord2.getX(), coord1.getZ(), coord2.getZ());
    }

    public static double getDoubleOrThrow(String input) throws TownyException {
        double d;
        try {
            d = Double.parseDouble(input);
        }
        catch (NumberFormatException e) {
            throw new TownyException(Translatable.of("msg_error_must_be_num"));
        }
        return d;
    }

    public static int getIntOrThrow(String input) throws TownyException {
        int i;
        input = MathUtil.parseAbbreviations(input);
        try {
            i = Integer.parseInt(input);
        }
        catch (NumberFormatException e) {
            throw new TownyException(Translatable.of("msg_error_must_be_int"));
        }
        return i;
    }

    private static String parseAbbreviations(String input) {
        if (input.endsWith("k") || input.endsWith("K")) {
            return MathUtil.parseNumbers(input) + "000";
        }
        if (input.endsWith("m") || input.endsWith("M")) {
            return MathUtil.parseNumbers(input) + "000000";
        }
        if (input.endsWith("b") || input.endsWith("B")) {
            return MathUtil.parseNumbers(input) + "000000000";
        }
        return input;
    }

    private static String parseNumbers(String input) {
        Object output = "";
        for (int i = 0; i < input.length(); ++i) {
            if (!Character.isDigit(input.charAt(i))) continue;
            output = (String)output + input.charAt(i);
        }
        return output;
    }

    public static double getPositiveDoubleOrThrow(String input) throws TownyException {
        double i = MathUtil.getDoubleOrThrow(input);
        if (i < 0.0) {
            throw new TownyException(Translatable.of("msg_err_negative"));
        }
        return i;
    }

    public static int getPositiveIntOrThrow(String input) throws TownyException {
        int i = MathUtil.getIntOrThrow(input);
        if (i < 0) {
            throw new TownyException(Translatable.of("msg_err_negative"));
        }
        return i;
    }
}

