/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.util;

import com.google.common.base.Strings;
import com.palmergames.bukkit.towny.object.Translation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.md_5.bungee.api.ChatColor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class StringMgmt {
    public static final Pattern hexPattern = Pattern.compile("(&#|\\{|\u00a7x|<#)([a-fA-F0-9]|\u00a7[a-fA-F0-9]){6}(}|>|)");
    public static final Pattern hexReplacePattern = Pattern.compile("(\u00a7x|[&{}<>\u00a7#])");
    private static final Function<String, String> legacyHexFunction = hex -> ChatColor.of((String)("#" + hex)).toString();

    public static String translateHexColors(String string) {
        return StringMgmt.translateHexColors(string, legacyHexFunction);
    }

    @ApiStatus.Internal
    public static String translateHexColors(String string, Function<String, String> hexFunction) {
        Matcher hexMatcher = hexPattern.matcher(string);
        while (hexMatcher.find()) {
            String hex = hexMatcher.group();
            string = string.replace(hex, hexFunction.apply(hexReplacePattern.matcher(hex).replaceAll("")));
        }
        return string;
    }

    public static String join(Collection<?> args) {
        return StringMgmt.join(args, " ");
    }

    public static String join(Collection<?> args, String separator) {
        StringJoiner joiner = new StringJoiner(separator);
        for (Object o : args) {
            joiner.add(o.toString());
        }
        return joiner.toString();
    }

    public static String join(Object[] arr) {
        return StringMgmt.join(arr, " ");
    }

    public static String join(Object[] arr, String separator) {
        if (arr.length == 0) {
            return "";
        }
        Object out = arr[0].toString();
        for (int i = 1; i < arr.length; ++i) {
            out = (String)out + separator + String.valueOf(arr[i]);
        }
        return out;
    }

    public static String join(Map<?, ?> map, String keyValSeparator, String tokenSeparator) {
        if (map.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            sb.append(entry.getKey()).append(keyValSeparator).append(entry.getValue().toString()).append(tokenSeparator);
        }
        return sb.toString();
    }

    public static String repeat(String sequence, int repetitions) {
        return Strings.repeat((String)sequence, (int)repetitions);
    }

    public static String[] remFirstArg(String[] arr) {
        return StringMgmt.remArgs(arr, 1);
    }

    public static String[] remLastArg(String[] arr) {
        return StringMgmt.subArray(arr, 0, arr.length - 1);
    }

    public static String[] remArgs(String[] arr, int startFromIndex) {
        if (arr.length == 0) {
            return arr;
        }
        if (arr.length < startFromIndex) {
            return new String[0];
        }
        String[] newSplit = new String[arr.length - startFromIndex];
        System.arraycopy(arr, startFromIndex, newSplit, 0, arr.length - startFromIndex);
        return newSplit;
    }

    public static String[] subArray(String[] arr, int start, int end) {
        if (arr.length == 0) {
            return arr;
        }
        if (end < start) {
            return new String[0];
        }
        int length = end - start;
        String[] newSplit = new String[length];
        System.arraycopy(arr, start, newSplit, 0, length);
        return newSplit;
    }

    public static String trimMaxLength(String str, int length) {
        if (str.length() < length) {
            return str;
        }
        if (length > 3) {
            return str.substring(0, length);
        }
        throw new UnsupportedOperationException("Minimum length of 3 characters.");
    }

    public static String maxLength(String str, int length) {
        if (str.length() < length) {
            return str;
        }
        if (length > 3) {
            return str.substring(0, length - 3) + "...";
        }
        throw new UnsupportedOperationException("Minimum length of 3 characters.");
    }

    public static boolean containsIgnoreCase(List<String> arr, String str) {
        for (String s : arr) {
            if (!s.equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }

    public static String remUnderscore(String str) {
        return str.replaceAll("_", " ");
    }

    public static String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static String capitalizeStrings(String string) {
        return Stream.of(string.split("_")).map(str -> str.substring(0, 1).toUpperCase() + str.substring(1)).collect(Collectors.joining("_"));
    }

    public static boolean parseOnOff(String s) throws Exception {
        if (s.equalsIgnoreCase("on")) {
            return true;
        }
        if (s.equalsIgnoreCase("off")) {
            return false;
        }
        throw new Exception(Translation.of("msg_err_invalid_input", "on/off."));
    }

    public static boolean isAllUpperCase(@NotNull String string) {
        if (string.isEmpty()) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char character = string.charAt(i);
            if (!Character.isLowerCase(character)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllUpperCase(@NotNull Collection<String> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        for (String string : collection) {
            if (StringMgmt.isAllUpperCase(string)) continue;
            return false;
        }
        return true;
    }

    public static List<String> addToList(List<String> list, String addition) {
        ArrayList<String> out = new ArrayList<String>(list);
        out.add(addition);
        return out;
    }

    public static String wrap(String string, int wrapLength, String newlineString) {
        int index = 0;
        StringBuilder stringBuilder = new StringBuilder(string);
        while (index + wrapLength < stringBuilder.length() && (index = stringBuilder.lastIndexOf(" ", index + wrapLength)) != -1) {
            stringBuilder.replace(index, index + 1, newlineString);
            index += newlineString.length();
        }
        return stringBuilder.toString();
    }
}

