/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.util;

import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.object.Translatable;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class TimeTools {
    private static final long MILLIS_PER_SECOND = TimeUnit.SECONDS.toMillis(1L);
    private static final long MILLIS_PER_MINUTE = TimeUnit.MINUTES.toMillis(1L);
    private static final long MILLIS_PER_HOUR = TimeUnit.HOURS.toMillis(1L);
    private static final long MILLIS_PER_DAY = TimeUnit.DAYS.toMillis(1L);
    private static final long MILLIS_PER_YEAR = TimeUnit.DAYS.toMillis(365L);

    public static long secondsFromDhms(String dhms) {
        int seconds = 0;
        int minutes = 0;
        int hours = 0;
        int days = 0;
        if (dhms.contains("d")) {
            days = Integer.parseInt(dhms.split("d")[0].replaceAll(" ", ""));
            if (dhms.contains("h") || dhms.contains("m") || dhms.contains("s")) {
                dhms = dhms.split("d")[1];
            }
        }
        if (dhms.contains("h")) {
            hours = Integer.parseInt(dhms.split("h")[0].replaceAll(" ", ""));
            if (dhms.contains("m") || dhms.contains("s")) {
                dhms = dhms.split("h")[1];
            }
        }
        if (dhms.contains("m")) {
            minutes = Integer.parseInt(dhms.split("m")[0].replaceAll(" ", ""));
            if (dhms.contains("s")) {
                dhms = dhms.split("m")[1];
            }
        }
        if (dhms.contains("s")) {
            seconds = Integer.parseInt(dhms.split("s")[0].replaceAll(" ", ""));
        }
        return (long)days * 86400L + (long)hours * 3600L + (long)minutes * 60L + (long)seconds;
    }

    public static long getMillis(String dhms) {
        return TimeTools.getSeconds(dhms) * 1000L;
    }

    public static long getSeconds(String dhms) {
        if (Pattern.matches(".*[a-zA-Z].*", dhms)) {
            return TimeTools.secondsFromDhms(dhms);
        }
        return Long.parseLong(dhms);
    }

    public static long getTicks(String dhms) {
        return TimeTools.convertToTicks(TimeTools.getSeconds(dhms));
    }

    public static long convertToTicks(long t) {
        return t * 20L;
    }

    public static int convertToShortTicks(double timeSeconds) {
        return (int)(timeSeconds / (double)TownySettings.getShortInterval() + 0.5);
    }

    public static int getHours(long milliSeconds) {
        return (int)(milliSeconds / 1000L / 60L) / 60;
    }

    public static int getDays(long milliSeconds) {
        return (int)(milliSeconds / 1000L / 60L / 60L) / 24;
    }

    public static long getTimeInMillisXSecondsAgo(int seconds) {
        return System.currentTimeMillis() - MILLIS_PER_SECOND * (long)seconds;
    }

    public static long getTimeInMillisXMinutesAgo(int minutes) {
        return System.currentTimeMillis() - MILLIS_PER_MINUTE * (long)minutes;
    }

    public static long getTimeInMillisXHoursAgo(int hours) {
        return System.currentTimeMillis() - MILLIS_PER_HOUR * (long)hours;
    }

    public static long getTimeInMillisXDaysAgo(int days) {
        return System.currentTimeMillis() - MILLIS_PER_DAY * (long)days;
    }

    public static Translatable formatRelativeTime(long unixMs) {
        long now = System.currentTimeMillis();
        if (unixMs > now) {
            return Translatable.of("time-future");
        }
        long diff = now - unixMs;
        if (diff < MILLIS_PER_SECOND) {
            return Translatable.of("time-just-now");
        }
        if (diff < 2L * MILLIS_PER_MINUTE) {
            return Translatable.of("time-a-minute-ago");
        }
        if (diff < 60L * MILLIS_PER_MINUTE) {
            return Translatable.of("time-x-minutes-ago", diff / MILLIS_PER_MINUTE);
        }
        if (diff < 2L * MILLIS_PER_HOUR) {
            return Translatable.of("time-an-hour-ago");
        }
        if (diff < 24L * MILLIS_PER_HOUR) {
            return Translatable.of("time-x-hours-ago", diff / MILLIS_PER_HOUR);
        }
        if (diff < 48L * MILLIS_PER_HOUR) {
            return Translatable.of("time-yesterday");
        }
        if (diff < MILLIS_PER_YEAR) {
            return Translatable.of("time-x-days-ago", diff / MILLIS_PER_DAY);
        }
        if (diff < 2L * MILLIS_PER_YEAR) {
            return Translatable.of("time-a-year-ago");
        }
        return Translatable.of("time-x-years-ago", diff / MILLIS_PER_YEAR);
    }
}

