/*
 * Decompiled with CFR 0.152.
 */
package io.reallmerry.rStudio;

import io.reallmerry.rStudio.PacketListenerManager;
import io.reallmerry.rStudio.log.FileLogger;
import java.io.File;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PacketCommand
implements CommandExecutor {
    private final PacketListenerManager listenerManager;
    private final FileLogger fileLogger;
    private final MiniMessage mm = MiniMessage.miniMessage();

    public PacketCommand(PacketListenerManager listenerManager, FileLogger fileLogger) {
        this.listenerManager = listenerManager;
        this.fileLogger = fileLogger;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!sender.hasPermission("packetanalyser.using")) {
            sender.sendMessage(this.mm.deserialize((Object)"<red>You do not have permission to use this command.</red>"));
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(this.mm.deserialize((Object)"<gold>Usage: <white>/packets <start|stop|list> ...</white></gold>"));
            return true;
        }
        String action = args[0].toLowerCase();
        if ("list".equals(action)) {
            try {
                File packetListFile = this.fileLogger.generatePacketListFile();
                sender.sendMessage(this.mm.deserialize((Object)"<green>Successfully generated packet list!</green>"));
                sender.sendMessage(this.mm.deserialize((Object)("<gray>File saved to: <white>" + packetListFile.getPath().replace("\\", "/") + "</white></gray>")));
            }
            catch (Exception e) {
                sender.sendMessage(this.mm.deserialize((Object)"<red>An error occurred while generating the packet list. See console for details.</red>"));
                e.printStackTrace();
            }
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(this.mm.deserialize((Object)"<gold>Usage: <white>/packets <start|stop> <player> [packet_type]</white></gold>"));
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            sender.sendMessage(this.mm.deserialize((Object)("<red>Player <white>" + args[1] + "</white> not found.</red>")));
            return true;
        }
        if ("start".equals(action)) {
            String packetFilter = args.length > 2 ? args[2].toUpperCase() : "";
            File logFile = this.listenerManager.startLogging(target, packetFilter);
            if (logFile == null) {
                sender.sendMessage(this.mm.deserialize((Object)"<red>Failed to start logging session. Check the console for errors.</red>"));
                return true;
            }
            Object filterMessage = !packetFilter.isEmpty() ? " filtering for <white>" + packetFilter + "</white>" : "";
            sender.sendMessage(this.mm.deserialize((Object)("<green>Started logging packets for <white>" + target.getName() + "</white>" + (String)filterMessage + ".</green>")));
            sender.sendMessage(this.mm.deserialize((Object)("<gray>Log file: <white>" + logFile.getPath().replace("\\", "/") + "</white></gray>")));
        } else if ("stop".equals(action)) {
            if (this.listenerManager.isLogging(target.getUniqueId())) {
                this.listenerManager.stopLogging(target.getUniqueId());
                sender.sendMessage(this.mm.deserialize((Object)("<red>Stopped logging packets for <white>" + target.getName() + "</white>.</red>")));
            } else {
                sender.sendMessage(this.mm.deserialize((Object)("<yellow>Logging for <white>" + target.getName() + "</white> was not enabled.</yellow>")));
            }
        } else {
            sender.sendMessage(this.mm.deserialize((Object)"<red>Unknown action. Use 'start', 'stop', or 'list'.</red>"));
        }
        return true;
    }
}

