/*
 * Decompiled with CFR 0.152.
 */
package io.reallmerry.rStudio;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.reflect.StructureModifier;
import com.google.common.collect.ImmutableSet;
import io.reallmerry.rStudio.PacketAnalyser;
import io.reallmerry.rStudio.log.FileLogger;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.StreamSupport;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PacketListenerManager {
    private final PacketAnalyser plugin;
    private final FileLogger fileLogger;
    private final Map<UUID, String> loggingTargets = new ConcurrentHashMap<UUID, String>();
    private PacketAdapter packetAdapter;
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");

    public PacketListenerManager(PacketAnalyser plugin, FileLogger fileLogger) {
        this.plugin = plugin;
        this.fileLogger = fileLogger;
    }

    public File startLogging(Player player, String packetFilter) {
        this.loggingTargets.put(player.getUniqueId(), packetFilter);
        return this.fileLogger.openSession(player, packetFilter);
    }

    public void stopLogging(UUID playerUuid) {
        this.loggingTargets.remove(playerUuid);
        this.fileLogger.closeSession(playerUuid);
    }

    public void stopAllLogging() {
        for (UUID uuid : this.loggingTargets.keySet()) {
            this.fileLogger.closeSession(uuid);
        }
        this.loggingTargets.clear();
    }

    public boolean isLogging(UUID playerUuid) {
        return this.loggingTargets.containsKey(playerUuid);
    }

    public void registerListeners() {
        Set supportedPackets = (Set)StreamSupport.stream(PacketType.values().spliterator(), false).filter(PacketType::isSupported).collect(ImmutableSet.toImmutableSet());
        this.packetAdapter = new PacketAdapter((Plugin)this.plugin, ListenerPriority.NORMAL, supportedPackets){

            public void onPacketReceiving(PacketEvent event) {
                PacketListenerManager.this.handlePacket(event, "C->S");
            }

            public void onPacketSending(PacketEvent event) {
                PacketListenerManager.this.handlePacket(event, "S->C");
            }
        };
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)this.packetAdapter);
    }

    public void unregisterListeners() {
        ProtocolLibrary.getProtocolManager().removePacketListener((PacketListener)this.packetAdapter);
    }

    private void handlePacket(PacketEvent event, String direction) {
        if (event.getPacketType().getProtocol() != PacketType.Protocol.PLAY) {
            return;
        }
        Player player = event.getPlayer();
        if (player == null || !player.isOnline()) {
            return;
        }
        if (this.loggingTargets.containsKey(player.getUniqueId())) {
            String filter = this.loggingTargets.get(player.getUniqueId());
            String packetName = event.getPacketType().name();
            if (filter.isEmpty() || packetName.equalsIgnoreCase(filter)) {
                String timestamp = TIME_FORMATTER.format(LocalDateTime.now());
                String packetDetails = this.getPacketDetails(event.getPacket());
                String logMessage = String.format("[%s] [%s] %s %s", timestamp, direction, packetName, packetDetails);
                this.fileLogger.log(player.getUniqueId(), logMessage);
            }
        }
    }

    private String getPacketDetails(PacketContainer packet) {
        StringBuilder details = new StringBuilder("{");
        try {
            this.appendFields(details, "Booleans", packet.getBooleans());
            this.appendFields(details, "Bytes", packet.getBytes());
            this.appendFields(details, "Shorts", packet.getShorts());
            this.appendFields(details, "Integers", packet.getIntegers());
            this.appendFields(details, "Longs", packet.getLongs());
            this.appendFields(details, "Floats", packet.getFloat());
            this.appendFields(details, "Doubles", packet.getDoubles());
            this.appendFields(details, "Strings", packet.getStrings());
            this.appendFields(details, "Byte[]", packet.getByteArrays());
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Could not fully inspect packet " + packet.getType().name() + ": " + e.getMessage());
            details.append(" (Inspection Error)");
        }
        if (details.length() > 1) {
            details.setLength(details.length() - 2);
        }
        details.append(" }");
        return details.toString();
    }

    private <T> void appendFields(StringBuilder builder, String fieldType, StructureModifier<T> modifier) {
        int size = modifier.size();
        if (size > 0) {
            builder.append(String.format(" %s: (", fieldType));
            for (int i = 0; i < size; ++i) {
                Object value = modifier.readSafely(i);
                String valueStr = value instanceof byte[] ? "byte[" + ((byte[])value).length + "]" : String.valueOf(value);
                builder.append(String.format("%d: %s, ", i, valueStr));
            }
            builder.setLength(builder.length() - 2);
            builder.append("), ");
        }
    }
}

