/*
 * Decompiled with CFR 0.152.
 */
package io.reallmerry.rStudio.log;

import com.comphenix.protocol.PacketType;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class FileLogger {
    private final JavaPlugin plugin;
    private final File pluginDataFolder;
    private final Map<UUID, BufferedWriter> activeWriters = new ConcurrentHashMap<UUID, BufferedWriter>();
    private final Map<UUID, File> activeFiles = new ConcurrentHashMap<UUID, File>();

    public FileLogger(JavaPlugin plugin) {
        this.plugin = plugin;
        this.pluginDataFolder = plugin.getDataFolder();
        if (!this.pluginDataFolder.exists()) {
            this.pluginDataFolder.mkdirs();
        }
    }

    public File openSession(Player player, String packetFilter) {
        File logFile;
        File logsDir;
        if (this.activeWriters.containsKey(player.getUniqueId())) {
            this.closeSession(player.getUniqueId());
        }
        if (!(logsDir = new File(this.pluginDataFolder, "logs")).exists()) {
            logsDir.mkdirs();
        }
        String filterName = packetFilter == null || packetFilter.isEmpty() ? "ALL" : packetFilter;
        int sessionNumber = 1;
        do {
            logFile = new File(logsDir, String.format("%s_%s_%d.log", player.getName(), filterName, sessionNumber));
            ++sessionNumber;
        } while (logFile.exists());
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(logFile, true));
            this.activeWriters.put(player.getUniqueId(), writer);
            this.activeFiles.put(player.getUniqueId(), logFile);
            return logFile;
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not create log file for player " + player.getName());
            e.printStackTrace();
            return null;
        }
    }

    public void closeSession(UUID playerUuid) {
        BufferedWriter writer = this.activeWriters.remove(playerUuid);
        this.activeFiles.remove(playerUuid);
        if (writer != null) {
            try {
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not close log file writer for UUID: " + String.valueOf(playerUuid));
                e.printStackTrace();
            }
        }
    }

    public void log(UUID playerUuid, String message) {
        BufferedWriter writer = this.activeWriters.get(playerUuid);
        if (writer != null) {
            try {
                writer.write(message);
                writer.newLine();
                writer.flush();
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Failed to write to log file for UUID: " + String.valueOf(playerUuid));
            }
        }
    }

    public File generatePacketListFile() throws IOException {
        File packetListFile = new File(this.pluginDataFolder, "PacketList.md");
        Map<PacketType.Protocol, Map<PacketType.Sender, List<PacketType>>> categorizedPackets = StreamSupport.stream(PacketType.values().spliterator(), false).collect(Collectors.groupingBy(PacketType::getProtocol, Collectors.groupingBy(PacketType::getSender)));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(packetListFile, false));){
            writer.write("# Full List of Minecraft Packets (ProtocolLib)\n\n");
            writer.write("This file is auto-generated by PacketAnalyser. It lists all packets recognized by ProtocolLib.\n\n");
            writer.write("Direction `SERVER` means Server-Bound (Client -> Server).\n");
            writer.write("Direction `CLIENT` means Client-Bound (Server -> Client).\n\n");
            categorizedPackets.keySet().stream().sorted().forEach(protocol -> {
                try {
                    writer.write("## Protocol: " + protocol.name() + "\n\n");
                    Map senders = (Map)categorizedPackets.get(protocol);
                    if (senders.containsKey(PacketType.Sender.SERVER)) {
                        writer.write("### SERVER (C->S)\n\n");
                        ((List)senders.get(PacketType.Sender.SERVER)).stream().sorted().forEach(packetType -> {
                            try {
                                writer.write("- `" + packetType.name() + "`\n");
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        });
                        writer.write("\n");
                    }
                    if (senders.containsKey(PacketType.Sender.CLIENT)) {
                        writer.write("### CLIENT (S->C)\n\n");
                        ((List)senders.get(PacketType.Sender.CLIENT)).stream().sorted().forEach(packetType -> {
                            try {
                                writer.write("- `" + packetType.name() + "`\n");
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        });
                        writer.write("\n");
                    }
                }
                catch (IOException e) {
                    this.plugin.getLogger().warning("Error while writing protocol section to PacketList.md");
                }
            });
        }
        return packetListFile;
    }
}

