/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.teamabnormals.blueprint.client.BlueprintChestMaterials;
import com.teamabnormals.blueprint.core.api.IChestBlock;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Calendar;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;

public class BlueprintChestBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    public static Block itemBlock = null;
    private final ModelPart lid;
    private final ModelPart bottom;
    private final ModelPart lock;
    private final ModelPart doubleLeftLid;
    private final ModelPart doubleLeftBottom;
    private final ModelPart doubleLeftLock;
    private final ModelPart doubleRightLid;
    private final ModelPart doubleRightBottom;
    private final ModelPart doubleRightLock;
    public boolean isChristmas;

    public BlueprintChestBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            this.isChristmas = true;
        }
        ModelPart modelpart = context.bakeLayer(ModelLayers.CHEST);
        this.bottom = modelpart.getChild("bottom");
        this.lid = modelpart.getChild("lid");
        this.lock = modelpart.getChild("lock");
        ModelPart modelpart1 = context.bakeLayer(ModelLayers.DOUBLE_CHEST_LEFT);
        this.doubleLeftBottom = modelpart1.getChild("bottom");
        this.doubleLeftLid = modelpart1.getChild("lid");
        this.doubleLeftLock = modelpart1.getChild("lock");
        ModelPart modelpart2 = context.bakeLayer(ModelLayers.DOUBLE_CHEST_RIGHT);
        this.doubleRightBottom = modelpart2.getChild("bottom");
        this.doubleRightLid = modelpart2.getChild("lid");
        this.doubleRightLock = modelpart2.getChild("lock");
    }

    public void render(T tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Level world = tileEntityIn.getLevel();
        boolean flag = world != null;
        BlockState blockstate = flag ? tileEntityIn.getBlockState() : (BlockState)Blocks.CHEST.defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)Direction.SOUTH);
        ChestType chesttype = blockstate.hasProperty((Property)ChestBlock.TYPE) ? (ChestType)blockstate.getValue((Property)ChestBlock.TYPE) : ChestType.SINGLE;
        Block block = blockstate.getBlock();
        if (block instanceof AbstractChestBlock) {
            AbstractChestBlock abstractchestblock = (AbstractChestBlock)block;
            boolean flag1 = chesttype != ChestType.SINGLE;
            matrixStackIn.pushPose();
            float f = ((Direction)blockstate.getValue((Property)ChestBlock.FACING)).toYRot();
            matrixStackIn.translate(0.5, 0.5, 0.5);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(-f));
            matrixStackIn.translate(-0.5, -0.5, -0.5);
            DoubleBlockCombiner.NeighborCombineResult icallbackwrapper = flag ? abstractchestblock.combine(blockstate, world, tileEntityIn.getBlockPos(), true) : DoubleBlockCombiner.Combiner::acceptNone;
            float f1 = ((Float2FloatFunction)icallbackwrapper.apply(ChestBlock.opennessCombiner((LidBlockEntity)((LidBlockEntity)tileEntityIn)))).get(partialTicks);
            f1 = 1.0f - f1;
            f1 = 1.0f - f1 * f1 * f1;
            int i = ((Int2IntFunction)icallbackwrapper.apply((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(combinedLightIn);
            VertexConsumer ivertexbuilder = this.getChestMaterial(tileEntityIn, chesttype).buffer(bufferIn, RenderType::entityCutout);
            if (flag1) {
                if (chesttype == ChestType.LEFT) {
                    this.render(matrixStackIn, ivertexbuilder, this.doubleLeftLid, this.doubleLeftLock, this.doubleLeftBottom, f1, i, combinedOverlayIn);
                } else {
                    this.render(matrixStackIn, ivertexbuilder, this.doubleRightLid, this.doubleRightLock, this.doubleRightBottom, f1, i, combinedOverlayIn);
                }
            } else {
                this.render(matrixStackIn, ivertexbuilder, this.lid, this.lock, this.bottom, f1, i, combinedOverlayIn);
            }
            matrixStackIn.popPose();
        }
    }

    public Material getChestMaterial(T t, ChestType type) {
        if (this.isChristmas) {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case ChestType.SINGLE -> Sheets.CHEST_XMAS_LOCATION;
                case ChestType.LEFT -> Sheets.CHEST_XMAS_LOCATION_LEFT;
                case ChestType.RIGHT -> Sheets.CHEST_XMAS_LOCATION_RIGHT;
            };
        }
        Block inventoryBlock = itemBlock;
        if (inventoryBlock == null) {
            inventoryBlock = t.getBlockState().getBlock();
        }
        BlueprintChestMaterials.ChestMaterials chestMaterials = BlueprintChestMaterials.getMaterials(((IChestBlock)inventoryBlock).getChestMaterialsName());
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ChestType.SINGLE -> {
                if (chestMaterials != null) {
                    yield chestMaterials.singleMaterial();
                }
                yield Sheets.CHEST_LOCATION;
            }
            case ChestType.LEFT -> {
                if (chestMaterials != null) {
                    yield chestMaterials.leftMaterial();
                }
                yield Sheets.CHEST_LOCATION_LEFT;
            }
            case ChestType.RIGHT -> chestMaterials != null ? chestMaterials.rightMaterial() : Sheets.CHEST_LOCATION_RIGHT;
        };
    }

    public void render(PoseStack matrixStack, VertexConsumer builder, ModelPart chestLid, ModelPart chestLatch, ModelPart chestBottom, float lidAngle, int combinedLightIn, int combinedOverlayIn) {
        chestLatch.xRot = chestLid.xRot = -(lidAngle * 1.5707964f);
        chestLid.render(matrixStack, builder, combinedLightIn, combinedOverlayIn);
        chestLatch.render(matrixStack, builder, combinedLightIn, combinedOverlayIn);
        chestBottom.render(matrixStack, builder, combinedLightIn, combinedOverlayIn);
    }
}

