/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.client.screen.splash;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamabnormals.blueprint.client.screen.splash.Splash;
import com.teamabnormals.blueprint.client.screen.splash.SplashManagerAccessor;
import com.teamabnormals.blueprint.core.Blueprint;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;

public final class BlueprintSplashManager
extends SimplePreparableReloadListener<Pair<LinkedList<Splash>, IdentityHashMap<String, Splash>>> {
    private static final Gson GSON = new GsonBuilder().create();
    public static final String PATH = "texts/blueprint/splashes.json";
    private static BlueprintSplashManager instance;
    private LinkedList<Splash> eventSplashes = new LinkedList();
    private IdentityHashMap<String, Splash> identifierToRandomSplash = new IdentityHashMap();

    public static void onRegisterClientReloadListeners(RegisterClientReloadListenersEvent event) {
        instance = new BlueprintSplashManager();
        event.registerReloadListener((PreparableReloadListener)instance);
    }

    @Nullable
    public static String getRandomEventSplash(User user, RandomSource random) {
        if (instance == null) {
            return null;
        }
        ArrayList<Splash> eventSplashes = new ArrayList<Splash>(BlueprintSplashManager.instance.eventSplashes);
        while (eventSplashes.size() > 0) {
            int index = random.nextInt(eventSplashes.size());
            String splash = eventSplashes.get(index).getText(user, random);
            if (splash != null) {
                return splash;
            }
            eventSplashes.remove(index);
        }
        return null;
    }

    @Nullable
    public static Splash getSplashForIdentifier(String identifier) {
        return instance != null ? BlueprintSplashManager.instance.identifierToRandomSplash.get(identifier) : null;
    }

    protected Pair<LinkedList<Splash>, IdentityHashMap<String, Splash>> prepare(ResourceManager manager, ProfilerFiller profilerFiller) {
        LinkedList<Splash> eventSplashes = new LinkedList<Splash>();
        IdentityHashMap<String, Splash> identifierToRandomSplash = new IdentityHashMap<String, Splash>();
        for (String namespace : manager.getNamespaces()) {
            ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)PATH);
            for (Resource resource : manager.getResourceStack(location)) {
                try {
                    InputStream inputstream = resource.open();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));
                    JsonElement element = (JsonElement)GsonHelper.fromNullableJson((Gson)GSON, (Reader)reader, JsonElement.class, (boolean)false);
                    if (element != null) {
                        DataResult dataResult = Splash.LIST_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)element);
                        Optional error = dataResult.error();
                        if (error.isPresent()) {
                            throw new JsonParseException(((DataResult.Error)error.get()).message());
                        }
                        List splashList = (List)((Pair)dataResult.result().get()).getFirst();
                        for (Splash splash : splashList) {
                            if (splash.isRandom()) {
                                identifierToRandomSplash.put(String.valueOf(splash.hashCode()), splash);
                                continue;
                            }
                            eventSplashes.add(splash);
                        }
                        continue;
                    }
                    Blueprint.LOGGER.error("Couldn't load splashes file {} from {} as it is null or empty", (Object)location, (Object)resource.sourcePackId());
                }
                catch (IOException | RuntimeException exception) {
                    Blueprint.LOGGER.error("Couldn't read splashes file {} in data pack {}", (Object)location, (Object)resource.sourcePackId(), (Object)exception);
                }
            }
        }
        return Pair.of(eventSplashes, identifierToRandomSplash);
    }

    protected void apply(Pair<LinkedList<Splash>, IdentityHashMap<String, Splash>> pair, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        this.eventSplashes = (LinkedList)pair.getFirst();
        LinkedList<Splash> eventSplashes = this.eventSplashes;
        this.identifierToRandomSplash = (IdentityHashMap)pair.getSecond();
        ((SplashManagerAccessor)Minecraft.getInstance().getSplashManager()).getSplashes().addAll(this.identifierToRandomSplash.keySet());
        Blueprint.LOGGER.info("Blueprint Splash Manager has loaded {} splashes", (Object)(eventSplashes.size() + this.identifierToRandomSplash.size()));
    }
}

