/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.advancement.modification.modifiers;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.blueprint.common.advancement.modification.AdvancementModifierSerializers;
import com.teamabnormals.blueprint.common.advancement.modification.BlueprintAdvancementBuilder;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.AdvancementModifier;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.commands.CacheableFunction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;

public record RewardsModifier(boolean replaces, Optional<Integer> experience, Optional<List<ResourceKey<LootTable>>> loot, Optional<List<ResourceLocation>> recipes, Optional<ResourceLocation> function) implements AdvancementModifier<RewardsModifier>
{
    @Override
    public void modify(BlueprintAdvancementBuilder builder) {
        if (!this.replaces) {
            AdvancementRewards rewards = builder.rewards;
            AdvancementRewards.Builder rewardsBuilder = new AdvancementRewards.Builder();
            rewardsBuilder.addExperience(this.experience.orElse(rewards.experience()).intValue());
            rewards.loot().forEach(arg_0 -> ((AdvancementRewards.Builder)rewardsBuilder).addLootTable(arg_0));
            rewards.recipes().forEach(arg_0 -> ((AdvancementRewards.Builder)rewardsBuilder).addRecipe(arg_0));
            this.loot.ifPresent(loot -> loot.forEach(arg_0 -> ((AdvancementRewards.Builder)rewardsBuilder).addLootTable(arg_0)));
            this.recipes.ifPresent(recipes -> recipes.forEach(arg_0 -> ((AdvancementRewards.Builder)rewardsBuilder).addRecipe(arg_0)));
            if (this.function.isPresent()) {
                rewardsBuilder.runs(this.function.get());
            } else if (rewards.function().isPresent()) {
                rewardsBuilder.runs(((CacheableFunction)rewards.function().get()).getId());
            }
            builder.rewards(rewardsBuilder);
        } else {
            AdvancementRewards.Builder rewardsBuilder = new AdvancementRewards.Builder();
            this.experience.ifPresent(arg_0 -> ((AdvancementRewards.Builder)rewardsBuilder).addExperience(arg_0));
            this.loot.ifPresent(loot -> loot.forEach(arg_0 -> ((AdvancementRewards.Builder)rewardsBuilder).addLootTable(arg_0)));
            this.recipes.ifPresent(recipes -> recipes.forEach(arg_0 -> ((AdvancementRewards.Builder)rewardsBuilder).addRecipe(arg_0)));
            this.function.ifPresent(arg_0 -> ((AdvancementRewards.Builder)rewardsBuilder).runs(arg_0));
            builder.rewards(rewardsBuilder);
        }
    }

    public Serializer getSerializer() {
        return AdvancementModifierSerializers.REWARDS;
    }

    public static final class Serializer
    implements AdvancementModifier.Serializer<RewardsModifier> {
        private static final Codec<RewardsModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("replaces", (Object)false).forGetter(RewardsModifier::replaces), (App)Codec.INT.optionalFieldOf("experience").forGetter(RewardsModifier::experience), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).listOf().optionalFieldOf("loot").forGetter(RewardsModifier::loot), (App)ResourceLocation.CODEC.listOf().optionalFieldOf("recipes").forGetter(RewardsModifier::recipes), (App)ResourceLocation.CODEC.optionalFieldOf("function").forGetter(RewardsModifier::function)).apply((Applicative)instance, RewardsModifier::new));

        @Override
        public JsonElement serialize(RewardsModifier modifier, RegistryOps<JsonElement> ops) throws JsonParseException {
            DataResult result = CODEC.encodeStart(ops, (Object)modifier);
            Optional error = result.error();
            if (error.isPresent()) {
                throw new JsonParseException(((DataResult.Error)error.get()).message());
            }
            return (JsonElement)result.result().get();
        }

        @Override
        public RewardsModifier deserialize(JsonElement element, RegistryOps<JsonElement> ops) throws JsonParseException {
            DataResult result = CODEC.decode(ops, (Object)element);
            Optional error = result.error();
            if (error.isPresent()) {
                throw new JsonParseException(((DataResult.Error)error.get()).message());
            }
            return (RewardsModifier)((Pair)result.result().get()).getFirst();
        }
    }
}

