/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.world.modification;

import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.common.world.modification.ModdedBiomeSlice;
import com.teamabnormals.blueprint.common.world.modification.ModdedBiomeSource;
import com.teamabnormals.blueprint.core.Blueprint;
import com.teamabnormals.blueprint.core.BlueprintConfig;
import com.teamabnormals.blueprint.core.other.BlueprintDataMaps;
import com.teamabnormals.blueprint.core.registry.BlueprintBiomes;
import com.teamabnormals.blueprint.core.registry.BlueprintDataPackRegistries;
import com.teamabnormals.blueprint.core.util.BiomeUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.neoforged.neoforge.common.util.Lazy;

public final class ModdedBiomeSlicesManager {
    public static void onServerAboutToStart(MinecraftServer server) {
        RegistryAccess.Frozen registryAccess = server.registryAccess();
        Set slices = registryAccess.registryOrThrow(BlueprintDataPackRegistries.MODDED_BIOME_SLICES).entrySet();
        if (slices.isEmpty()) {
            return;
        }
        Registry biomeRegistry = registryAccess.registryOrThrow(Registries.BIOME);
        Holder.Reference originalSourceMarker = biomeRegistry.getHolderOrThrow(BlueprintBiomes.ORIGINAL_SOURCE_MARKER);
        HashMap<ResourceLocation, ArrayList> assignedSlices = new HashMap<ResourceLocation, ArrayList>();
        for (Map.Entry unassignedSlice : slices) {
            Set<Holder<Biome>> additionalPossibleBiomes;
            BiomeUtil.ModdedBiomeProvider provider;
            ModdedBiomeSlice slice = (ModdedBiomeSlice)unassignedSlice.getValue();
            if (slice.weight() <= 0 || (provider = slice.provider()) != BiomeUtil.OriginalModdedBiomeProvider.INSTANCE && ((additionalPossibleBiomes = provider.getAdditionalPossibleBiomes((Registry<Biome>)biomeRegistry)).isEmpty() || additionalPossibleBiomes.size() == 1 && additionalPossibleBiomes.contains(originalSourceMarker))) continue;
            slice.levels().forEach(levelStemResourceKey -> assignedSlices.computeIfAbsent(levelStemResourceKey.location(), __ -> new ArrayList()).add(Pair.of((Object)((ResourceKey)unassignedSlice.getKey()).location(), (Object)slice)));
        }
        assignedSlices.forEach((location, pairs) -> pairs.sort(Comparator.comparing(Pair::getFirst, ResourceLocation::compareNamespaced)));
        int defaultSize = (Integer)BlueprintConfig.COMMON.defaultModdedBiomeSliceSize.get();
        if (defaultSize <= 0) {
            Blueprint.LOGGER.warn("Found a non-positive value for the default slice size! Slice size 9 will be used instead.");
            defaultSize = 9;
        }
        Registry dimensions = registryAccess.registryOrThrow(Registries.LEVEL_STEM);
        long seed = server.getWorldData().worldGenOptions().seed();
        for (Map.Entry entry : dimensions.entrySet()) {
            ChunkGenerator chunkGenerator;
            BiomeSource source;
            ResourceLocation location2 = ((ResourceKey)entry.getKey()).location();
            ArrayList slicesForKey = (ArrayList)assignedSlices.get(location2);
            if (slicesForKey == null || slicesForKey.isEmpty() || (source = (chunkGenerator = ((LevelStem)entry.getValue()).generator()).getBiomeSource()) instanceof FixedBiomeSource || source instanceof CheckerboardColumnBiomeSource) continue;
            int size = defaultSize;
            BlueprintDataMaps.ModdedBiomeSliceSizeEntry sizeEntry = (BlueprintDataMaps.ModdedBiomeSliceSizeEntry)dimensions.getData(BlueprintDataMaps.MODDED_BIOME_SLICE_SIZES, (ResourceKey)entry.getKey());
            if (sizeEntry != null && sizeEntry.size() > 0) {
                size = sizeEntry.size();
            }
            ModdedBiomeSource moddedBiomeSource = new ModdedBiomeSource((Registry<Biome>)biomeRegistry, source, slicesForKey, size, seed, location2.hashCode());
            chunkGenerator.biomeSource = moddedBiomeSource;
            chunkGenerator.featuresPerStep = Lazy.of(() -> FeatureSorter.buildFeaturesPerStep(List.copyOf(moddedBiomeSource.possibleBiomes()), biomeHolder -> chunkGenerator.getBiomeGenerationSettings(biomeHolder).features(), (boolean)true));
        }
    }
}

