/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.world.modification.structure;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;

public final class StructureModificationContext {
    private final Structure.GenerationContext generationContext;
    private final BlockPos position;
    private final Supplier<Holder<Biome>> biome;

    public StructureModificationContext(Structure.GenerationContext context, BlockPos position) {
        this.generationContext = context;
        this.position = position;
        this.biome = Suppliers.memoize(() -> context.biomeSource().getNoiseBiome(QuartPos.fromBlock((int)position.getX()), QuartPos.fromBlock((int)position.getY()), QuartPos.fromBlock((int)position.getZ()), context.randomState().sampler()));
    }

    public Structure.GenerationContext getGenerationContext() {
        return this.generationContext;
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public Supplier<Holder<Biome>> biome() {
        return this.biome;
    }
}

