/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.api;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.client.renderer.texture.atlas.BlueprintPalettedPermutations;
import com.teamabnormals.blueprint.core.Blueprint;
import com.teamabnormals.blueprint.core.other.tags.BlueprintTrimMaterialTags;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.sources.DirectoryLister;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ModelEvent;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(modid="blueprint", value={Dist.CLIENT})
public class BlueprintTrims {
    public static final ResourceLocation ARMOR_TRIMS_ATLAS = ResourceLocation.withDefaultNamespace((String)"armor_trims");
    private static final ResourceLocation PALETTE_KEY = ResourceLocation.withDefaultNamespace((String)"trims/color_palettes/trim_palette");
    private static final HashMap<String, ResourceLocation> PERMUTATIONS = (HashMap)Util.make(new HashMap(), map -> {
        map.put("quartz", ResourceLocation.withDefaultNamespace((String)"trims/color_palettes/quartz"));
        map.put("iron", ResourceLocation.withDefaultNamespace((String)"trims/color_palettes/iron"));
        map.put("gold", ResourceLocation.withDefaultNamespace((String)"trims/color_palettes/gold"));
        map.put("diamond", ResourceLocation.withDefaultNamespace((String)"trims/color_palettes/diamond"));
        map.put("netherite", ResourceLocation.withDefaultNamespace((String)"trims/color_palettes/netherite"));
        map.put("redstone", ResourceLocation.withDefaultNamespace((String)"trims/color_palettes/redstone"));
        map.put("copper", ResourceLocation.withDefaultNamespace((String)"trims/color_palettes/copper"));
        map.put("emerald", ResourceLocation.withDefaultNamespace((String)"trims/color_palettes/emerald"));
        map.put("lapis", ResourceLocation.withDefaultNamespace((String)"trims/color_palettes/lapis"));
        map.put("amethyst", ResourceLocation.withDefaultNamespace((String)"trims/color_palettes/amethyst"));
        map.put("iron_darker", ResourceLocation.withDefaultNamespace((String)"trims/color_palettes/iron_darker"));
        map.put("gold_darker", ResourceLocation.withDefaultNamespace((String)"trims/color_palettes/gold_darker"));
        map.put("diamond_darker", ResourceLocation.withDefaultNamespace((String)"trims/color_palettes/diamond_darker"));
        map.put("netherite_darker", ResourceLocation.withDefaultNamespace((String)"trims/color_palettes/netherite_darker"));
    });
    private static final List<ResourceLocation> ITEM_TRIMS = List.of(ResourceLocation.withDefaultNamespace((String)"trims/items/helmet_trim"), ResourceLocation.withDefaultNamespace((String)"trims/items/chestplate_trim"), ResourceLocation.withDefaultNamespace((String)"trims/items/leggings_trim"), ResourceLocation.withDefaultNamespace((String)"trims/items/boots_trim"));
    public static final ResourceLocation TRIM_TYPE_PREDICATE_ID = Blueprint.location("trim_type");
    private static final LinkedHashMap<ResourceKey<TrimMaterial>, Pair<TrimMaterial, Float>> GENERATED_OVERRIDE_INDICES = new LinkedHashMap();
    private static final ArrayList<RevertibleOverrides> REVERTIBLE_OVERRIDES = new ArrayList();

    public static void init() {
        ItemProperties.registerGeneric((ResourceLocation)TRIM_TYPE_PREDICATE_ID, (stack, level, entity, num) -> {
            Pair<TrimMaterial, Float> pair;
            Holder trimMaterialHolder;
            Optional key;
            ArmorTrim armorTrim;
            if (stack.is(ItemTags.TRIMMABLE_ARMOR) && level != null && (armorTrim = (ArmorTrim)stack.get(DataComponents.TRIM)) != null && (key = (trimMaterialHolder = armorTrim.material()).unwrapKey()).isPresent() && (pair = GENERATED_OVERRIDE_INDICES.get(key.get())) != null) {
                return ((Float)pair.getSecond()).floatValue();
            }
            return Float.NEGATIVE_INFINITY;
        });
    }

    @SafeVarargs
    public static BlueprintPalettedPermutations patternPermutationsOfVanillaMaterials(ResourceKey<TrimPattern> ... keys) {
        ArrayList<ResourceLocation> textures = new ArrayList<ResourceLocation>(keys.length << 1);
        for (ResourceKey<TrimPattern> key : keys) {
            ResourceLocation location = key.location();
            textures.add(location.withPath(string -> "trims/models/armor/" + string));
            textures.add(location.withPath(string -> "trims/models/armor/" + string + "_leggings"));
        }
        return new BlueprintPalettedPermutations((Either<List<SpriteSource>, List<ResourceLocation>>)Either.right(textures), PALETTE_KEY, PERMUTATIONS);
    }

    @SafeVarargs
    private static HashMap<String, ResourceLocation> getPermutations(ResourceKey<TrimMaterial> ... keys) {
        HashMap<String, ResourceLocation> permutations = new HashMap<String, ResourceLocation>();
        for (ResourceKey<TrimMaterial> key : keys) {
            ResourceLocation location = key.location();
            permutations.put(location.getNamespace() + "_" + location.getPath(), location.withPath(string -> "trims/color_palettes/" + string));
        }
        return permutations;
    }

    @SafeVarargs
    public static BlueprintPalettedPermutations materialPatternPermutations(ResourceKey<TrimMaterial> ... keys) {
        return new BlueprintPalettedPermutations((Either<List<SpriteSource>, List<ResourceLocation>>)Either.left(List.of(new DirectoryLister("trims/models/armor", "trims/models/armor/"))), PALETTE_KEY, BlueprintTrims.getPermutations(keys));
    }

    @SafeVarargs
    public static BlueprintPalettedPermutations materialPermutationsForItemLayers(ResourceKey<TrimMaterial> ... keys) {
        return new BlueprintPalettedPermutations((Either<List<SpriteSource>, List<ResourceLocation>>)Either.right(ITEM_TRIMS), PALETTE_KEY, BlueprintTrims.getPermutations(keys));
    }

    private static ResourceLocation generateModelOverrideLocation(String namespace, ResourceLocation itemName, String assetName, ArrayList<ItemOverride.Predicate> predicates) {
        StringBuilder builder = new StringBuilder();
        builder.append(itemName.getNamespace()).append('/').append(itemName.getPath()).append('_').append(assetName).append("_trim");
        for (ItemOverride.Predicate predicate : predicates) {
            builder.append('_').append(predicate.getProperty().getNamespace()).append('_');
            String path = predicate.getProperty().getPath();
            int length = path.length();
            for (int i = 0; i < length; ++i) {
                char c = path.charAt(i);
                builder.append(c == '/' ? (char)'_' : (char)c);
            }
            builder.append('_').append(predicate.getValue());
        }
        return Blueprint.location(builder.toString());
    }

    private static ItemOverrides.BakedOverride createBakedOverride(ItemOverrides.PropertyMatcher[] matchers, ModelBakery bakery, ModelBakery.TextureGetter textureGetter, ResourceLocation location, ResourceLocation unbakedLocation) {
        ModelBakery modelBakery = bakery;
        Objects.requireNonNull(modelBakery);
        return new ItemOverrides.BakedOverride(matchers, new ModelBakery.ModelBakerImpl(modelBakery, textureGetter, ModelResourceLocation.inventory((ResourceLocation)location)).bake(unbakedLocation, (ModelState)BlockModelRotation.X0_Y0));
    }

    private static void modifyTrimmableItemModels(RegistryAccess registryAccess) {
        if (GENERATED_OVERRIDE_INDICES.isEmpty()) {
            return;
        }
        Registry itemRegistry = registryAccess.registryOrThrow(Registries.ITEM);
        Optional trimmableArmorTag = itemRegistry.getTag(ItemTags.TRIMMABLE_ARMOR);
        if (trimmableArmorTag.isEmpty()) {
            return;
        }
        Registry trimMaterials = registryAccess.registryOrThrow(Registries.TRIM_MATERIAL);
        int armorItemTypeCount = ITEM_TRIMS.size();
        HashMap[] trimTextureForArmorItemType = new HashMap[armorItemTypeCount];
        for (int i = 0; i < armorItemTypeCount; ++i) {
            HashMap<Float, ResourceLocation> map = new HashMap<Float, ResourceLocation>();
            ResourceLocation trimTextureBase = ITEM_TRIMS.get(i);
            for (Map.Entry entry : trimMaterials.entrySet()) {
                if (!((ResourceKey)entry.getKey()).location().getNamespace().equals("minecraft")) continue;
                TrimMaterial material2 = (TrimMaterial)entry.getValue();
                map.put(Float.valueOf(material2.itemModelIndex()), trimTextureBase.withSuffix("_" + material2.assetName()));
            }
            trimTextureForArmorItemType[i] = map;
        }
        ModelManager modelManager = Minecraft.getInstance().getModelManager();
        ModelBakery modelBakery = modelManager.getModelBakery();
        Map unbakedModels = modelBakery.unbakedCache;
        ModelBakery.TextureGetter textureGetter = (location, material) -> modelManager.getAtlas(material.atlasLocation()).getSprite(material.texture());
        ((HolderSet.Named)trimmableArmorTag.get()).forEach(itemHolder -> {
            Object patt0$temp = itemHolder.value();
            if (!(patt0$temp instanceof ArmorItem)) {
                return;
            }
            ArmorItem armorItem = (ArmorItem)patt0$temp;
            Optional itemKeyOptional = itemHolder.unwrapKey();
            if (itemKeyOptional.isEmpty()) {
                return;
            }
            ResourceLocation itemName = ((ResourceKey)itemKeyOptional.get()).location();
            ItemOverrides bakedModelOverrides = modelManager.getModel(ModelResourceLocation.inventory((ResourceLocation)itemName)).getOverrides();
            ItemOverrides.BakedOverride[] overrides = bakedModelOverrides.overrides;
            int overridesLength = overrides.length;
            if (overridesLength == 0) {
                return;
            }
            UnbakedModel unbakedInventoryModel = (UnbakedModel)unbakedModels.get(itemName.withPrefix("item/"));
            if (!(unbakedInventoryModel instanceof BlockModel)) {
                return;
            }
            BlockModel unbakedBlockModel = (BlockModel)unbakedInventoryModel;
            List unbakedOverrides = unbakedBlockModel.getOverrides();
            if (unbakedOverrides.size() > overridesLength) {
                return;
            }
            int armorItemTypeIndex = armorItem.getType().ordinal();
            ResourceLocation armorTrimTypeLocation = ITEM_TRIMS.get(armorItemTypeIndex);
            HashMap indexToItemTrimTexture = trimTextureForArmorItemType[armorItemTypeIndex];
            HashMap significantOverrides = new HashMap();
            for (int i = unbakedOverrides.size() - 1; i > -1; --i) {
                ItemOverride override = (ItemOverride)unbakedOverrides.get(i);
                UnbakedModel unbakedOverrideModel = (UnbakedModel)unbakedModels.get(override.getModel());
                if (!(unbakedOverrideModel instanceof BlockModel)) continue;
                BlockModel overrideBlockModel = (BlockModel)unbakedOverrideModel;
                Iterator predicatesIterator = override.getPredicates().iterator();
                boolean foundReplicableTrimOverride = false;
                ArrayList<ItemOverride.Predicate> predicates = new ArrayList<ItemOverride.Predicate>();
                ArrayList trimKeysInTextureMap = new ArrayList();
                while (predicatesIterator.hasNext()) {
                    ItemOverride.Predicate predicate = (ItemOverride.Predicate)predicatesIterator.next();
                    if (!foundReplicableTrimOverride && predicate.getProperty().equals((Object)ItemModelGenerators.TRIM_TYPE_PREDICATE_ID)) {
                        ResourceLocation validTexture = (ResourceLocation)indexToItemTrimTexture.get(Float.valueOf(predicate.getValue()));
                        if (validTexture == null) break;
                        for (Map.Entry entry : overrideBlockModel.textureMap.entrySet()) {
                            Material material;
                            Optional materialOptional = ((Either)entry.getValue()).left();
                            if (materialOptional.isEmpty() || !(material = (Material)materialOptional.get()).atlasLocation().equals((Object)TextureAtlas.LOCATION_BLOCKS) || !material.texture().equals((Object)validTexture)) continue;
                            trimKeysInTextureMap.add((String)entry.getKey());
                            foundReplicableTrimOverride = true;
                        }
                        if (foundReplicableTrimOverride) continue;
                        break;
                    }
                    predicates.add(predicate);
                }
                if (!foundReplicableTrimOverride) continue;
                significantOverrides.putIfAbsent(predicates, Pair.of((Object)overrideBlockModel, trimKeysInTextureMap));
            }
            if (significantOverrides.isEmpty()) {
                return;
            }
            Object2IntOpenHashMap propertyToIndex = new Object2IntOpenHashMap();
            propertyToIndex.defaultReturnValue(-1);
            ResourceLocation[] properties = bakedModelOverrides.properties;
            int oldLength = properties.length;
            ResourceLocation[] newProperties = new ResourceLocation[oldLength + 1];
            for (int i = 0; i < oldLength; ++i) {
                newProperties[i] = properties[i];
                propertyToIndex.put((Object)newProperties[i], i);
            }
            newProperties[oldLength] = TRIM_TYPE_PREDICATE_ID;
            bakedModelOverrides.properties = newProperties;
            Holder armorMaterial = armorItem.getMaterial();
            ItemOverrides.BakedOverride[] bakedOverridesToAdd = new ItemOverrides.BakedOverride[GENERATED_OVERRIDE_INDICES.size() * significantOverrides.size()];
            int i = bakedOverridesToAdd.length;
            for (Map.Entry entry : GENERATED_OVERRIDE_INDICES.entrySet()) {
                Pair value = (Pair)entry.getValue();
                TrimMaterial trimMaterial = (TrimMaterial)value.getFirst();
                ResourceKey trimMaterialKey = (ResourceKey)entry.getKey();
                String trimMaterialNamespace = trimMaterialKey.location().getNamespace();
                String assetName = trimMaterial.overrideArmorMaterials().getOrDefault(armorMaterial, trimMaterial.assetName());
                float overrideIndex = ((Float)value.getSecond()).floatValue();
                ResourceLocation textureLocation = armorTrimTypeLocation.withSuffix("_" + assetName);
                Either texture = Either.left((Object)new Material(TextureAtlas.LOCATION_BLOCKS, textureLocation));
                block5: for (Map.Entry significantOverride : significantOverrides.entrySet()) {
                    ArrayList predicates = (ArrayList)significantOverride.getKey();
                    int predicateCount = predicates.size();
                    ItemOverrides.PropertyMatcher[] matchers = new ItemOverrides.PropertyMatcher[predicateCount + 1];
                    matchers[0] = new ItemOverrides.PropertyMatcher(oldLength, overrideIndex);
                    for (int j = 0; j < predicateCount; ++j) {
                        ItemOverride.Predicate predicate = (ItemOverride.Predicate)predicates.get(j);
                        int index = propertyToIndex.getInt((Object)predicate.getProperty());
                        if (index <= 0) continue block5;
                        matchers[j + 1] = new ItemOverrides.PropertyMatcher(index, predicate.getValue());
                    }
                    Pair modelAndReplaceableTextures = (Pair)significantOverride.getValue();
                    BlockModel model = (BlockModel)modelAndReplaceableTextures.getFirst();
                    ResourceLocation overrideLocation = BlueprintTrims.generateModelOverrideLocation(trimMaterialNamespace, itemName, assetName, predicates);
                    ResourceLocation overrideModelLocation = overrideLocation.withPrefix("item/");
                    if (unbakedModels.containsKey(overrideModelLocation)) {
                        bakedOverridesToAdd[--i] = BlueprintTrims.createBakedOverride(matchers, modelBakery, textureGetter, overrideLocation, overrideModelLocation);
                        continue;
                    }
                    ArrayList replaceableTextures = (ArrayList)modelAndReplaceableTextures.getSecond();
                    Map textureMap = model.textureMap;
                    Either[] oldValues = new Either[replaceableTextures.size()];
                    int j = 0;
                    while (j < replaceableTextures.size()) {
                        String replaceableTexture = (String)replaceableTextures.get(j);
                        Either oldValue = (Either)textureMap.get(replaceableTexture);
                        oldValues[j++] = oldValue;
                        textureMap.put(replaceableTexture, texture);
                    }
                    unbakedModels.put(overrideModelLocation, model);
                    bakedOverridesToAdd[--i] = BlueprintTrims.createBakedOverride(matchers, modelBakery, textureGetter, overrideLocation, overrideModelLocation);
                    j = 0;
                    while (j < replaceableTextures.size()) {
                        textureMap.put((String)replaceableTextures.get(j), oldValues[j++]);
                    }
                    unbakedModels.remove(overrideModelLocation);
                }
            }
            int bakedOverridesToAddLength = bakedOverridesToAdd.length;
            int n = bakedOverridesToAddLength - i;
            ItemOverrides.BakedOverride[] newOverrides = new ItemOverrides.BakedOverride[overridesLength + n];
            System.arraycopy(bakedOverridesToAdd, i, newOverrides, 0, n);
            System.arraycopy(overrides, 0, newOverrides, n, overridesLength);
            bakedModelOverrides.overrides = newOverrides;
            REVERTIBLE_OVERRIDES.add(new RevertibleOverrides(bakedModelOverrides, overrides, properties));
        });
    }

    @SubscribeEvent
    public static void onClientLoggingIntoServer(ClientPlayerNetworkEvent.LoggingIn event) {
        RegistryAccess registryAccess = event.getPlayer().clientLevel.registryAccess();
        Registry trimMaterials = registryAccess.registryOrThrow(Registries.TRIM_MATERIAL);
        Optional neededTrimMaterialsOptional = trimMaterials.getTag(BlueprintTrimMaterialTags.GENERATES_OVERRIDES);
        if (neededTrimMaterialsOptional.isEmpty()) {
            return;
        }
        HolderSet.Named neededTrimMaterials = (HolderSet.Named)neededTrimMaterialsOptional.get();
        if (neededTrimMaterials.size() == 0) {
            return;
        }
        neededTrimMaterials.forEach(trimMaterialHolder -> {
            Optional key = trimMaterialHolder.unwrapKey();
            if (key.isEmpty()) {
                return;
            }
            GENERATED_OVERRIDE_INDICES.put((ResourceKey<TrimMaterial>)((ResourceKey)key.get()), (Pair<TrimMaterial, Float>)Pair.of((Object)((TrimMaterial)trimMaterialHolder.value()), (Object)Float.valueOf(GENERATED_OVERRIDE_INDICES.size())));
        });
        BlueprintTrims.modifyTrimmableItemModels(registryAccess);
    }

    @SubscribeEvent
    public static void onClientLoggingOutOfServer(ClientPlayerNetworkEvent.LoggingOut event) {
        for (int i = REVERTIBLE_OVERRIDES.size() - 1; i > -1; --i) {
            REVERTIBLE_OVERRIDES.remove(i).revert();
        }
        GENERATED_OVERRIDE_INDICES.clear();
    }

    public static void onModelsBaked(ModelEvent.BakingCompleted event) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        REVERTIBLE_OVERRIDES.clear();
        BlueprintTrims.modifyTrimmableItemModels(level.registryAccess());
    }

    private record RevertibleOverrides(ItemOverrides itemOverrides, ItemOverrides.BakedOverride[] overrides, ResourceLocation[] properties) {
        private void revert() {
            this.itemOverrides.overrides = this.overrides;
            this.itemOverrides.properties = this.properties;
        }
    }
}

