/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.api.conditions.config;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.teamabnormals.blueprint.core.Blueprint;
import com.teamabnormals.blueprint.core.api.conditions.config.IConfigPredicate;
import com.teamabnormals.blueprint.core.api.conditions.config.IConfigPredicateSerializer;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.ModConfigSpec;

public class LessThanPredicate
implements IConfigPredicate {
    private static final ResourceLocation ID = Blueprint.location("less_than");
    private final double value;

    public LessThanPredicate(double value) {
        this.value = value;
    }

    @Override
    public ResourceLocation getID() {
        return ID;
    }

    @Override
    public boolean test(ModConfigSpec.ConfigValue<?> toCompare) {
        try {
            return ((Number)toCompare.get()).doubleValue() < this.value;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Invalid config value type; must hold a number");
        }
    }

    public static class Serializer
    implements IConfigPredicateSerializer<LessThanPredicate> {
        private static final ResourceLocation ID = Blueprint.location("less_than");

        @Override
        public void write(JsonObject json, IConfigPredicate value) {
            if (!(value instanceof LessThanPredicate)) {
                throw new IllegalArgumentException("Incompatible predicate type");
            }
            json.addProperty("value", (Number)((LessThanPredicate)value).value);
        }

        @Override
        public LessThanPredicate read(JsonObject json) {
            if (!json.has("value")) {
                throw new JsonSyntaxException("Missing 'value', expected to find a number");
            }
            try {
                return new LessThanPredicate(json.get("value").getAsDouble());
            }
            catch (ClassCastException | IllegalStateException e) {
                throw new JsonSyntaxException("'value' does not contain a number");
            }
        }

        @Override
        public ResourceLocation getID() {
            return ID;
        }
    }
}

