/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.data.client;

import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.common.block.sign.BlueprintCeilingHangingSignBlock;
import com.teamabnormals.blueprint.common.block.sign.BlueprintStandingSignBlock;
import com.teamabnormals.blueprint.common.block.sign.BlueprintWallHangingSignBlock;
import com.teamabnormals.blueprint.common.block.sign.BlueprintWallSignBlock;
import com.teamabnormals.blueprint.core.Blueprint;
import com.teamabnormals.blueprint.core.data.client.BlueprintItemModelProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;

public abstract class BlueprintBlockStateProvider
extends BlockStateProvider {
    public static final String[] DEFAULT_BOOKSHELF_POSITIONS = new String[]{"top_left", "top_mid", "top_right", "bottom_left", "bottom_mid", "bottom_right"};
    public static final String[] ALTERNATE_BOOKSHELF_POSITIONS = new String[]{"top_left", "top_right", "mid_left", "mid_right", "bottom_left", "bottom_right"};
    public static final String[] BOTTOM_BOOKSHELF_POSITIONS = new String[]{"top_left", "top_right", "bottom_left", "bottom_mid_left", "bottom_mid_right", "bottom_right"};

    public BlueprintBlockStateProvider(PackOutput output, String modid, ExistingFileHelper helper) {
        super(output, modid, helper);
    }

    public void block(Block block) {
        this.simpleBlock(block);
        this.blockItem(block);
    }

    public void block(DeferredHolder<Block, ?> block) {
        this.block((Block)block.get());
    }

    public void blockItem(Block block) {
        this.simpleBlockItem(block, (ModelFile)new ModelFile.ExistingModelFile(this.blockTexture(block), this.models().existingFileHelper));
    }

    public void blockItem(DeferredHolder<Block, ?> block) {
        this.blockItem((Block)block.get());
    }

    public void generatedItem(ItemLike item, String type) {
        this.generatedItem(item, item, type);
    }

    public void generatedItem(ItemLike item, ItemLike texture, String type) {
        this.generatedItem(item, BlueprintBlockStateProvider.prefix(type + "/", BlueprintItemModelProvider.key(texture)));
    }

    public void generatedItem(ItemLike item, ResourceLocation texture) {
        ((ItemModelBuilder)this.itemModels().withExistingParent(BuiltInRegistries.ITEM.getKey((Object)item.asItem()).getPath(), "item/generated")).texture("layer0", texture);
    }

    public void cubeBottomTopBlock(DeferredHolder<Block, ?> block) {
        ResourceLocation name = BuiltInRegistries.BLOCK.getKey((Object)((Block)block.get()));
        this.cubeBottomTopBlock(block, BlueprintBlockStateProvider.prefix("block/", BlueprintBlockStateProvider.suffix(name, "_side")), BlueprintBlockStateProvider.prefix("block/", BlueprintBlockStateProvider.suffix(name, "_bottom")), BlueprintBlockStateProvider.prefix("block/", BlueprintBlockStateProvider.suffix(name, "_top")));
    }

    public void cubeBottomTopBlock(DeferredHolder<Block, ?> block, ResourceLocation sideTexture, ResourceLocation bottomTexture, ResourceLocation topTexture) {
        this.simpleBlock((Block)block.get(), (ModelFile)this.models().cubeBottomTop(BlueprintBlockStateProvider.name((Block)block.get()), sideTexture, bottomTexture, topTexture));
        this.blockItem(block);
    }

    public void cubeColumnBlock(DeferredHolder<Block, ?> block) {
        ResourceLocation name = BuiltInRegistries.BLOCK.getKey((Object)((Block)block.get()));
        this.cubeColumnBlock(block, BlueprintBlockStateProvider.prefix("block/", name), BlueprintBlockStateProvider.prefix("block/", BlueprintBlockStateProvider.suffix(name, "_top")));
    }

    public void cubeColumnBlock(DeferredHolder<Block, ?> block, ResourceLocation sideTexture, ResourceLocation topTexture) {
        this.simpleBlock((Block)block.get(), (ModelFile)this.models().cubeColumn(BlueprintBlockStateProvider.name((Block)block.get()), sideTexture, topTexture));
        this.blockItem(block);
    }

    public void directionalBlock(DeferredHolder<Block, ?> block, ResourceLocation sideTexture, ResourceLocation bottomTexture, ResourceLocation topTexture) {
        this.directionalBlock((Block)block.get(), (ModelFile)this.models().cubeBottomTop(BlueprintBlockStateProvider.name((Block)block.get()), sideTexture, bottomTexture, topTexture));
        this.blockItem(block);
    }

    public void directionalBlock(DeferredHolder<Block, ?> block) {
        ResourceLocation blockTexture = this.blockTexture((Block)block.get());
        this.directionalBlock(block, BlueprintBlockStateProvider.suffix(blockTexture, "_side"), BlueprintBlockStateProvider.suffix(blockTexture, "_bottom"), BlueprintBlockStateProvider.suffix(blockTexture, "_top"));
    }

    public void directionalBlockSharedSide(DeferredHolder<Block, ?> block, DeferredHolder<Block, ?> parent) {
        ResourceLocation parentTexture = this.blockTexture((Block)parent.get());
        this.directionalBlock(block, BlueprintBlockStateProvider.suffix(parentTexture, "_side"), BlueprintBlockStateProvider.suffix(parentTexture, "_bottom"), BlueprintBlockStateProvider.suffix(this.blockTexture((Block)block.get()), "_top"));
    }

    public void directionalBlockSharedBottom(DeferredHolder<Block, ?> block, DeferredHolder<Block, ?> parent) {
        ResourceLocation blockTexture = this.blockTexture((Block)block.get());
        this.directionalBlock(block, BlueprintBlockStateProvider.suffix(blockTexture, "_side"), BlueprintBlockStateProvider.suffix(this.blockTexture((Block)parent.get()), "_bottom"), BlueprintBlockStateProvider.suffix(blockTexture, "_top"));
    }

    public void crossBlock(DeferredHolder<Block, ?> cross) {
        this.simpleBlock((Block)cross.get(), (ModelFile)this.models().cross(BlueprintBlockStateProvider.name((Block)cross.get()), this.blockTexture((Block)cross.get())));
        this.generatedItem((ItemLike)cross.get(), "block");
    }

    public void crossBlockWithPot(DeferredHolder<Block, ?> cross, DeferredHolder<Block, ?> flowerPot, ResourceLocation potTexture) {
        this.crossBlock(cross);
        this.simpleBlock((Block)flowerPot.get(), (ModelFile)this.models().singleTexture(BlueprintBlockStateProvider.name((Block)flowerPot.get()), ResourceLocation.withDefaultNamespace((String)"block/flower_pot_cross"), "plant", potTexture));
    }

    public void crossBlockWithPot(DeferredHolder<Block, ?> cross, DeferredHolder<Block, ?> flowerPot) {
        this.crossBlockWithPot(cross, flowerPot, this.blockTexture((Block)cross.get()));
    }

    public void crossBlockWithCustomPot(DeferredHolder<Block, ?> cross, DeferredHolder<Block, ?> flowerPot) {
        this.crossBlockWithPot(cross, flowerPot, this.blockTexture((Block)flowerPot.get()));
    }

    public void slabBlock(Block block, Block slab) {
        if (slab instanceof SlabBlock) {
            SlabBlock slabBlock = (SlabBlock)slab;
            this.slabBlock(slabBlock, this.blockTexture(block), this.blockTexture(block));
            this.blockItem(slab);
        }
    }

    public void stairsBlock(Block block, Block stairs) {
        if (stairs instanceof StairBlock) {
            StairBlock stairBlock = (StairBlock)stairs;
            this.stairsBlock(stairBlock, this.blockTexture(block));
            this.blockItem(stairs);
        }
    }

    public void wallBlock(Block block, Block wall) {
        if (wall instanceof WallBlock) {
            WallBlock wallBlock = (WallBlock)wall;
            this.wallBlock(wallBlock, this.blockTexture(block));
            ((ItemModelBuilder)this.itemModels().getBuilder(BlueprintBlockStateProvider.name(wall))).parent((ModelFile)this.models().wallInventory(BlueprintBlockStateProvider.name(wall) + "_inventory", this.blockTexture(block)));
        }
    }

    public void baseBlocks(DeferredHolder<Block, ?> block, DeferredHolder<Block, ?> stairs, DeferredHolder<Block, ?> slab) {
        this.baseBlocks((Block)block.get(), (Block)stairs.get(), (Block)slab.get(), null);
    }

    public void baseBlocks(DeferredHolder<Block, ?> block, DeferredHolder<Block, ?> stairs, DeferredHolder<Block, ?> slab, DeferredHolder<Block, ?> wall) {
        this.baseBlocks((Block)block.get(), (Block)stairs.get(), (Block)slab.get(), (Block)wall.get());
    }

    public void baseBlocks(Block block, Block stairs, Block slab) {
        this.baseBlocks(block, stairs, slab, null);
    }

    public void baseBlocks(Block block, Block stairs, Block slab, Block wall) {
        this.block(block);
        this.stairsBlock(block, stairs);
        this.slabBlock(block, slab);
        this.wallBlock(block, wall);
    }

    public void fenceBlock(Block block, Block fence) {
        if (fence instanceof FenceBlock) {
            FenceBlock fenceBlock = (FenceBlock)fence;
            this.fenceBlock(fenceBlock, this.blockTexture(block));
            ((ItemModelBuilder)this.itemModels().getBuilder(BlueprintBlockStateProvider.name(fence))).parent((ModelFile)this.models().fenceInventory(BlueprintBlockStateProvider.name(fence) + "_inventory", this.blockTexture(block)));
        }
    }

    public void fenceGateBlock(Block block, Block fenceGate) {
        if (fenceGate instanceof FenceGateBlock) {
            FenceGateBlock fenceGateBlock = (FenceGateBlock)fenceGate;
            this.fenceGateBlock(fenceGateBlock, this.blockTexture(block));
            this.blockItem(fenceGate);
        }
    }

    public void fenceBlocks(Block block, Block fence, Block fenceGate) {
        this.fenceBlock(block, fence);
        this.fenceGateBlock(block, fenceGate);
    }

    public void doorBlock(Block door) {
        if (door instanceof DoorBlock) {
            DoorBlock doorBlock = (DoorBlock)door;
            this.doorBlock(doorBlock, BlueprintBlockStateProvider.suffix(this.blockTexture(door), "_bottom"), BlueprintBlockStateProvider.suffix(this.blockTexture(door), "_top"));
            this.generatedItem((ItemLike)door, "item");
        }
    }

    public void trapDoorBlock(Block trapDoor) {
        if (trapDoor instanceof TrapDoorBlock) {
            TrapDoorBlock trapDoorBlock = (TrapDoorBlock)trapDoor;
            this.trapdoorBlock(trapDoorBlock, this.blockTexture(trapDoor), true);
            ((ItemModelBuilder)this.itemModels().getBuilder(BlueprintBlockStateProvider.name(trapDoor))).parent((ModelFile)this.models().trapdoorOrientableBottom(BlueprintBlockStateProvider.name(trapDoor) + "_bottom", this.blockTexture(trapDoor)));
        }
    }

    public void doorBlocks(Block door, Block trapdoor) {
        this.doorBlock(door);
        this.trapDoorBlock(trapdoor);
    }

    public void signBlocks(DeferredHolder<Block, ?> planks, Pair<DeferredBlock<BlueprintStandingSignBlock>, DeferredBlock<BlueprintWallSignBlock>> signs) {
        this.hangingSignBlocks(planks, (DeferredHolder)signs.getFirst(), (DeferredHolder)signs.getSecond());
    }

    public void signBlocks(Block block, Block sign, Block wallSign) {
        if (sign != null && wallSign != null) {
            ModelFile model = this.particle(sign, this.blockTexture(block));
            this.simpleBlock(sign, model);
            this.generatedItem((ItemLike)sign, "item");
            this.simpleBlock(wallSign, model);
        }
    }

    public void hangingSignBlocks(DeferredHolder<Block, ?> strippedLog, Pair<DeferredBlock<BlueprintCeilingHangingSignBlock>, DeferredBlock<BlueprintWallHangingSignBlock>> hangingSigns) {
        this.hangingSignBlocks(strippedLog, (DeferredHolder)hangingSigns.getFirst(), (DeferredHolder)hangingSigns.getSecond());
    }

    public void hangingSignBlocks(DeferredHolder<Block, ?> strippedLog, DeferredHolder<? extends Block, ?> sign, DeferredHolder<? extends Block, ?> wallSign) {
        ModelFile model = this.particle(sign, this.blockTexture((Block)strippedLog.get()));
        this.simpleBlock((Block)sign.get(), model);
        this.generatedItem((ItemLike)sign.get(), "item");
        this.simpleBlock((Block)wallSign.get(), model);
    }

    public void buttonBlock(Block block, Block button) {
        this.buttonBlock(button, this.blockTexture(block));
    }

    public void buttonBlock(Block block, ResourceLocation texture) {
        ModelBuilder button = this.models().button(BlueprintBlockStateProvider.name(block), texture);
        ModelBuilder buttonPressed = this.models().buttonPressed(BlueprintBlockStateProvider.name(block) + "_pressed", texture);
        ModelBuilder buttonInventoryModel = this.models().buttonInventory(BlueprintBlockStateProvider.name(block) + "_inventory", texture);
        if (block instanceof ButtonBlock) {
            ButtonBlock buttonBlock = (ButtonBlock)block;
            this.buttonBlock(buttonBlock, (ModelFile)button, (ModelFile)buttonPressed);
        }
        ((ItemModelBuilder)this.itemModels().getBuilder(BlueprintBlockStateProvider.name(block))).parent((ModelFile)buttonInventoryModel);
    }

    public void pressurePlateBlock(Block block, Block pressurePlate) {
        this.pressurePlateBlock(pressurePlate, this.blockTexture(block));
    }

    public void pressurePlateBlock(Block block, ResourceLocation texture) {
        ModelBuilder pressurePlate = this.models().pressurePlate(BlueprintBlockStateProvider.name(block), texture);
        ModelBuilder pressurePlateDown = this.models().pressurePlateDown(BlueprintBlockStateProvider.name(block) + "_down", texture);
        this.getVariantBuilder(block).partialState().with((Property)PressurePlateBlock.POWERED, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)pressurePlateDown)}).partialState().with((Property)PressurePlateBlock.POWERED, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)pressurePlate)});
        this.blockItem(block);
    }

    public void boardsBlock(DeferredHolder<Block, ?> boards) {
        ModelBuilder boardsModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(BlueprintBlockStateProvider.name((Block)boards.get()))).parent((ModelFile)new ModelFile.UncheckedModelFile(Blueprint.location("block/template_boards")))).texture("all", this.blockTexture((Block)boards.get()));
        ModelBuilder boardsHorizontalModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(BlueprintBlockStateProvider.name((Block)boards.get()) + "_horizontal")).parent((ModelFile)new ModelFile.UncheckedModelFile(Blueprint.location("block/template_boards_horizontal")))).texture("all", this.blockTexture((Block)boards.get()));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)boards.get()).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Y).modelForState().modelFile((ModelFile)boardsModel).addModel()).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)boardsHorizontalModel).addModel()).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)boardsHorizontalModel).rotationY(270).addModel();
        this.blockItem(boards);
    }

    public void bookshelfBlock(DeferredHolder<Block, ?> planks, DeferredHolder<Block, ?> bookshelf) {
        this.bookshelfBlock((Block)planks.get(), bookshelf);
    }

    public void bookshelfBlock(Block planks, DeferredHolder<Block, ?> bookshelf) {
        this.simpleBlock((Block)bookshelf.get(), (ModelFile)this.models().cubeColumn(BlueprintBlockStateProvider.name((Block)bookshelf.get()), this.blockTexture((Block)bookshelf.get()), this.blockTexture(planks)));
        this.blockItem(bookshelf);
    }

    public void chiseledBookshelfBlock(DeferredHolder<Block, ?> registryObject) {
        this.chiseledBookshelfBlock(registryObject, DEFAULT_BOOKSHELF_POSITIONS, ResourceLocation.withDefaultNamespace((String)"template_chiseled_bookshelf"));
    }

    public void chiseledBookshelfBlock(DeferredHolder<Block, ?> registryObject, String[] parts) {
        this.chiseledBookshelfBlock(registryObject, parts, this.blockTexture((Block)registryObject.get()));
    }

    public void chiseledBookshelfBlock(DeferredHolder<Block, ?> registryObject, String[] parts, ResourceLocation parent) {
        Block chiseledBookshelf = (Block)registryObject.get();
        String name = BlueprintBlockStateProvider.name(chiseledBookshelf);
        ResourceLocation texture = this.blockTexture(chiseledBookshelf);
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, "block/chiseled_bookshelf")).texture("top", String.valueOf(texture) + "_top")).texture("side", String.valueOf(texture) + "_side");
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(chiseledBookshelf);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            int rotation = (int)(direction.toYRot() + 180.0f) % 360;
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).rotationY(rotation).uvLock(true).addModel()).condition((Property)HorizontalDirectionalBlock.FACING, (Comparable[])new Direction[]{direction});
            for (int i = 0; i < 6; ++i) {
                String part = parts[i];
                BooleanProperty property = (BooleanProperty)ChiseledBookShelfBlock.SLOT_OCCUPIED_PROPERTIES.get(i);
                ResourceLocation slot = BlueprintBlockStateProvider.suffix(parent, "_slot_" + part);
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(name + "_occupied_slot_" + part, slot)).texture("texture", String.valueOf(texture) + "_occupied")).rotationY(rotation).uvLock(true).addModel()).condition((Property)HorizontalDirectionalBlock.FACING, (Comparable[])new Direction[]{direction}).condition((Property)property, (Comparable[])new Boolean[]{true});
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(name + "_empty_slot_" + part, slot)).texture("texture", String.valueOf(texture) + "_empty")).rotationY(rotation).uvLock(true).addModel()).condition((Property)HorizontalDirectionalBlock.FACING, (Comparable[])new Direction[]{direction}).condition((Property)property, (Comparable[])new Boolean[]{false});
            }
        }
        this.simpleBlockItem(chiseledBookshelf, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_inventory", "block/chiseled_bookshelf_inventory")).texture("top", String.valueOf(texture) + "_top")).texture("side", String.valueOf(texture) + "_side")).texture("front", String.valueOf(texture) + "_empty"));
    }

    public void ladderBlock(DeferredHolder<Block, ?> ladder) {
        this.horizontalBlock((Block)ladder.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(BlueprintBlockStateProvider.name((Block)ladder.get()), "block/ladder")).texture("particle", this.blockTexture((Block)ladder.get()))).renderType("cutout")).texture("texture", this.blockTexture((Block)ladder.get())));
        this.generatedItem((ItemLike)ladder.get(), "block");
    }

    public void chestBlocks(DeferredHolder<Block, ?> planks, DeferredHolder<? extends Block, ?> chest, DeferredHolder<? extends Block, ?> trappedChest) {
        this.chestBlocks((Block)planks.get(), chest, trappedChest);
    }

    public void chestBlocks(Block planks, DeferredHolder<? extends Block, ?> chest, DeferredHolder<? extends Block, ?> trappedChest) {
        ModelFile model = this.particle(chest, this.blockTexture(planks));
        this.simpleBlock((Block)chest.get(), model);
        this.simpleBlock((Block)trappedChest.get(), model);
        this.simpleBlockItem((Block)chest.get(), (ModelFile)new ModelFile.UncheckedModelFile(Blueprint.location("item/template_chest")));
        this.simpleBlockItem((Block)trappedChest.get(), (ModelFile)new ModelFile.UncheckedModelFile(Blueprint.location("item/template_chest")));
    }

    public void beehiveBlock(DeferredHolder<Block, ?> registryObject) {
        Block block = (Block)registryObject.get();
        ModelBuilder beehive = ((BlockModelBuilder)this.models().orientableWithBottom(BlueprintBlockStateProvider.name(block), BlueprintBlockStateProvider.suffix(this.blockTexture(block), "_side"), BlueprintBlockStateProvider.suffix(this.blockTexture(block), "_front"), BlueprintBlockStateProvider.suffix(this.blockTexture(block), "_end"), BlueprintBlockStateProvider.suffix(this.blockTexture(block), "_end"))).texture("particle", BlueprintBlockStateProvider.suffix(this.blockTexture(block), "_side"));
        ModelBuilder beehiveHoney = ((BlockModelBuilder)this.models().orientableWithBottom(BlueprintBlockStateProvider.name(block) + "_honey", BlueprintBlockStateProvider.suffix(this.blockTexture(block), "_side"), BlueprintBlockStateProvider.suffix(this.blockTexture(block), "_front_honey"), BlueprintBlockStateProvider.suffix(this.blockTexture(block), "_end"), BlueprintBlockStateProvider.suffix(this.blockTexture(block), "_end"))).texture("particle", BlueprintBlockStateProvider.suffix(this.blockTexture(block), "_side"));
        this.horizontalBlock(block, arg_0 -> BlueprintBlockStateProvider.lambda$beehiveBlock$0((ModelFile)beehiveHoney, (ModelFile)beehive, arg_0));
        this.blockItem(block);
    }

    public void logBlocks(DeferredHolder<Block, ?> log, DeferredHolder<Block, ?> wood) {
        this.logBlock(log);
        this.woodBlock(wood, log);
    }

    public void woodBlock(DeferredHolder<Block, ?> block, DeferredHolder<Block, ?> log) {
        this.logBlock(block, this.blockTexture((Block)log.get()), this.blockTexture((Block)log.get()));
    }

    public void logBlock(DeferredHolder<Block, ?> block) {
        this.logBlock(block, this.blockTexture((Block)block.get()), BlueprintBlockStateProvider.suffix(this.blockTexture((Block)block.get()), "_top"));
    }

    public void logBlock(DeferredHolder<Block, ?> block, ResourceLocation sideTexture, ResourceLocation topTexture) {
        Object object = block.get();
        if (object instanceof RotatedPillarBlock) {
            RotatedPillarBlock log = (RotatedPillarBlock)object;
            this.axisBlock(log, sideTexture, topTexture);
            this.blockItem(block);
        }
    }

    public void leavesBlock(DeferredHolder<Block, ?> leaves) {
        this.simpleBlock((Block)leaves.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(BlueprintBlockStateProvider.name((Block)leaves.get()))).parent((ModelFile)new ModelFile.UncheckedModelFile(ResourceLocation.withDefaultNamespace((String)"block/leaves")))).texture("all", this.blockTexture((Block)leaves.get())));
        this.blockItem(leaves);
    }

    public void leafPileBlock(DeferredHolder<Block, ?> leaves, DeferredHolder<Block, ?> leafPile) {
        this.leafPileBlock((Block)leaves.get(), leafPile, true);
    }

    public void leafPileBlock(DeferredHolder<Block, ?> leaves, DeferredHolder<Block, ?> leafPile, boolean tint) {
        this.leafPileBlock((Block)leaves.get(), leafPile, tint);
    }

    public void leafPileBlock(Block leaves, DeferredHolder<Block, ?> leafPile) {
        this.leafPileBlock(leaves, leafPile, true);
    }

    public void leafPileBlock(Block leaves, DeferredHolder<Block, ?> leafPile, boolean tint) {
        this.leafPileBlock(leafPile, this.blockTexture(leaves), tint);
    }

    public void leafPileBlock(DeferredHolder<Block, ?> leafPile, ResourceLocation texture, boolean tint) {
        ModelBuilder leafPileModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(BlueprintBlockStateProvider.name((Block)leafPile.get()))).parent((ModelFile)new ModelFile.UncheckedModelFile(Blueprint.location("block/" + (tint ? "tinted_" : "") + "leaf_pile")))).renderType("cutout")).texture("all", texture);
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)leafPile.get());
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).rotationX(270).uvLock(true).addModel()).condition((Property)BlockStateProperties.UP, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).rotationX(270).uvLock(true).addModel()).condition((Property)BlockStateProperties.UP, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.WEST, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.SOUTH, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.EAST, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.DOWN, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).addModel()).condition((Property)BlockStateProperties.NORTH, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).addModel()).condition((Property)BlockStateProperties.UP, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.WEST, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.SOUTH, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.EAST, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.DOWN, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).rotationY(270).uvLock(true).addModel()).condition((Property)BlockStateProperties.WEST, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).rotationY(270).uvLock(true).addModel()).condition((Property)BlockStateProperties.UP, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.WEST, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.SOUTH, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.EAST, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.DOWN, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).rotationY(180).uvLock(true).addModel()).condition((Property)BlockStateProperties.SOUTH, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).rotationY(180).uvLock(true).addModel()).condition((Property)BlockStateProperties.UP, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.WEST, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.SOUTH, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.EAST, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.DOWN, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).rotationY(90).uvLock(true).addModel()).condition((Property)BlockStateProperties.EAST, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).rotationY(90).uvLock(true).addModel()).condition((Property)BlockStateProperties.UP, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.WEST, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.SOUTH, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.EAST, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.DOWN, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).rotationX(90).uvLock(true).addModel()).condition((Property)BlockStateProperties.DOWN, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).rotationX(90).uvLock(true).addModel()).condition((Property)BlockStateProperties.UP, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.WEST, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.SOUTH, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.EAST, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.DOWN, (Comparable[])new Boolean[]{false});
        this.generatedItem((ItemLike)leafPile.get(), texture);
    }

    public void leavesBlocks(DeferredHolder<Block, ?> leaves, DeferredHolder<Block, ?> leafPile) {
        this.leavesBlocks(leaves, leafPile, true);
    }

    public void leavesBlocks(DeferredHolder<Block, ?> leaves, DeferredHolder<Block, ?> leafPile, boolean tinted) {
        this.leavesBlock(leaves);
        this.leafPileBlock(leaves, leafPile, tinted);
    }

    public void ironBarsBlock(DeferredHolder<Block, ?> bars) {
        this.ironBarsBlock((Block)bars.get(), this.blockTexture((Block)bars.get()));
        this.generatedItem((ItemLike)bars.get(), "block");
    }

    public void ironBarsBlock(Block block, ResourceLocation texture) {
        String name = BlueprintBlockStateProvider.name(block);
        ResourceLocation edgeTexture = BlueprintBlockStateProvider.suffix(texture, "_edge");
        ModelBuilder post = this.ironBarsBlock(name, "post", texture).texture("bars", edgeTexture);
        ModelBuilder postEnds = this.ironBarsBlock(name, "post_ends", texture).texture("edge", edgeTexture);
        ModelBuilder side = ((BlockModelBuilder)this.ironBarsBlock(name, "side", texture).texture("bars", texture)).texture("edge", edgeTexture);
        ModelBuilder sideAlt = ((BlockModelBuilder)this.ironBarsBlock(name, "side_alt", texture).texture("bars", texture)).texture("edge", edgeTexture);
        ModelBuilder cap = ((BlockModelBuilder)this.ironBarsBlock(name, "cap", texture).texture("bars", texture)).texture("edge", edgeTexture);
        ModelBuilder capAlt = ((BlockModelBuilder)this.ironBarsBlock(name, "cap_alt", texture).texture("bars", texture)).texture("edge", edgeTexture);
        this.paneBlock(block, (ModelFile)post, (ModelFile)postEnds, (ModelFile)side, (ModelFile)sideAlt, (ModelFile)cap, (ModelFile)capAlt);
    }

    public BlockModelBuilder ironBarsBlock(String name, String suffix, ResourceLocation barsTexture) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name + "_" + suffix)).parent((ModelFile)new ModelFile.UncheckedModelFile(ResourceLocation.withDefaultNamespace((String)("block/iron_bars_" + suffix))))).texture("particle", barsTexture);
    }

    public void paneBlock(Block block, ModelFile post, ModelFile postEnds, ModelFile side, ModelFile sideAlt, ModelFile cap, ModelFile capAlt) {
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(block).part().modelFile(postEnds).addModel()).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(post).addModel()).condition((Property)BlockStateProperties.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.WEST, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.SOUTH, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.EAST, (Comparable[])new Boolean[]{false}).end();
        for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(direction == Direction.SOUTH || direction == Direction.WEST ? capAlt : cap).rotationY(direction.getAxis() == Direction.Axis.X ? 90 : 0).addModel()).condition((Property)BlockStateProperties.NORTH, (Comparable[])new Boolean[]{PipeBlock.PROPERTY_BY_DIRECTION.get(direction) == BlockStateProperties.NORTH}).condition((Property)BlockStateProperties.WEST, (Comparable[])new Boolean[]{PipeBlock.PROPERTY_BY_DIRECTION.get(direction) == BlockStateProperties.WEST}).condition((Property)BlockStateProperties.SOUTH, (Comparable[])new Boolean[]{PipeBlock.PROPERTY_BY_DIRECTION.get(direction) == BlockStateProperties.SOUTH}).condition((Property)BlockStateProperties.EAST, (Comparable[])new Boolean[]{PipeBlock.PROPERTY_BY_DIRECTION.get(direction) == BlockStateProperties.EAST}).end();
        }
        PipeBlock.PROPERTY_BY_DIRECTION.forEach((dir, value) -> {
            if (dir.getAxis().isHorizontal()) {
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(dir == Direction.SOUTH || dir == Direction.WEST ? sideAlt : side).rotationY(dir.getAxis() == Direction.Axis.X ? 90 : 0).addModel()).condition((Property)value, (Comparable[])new Boolean[]{true}).end();
            }
        });
    }

    public void brushableBlock(DeferredHolder<Block, ?> registryObject) {
        Block block = (Block)registryObject.get();
        ModelFile[] models = new ModelFile[4];
        for (int i = 0; i < 4; ++i) {
            models[i] = this.models().cubeAll(BlueprintBlockStateProvider.name(block) + "_" + i, BlueprintBlockStateProvider.suffix(this.blockTexture(block), "_" + i));
        }
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile(models[(Integer)state.getValue((Property)BlockStateProperties.DUSTED)]).build());
        this.simpleBlockItem(block, models[0]);
    }

    public ModelFile particle(Block block, ResourceLocation texture) {
        return ((BlockModelBuilder)this.models().getBuilder(BlueprintBlockStateProvider.name(block))).texture("particle", texture);
    }

    public ModelFile particle(DeferredHolder<? extends Block, ?> block, ResourceLocation texture) {
        return this.particle((Block)block.get(), texture);
    }

    public static String name(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
    }

    public static ResourceLocation prefix(String prefix, ResourceLocation rl) {
        return ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)(prefix + rl.getPath()));
    }

    public static ResourceLocation suffix(ResourceLocation rl, String suffix) {
        return ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)(rl.getPath() + suffix));
    }

    public static ResourceLocation remove(ResourceLocation rl, String remove) {
        return ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)rl.getPath().replace(remove, ""));
    }

    public void woodworksBlocks(Block planks, DeferredHolder<Block, ?> boards, DeferredHolder<Block, ?> ladder, DeferredHolder<Block, ?> bookshelf, DeferredHolder<Block, ?> beehive, DeferredHolder<? extends Block, ?> chest, DeferredHolder<? extends Block, ?> trappedChest) {
        this.boardsBlock(boards);
        this.ladderBlock(ladder);
        this.beehiveBlock(beehive);
        this.bookshelfBlock(planks, bookshelf);
        this.chestBlocks(planks, chest, trappedChest);
    }

    public void woodworksBlocks(DeferredHolder<Block, ?> planks, DeferredHolder<Block, ?> boards, DeferredHolder<Block, ?> ladder, DeferredHolder<Block, ?> bookshelf, DeferredHolder<Block, ?> beehive, DeferredHolder<? extends Block, ?> chest, DeferredHolder<? extends Block, ?> trappedChest) {
        this.woodworksBlocks((Block)planks.get(), boards, ladder, bookshelf, beehive, chest, trappedChest);
    }

    public void blockFamily(BlockFamily family) {
        Block block = family.getBaseBlock();
        this.baseBlocks(block, family.get(BlockFamily.Variant.STAIRS), family.get(BlockFamily.Variant.SLAB), family.get(BlockFamily.Variant.WALL));
        this.fenceBlocks(block, family.get(BlockFamily.Variant.FENCE), family.get(BlockFamily.Variant.FENCE_GATE));
        this.doorBlocks(family.get(BlockFamily.Variant.DOOR), family.get(BlockFamily.Variant.TRAPDOOR));
        this.signBlocks(block, family.get(BlockFamily.Variant.SIGN), family.get(BlockFamily.Variant.WALL_SIGN));
        Block block2 = family.get(BlockFamily.Variant.BUTTON);
        if (block2 instanceof ButtonBlock) {
            ButtonBlock button = (ButtonBlock)block2;
            this.buttonBlock(block, (Block)button);
        }
        if ((block2 = family.get(BlockFamily.Variant.PRESSURE_PLATE)) instanceof BasePressurePlateBlock) {
            BasePressurePlateBlock pressurePlate = (BasePressurePlateBlock)block2;
            this.pressurePlateBlock(block, (Block)pressurePlate);
        }
    }

    private static /* synthetic */ ModelFile lambda$beehiveBlock$0(ModelFile beehiveHoney, ModelFile beehive, BlockState state) {
        return (Integer)state.getValue((Property)BlockStateProperties.LEVEL_HONEY) == 5 ? beehiveHoney : beehive;
    }
}

