/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.endimator;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.blueprint.core.endimator.EndimatablePart;
import com.teamabnormals.blueprint.core.endimator.model.EndimatorPartPose;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.geom.ModelPart;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class EndimatorModelPart
extends ModelPart
implements EndimatablePart {
    public float xOffset;
    public float yOffset;
    public float zOffset;
    public boolean scaleChildren = true;
    public EndimatorPartPose initialPartPose = new EndimatorPartPose();

    public EndimatorModelPart(List<ModelPart.Cube> cubes, Map<String, ModelPart> children) {
        super(cubes, children);
    }

    public EndimatorModelPart(ModelPart part) {
        this(part.cubes, part.children);
        this.copyFrom(part);
        this.setInitialPose(new EndimatorPartPose().setPartPose(part.getInitialPose()));
    }

    public EndimatorModelPart(ModelPart part, float xOffset, float yOffset, float zOffset, float xScale, float yScale, float zScale, boolean scaleChildren) {
        this(part.cubes, part.children);
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
        this.xScale = xScale;
        this.yScale = yScale;
        this.zScale = zScale;
        this.scaleChildren = scaleChildren;
    }

    public EndimatorModelPart(ModelPart part, float xOffset, float yOffset, float zOffset) {
        this(part.cubes, part.children);
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
    }

    public EndimatorModelPart(ModelPart part, float xScale, float yScale, float zScale, boolean scaleChildren) {
        this(part.cubes, part.children);
        this.xScale = xScale;
        this.yScale = yScale;
        this.zScale = zScale;
        this.scaleChildren = scaleChildren;
    }

    public void setScale(float x, float y, float z) {
        this.xScale = x;
        this.yScale = y;
        this.zScale = z;
    }

    public void setShouldScaleChildren(boolean scaleChildren) {
        this.scaleChildren = scaleChildren;
    }

    public void setOffset(float x, float y, float z) {
        this.xOffset = x;
        this.yOffset = y;
        this.zOffset = z;
    }

    public void resetPose() {
        this.loadPose(this.initialPartPose);
    }

    @Override
    public void reset() {
        this.resetPose();
    }

    public void render(PoseStack pose, VertexConsumer consumer, int packedLightIn, int packedOverlayIn, int rgba) {
        if (this.visible) {
            Map children = this.children;
            if (!this.cubes.isEmpty() || !children.isEmpty()) {
                pose.pushPose();
                pose.translate(this.x / 16.0f, this.y / 16.0f, this.z / 16.0f);
                if (this.xRot != 0.0f || this.yRot != 0.0f || this.zRot != 0.0f) {
                    pose.mulPose(new Quaternionf().rotationZYX(this.zRot, this.yRot, this.xRot));
                }
                if (this.scaleChildren) {
                    pose.translate(this.xOffset, this.yOffset, this.zOffset);
                    pose.scale(this.xScale, this.yScale, this.zScale);
                    this.compile(pose.last(), consumer, packedLightIn, packedOverlayIn, rgba);
                } else {
                    pose.pushPose();
                    pose.translate(this.xOffset, this.yOffset, this.zOffset);
                    pose.scale(this.xScale, this.yScale, this.zScale);
                    this.compile(pose.last(), consumer, packedLightIn, packedOverlayIn, rgba);
                    pose.popPose();
                }
                for (ModelPart part : children.values()) {
                    part.render(pose, consumer, packedLightIn, packedOverlayIn, rgba);
                }
                pose.popPose();
            }
        }
    }

    private void compile(PoseStack.Pose pose, VertexConsumer consumer, int p_104293_, int p_104294_, int rgba) {
        for (ModelPart.Cube cube : this.cubes) {
            cube.compile(pose, consumer, p_104293_, p_104294_, rgba);
        }
    }

    @Override
    public void addOffset(float x, float y, float z) {
        this.xOffset -= x;
        this.yOffset -= y;
        this.zOffset -= z;
    }

    public void loadPose(EndimatorPartPose endimatorPartPose) {
        this.loadPose(endimatorPartPose.partPose);
        this.setOffset(endimatorPartPose.offsetX, endimatorPartPose.offsetY, endimatorPartPose.offsetZ);
        this.setScale(endimatorPartPose.scaleX, endimatorPartPose.scaleY, endimatorPartPose.scaleZ);
    }

    public void setInitialPose(EndimatorPartPose endimatorPartPose) {
        this.setInitialPose(endimatorPartPose.partPose);
        this.initialPartPose = endimatorPartPose;
    }
}

