/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.mixin;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.teamabnormals.blueprint.common.world.modification.structure.RepalettedStructureStart;
import com.teamabnormals.blueprint.common.world.modification.structure.StructureModificationContext;
import com.teamabnormals.blueprint.common.world.modification.structure.StructureRepaletter;
import com.teamabnormals.blueprint.common.world.modification.structure.StructureRepaletterEntry;
import com.teamabnormals.blueprint.common.world.modification.structure.StructureRepaletterManager;
import com.teamabnormals.blueprint.core.Blueprint;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={StructureStart.class})
public final class StructureStartMixin
implements RepalettedStructureStart {
    @Shadow
    @Final
    private Structure structure;
    @Unique
    @Nullable
    private ArrayList<StructureRepaletterManager.Entry> repaletters;

    @Override
    public void initializeRepaletters(StructureModificationContext context) {
        ResourceKey key = (ResourceKey)context.getGenerationContext().registryAccess().registryOrThrow(Registries.STRUCTURE).getResourceKey((Object)this.structure).orElseThrow();
        StructureRepaletterEntry[] entries = StructureRepaletterManager.getRepalettersForStructure((ResourceKey<Structure>)key);
        if (entries == null) {
            return;
        }
        ArrayList<StructureRepaletterManager.Entry> repaletters = new ArrayList<StructureRepaletterManager.Entry>();
        for (StructureRepaletterEntry entry : entries) {
            if (entry.condition().isPresent() && !entry.condition().get().test(context)) continue;
            for (StructureRepaletter repaletter : entry.repaletters()) {
                StructureRepaletter.Replacer replacer = repaletter.createReplacer(context);
                if (replacer == null) continue;
                repaletters.add(new StructureRepaletterManager.Entry(entry.pieces(), entry.shouldApplyToAfterPlace(), replacer));
            }
        }
        if (!repaletters.isEmpty()) {
            this.repaletters = repaletters;
        }
    }

    @Override
    public void setRepaletters(@Nullable ArrayList<StructureRepaletterManager.Entry> repaletters) {
        this.repaletters = repaletters;
    }

    @Inject(method={"createTag"}, at={@At(value="RETURN")})
    private void serializeRepaletters(StructurePieceSerializationContext context, ChunkPos pos, CallbackInfoReturnable<CompoundTag> info) {
        ArrayList<StructureRepaletterManager.Entry> repaletters = this.repaletters;
        if (repaletters == null) {
            return;
        }
        ListTag repalettersTag = new ListTag();
        for (StructureRepaletterManager.Entry entry : repaletters) {
            DataResult result = StructureRepaletterManager.Entry.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)entry);
            Optional error = result.error();
            if (error.isPresent()) {
                Blueprint.LOGGER.error("Failed to encode Structure Repaletter Entry: {}", (Object)((DataResult.Error)error.get()).message());
                continue;
            }
            repalettersTag.add((Object)((Tag)result.result().get()));
        }
        ((CompoundTag)info.getReturnValue()).put("blueprint:repaletters", (Tag)repalettersTag);
    }

    @Inject(method={"loadStaticStart"}, at={@At(value="RETURN")})
    private static void deserializeRepaletters(StructurePieceSerializationContext context, CompoundTag tag, long seed, CallbackInfoReturnable<StructureStart> info) {
        StructureStart start = (StructureStart)info.getReturnValue();
        StructureStart structureStart = start;
        if (!(structureStart instanceof RepalettedStructureStart)) {
            return;
        }
        RepalettedStructureStart repalettedStructureStart = (RepalettedStructureStart)structureStart;
        ListTag repalettersTag = tag.getList("blueprint:repaletters", 10);
        if (repalettersTag.isEmpty()) {
            return;
        }
        ArrayList<StructureRepaletterManager.Entry> repaletters = new ArrayList<StructureRepaletterManager.Entry>();
        for (int i = 0; i < repalettersTag.size(); ++i) {
            CompoundTag compoundTag = repalettersTag.getCompound(i);
            DataResult result = StructureRepaletterManager.Entry.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)compoundTag);
            Optional error = result.error();
            if (error.isPresent()) {
                Blueprint.LOGGER.error("Failed to decode Structure Repaletter Entry: {}", (Object)((DataResult.Error)error.get()).message());
                continue;
            }
            repaletters.add((StructureRepaletterManager.Entry)((Pair)result.result().get()).getFirst());
        }
        repalettedStructureStart.setRepaletters(repaletters);
    }

    @Inject(method={"placeInChunk"}, at={@At(value="HEAD")})
    public void updateStructureRepalleterRandomSource(WorldGenLevel level, StructureManager manager, ChunkGenerator generator, RandomSource randomSource, BoundingBox bounds, ChunkPos pos, CallbackInfo info) {
        StructureRepaletterManager.updateRandomSource(randomSource);
    }

    @Inject(method={"placeInChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/levelgen/structure/StructurePiece;postProcess(Lnet/minecraft/world/level/WorldGenLevel;Lnet/minecraft/world/level/StructureManager;Lnet/minecraft/world/level/chunk/ChunkGenerator;Lnet/minecraft/util/RandomSource;Lnet/minecraft/world/level/levelgen/structure/BoundingBox;Lnet/minecraft/world/level/ChunkPos;Lnet/minecraft/core/BlockPos;)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void updateActiveRepalletersForPieceType(WorldGenLevel level, StructureManager manager, ChunkGenerator generator, RandomSource randomSource, BoundingBox bounds, ChunkPos pos, CallbackInfo info, List<StructurePiece> list, BoundingBox boundingbox, BlockPos blockpos, BlockPos blockpos1, Iterator<StructurePiece> iterator, StructurePiece structurepiece) {
        Registry structurePieces = level.registryAccess().registryOrThrow(Registries.STRUCTURE_PIECE);
        StructureRepaletterManager.updateActiveRepaletters(this.repaletters, (Holder<StructurePieceType>)structurePieces.getHolderOrThrow((ResourceKey)structurePieces.getResourceKey((Object)structurepiece.getType()).orElseThrow()));
    }

    @Inject(method={"placeInChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/levelgen/structure/Structure;afterPlace(Lnet/minecraft/world/level/WorldGenLevel;Lnet/minecraft/world/level/StructureManager;Lnet/minecraft/world/level/chunk/ChunkGenerator;Lnet/minecraft/util/RandomSource;Lnet/minecraft/world/level/levelgen/structure/BoundingBox;Lnet/minecraft/world/level/ChunkPos;Lnet/minecraft/world/level/levelgen/structure/pieces/PiecesContainer;)V")})
    private void updateActiveRepalletersForAfterPlace(WorldGenLevel level, StructureManager manager, ChunkGenerator generator, RandomSource randomSource, BoundingBox bounds, ChunkPos pos, CallbackInfo info) {
        StructureRepaletterManager.updateActiveRepaletters(this.repaletters, null);
    }

    @Inject(method={"placeInChunk"}, at={@At(value="RETURN")})
    public void resetStructureRepalleterManager(WorldGenLevel level, StructureManager manager, ChunkGenerator generator, RandomSource randomSource, BoundingBox bounds, ChunkPos pos, CallbackInfo info) {
        StructureRepaletterManager.reset();
    }
}

