/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util;

import com.teamabnormals.blueprint.client.ClientInfo;
import com.teamabnormals.blueprint.common.network.UpdateSlabfishHatPayload;
import com.teamabnormals.blueprint.common.network.entity.TeleportEntityPayload;
import com.teamabnormals.blueprint.common.network.entity.UpdateEndimationPayload;
import com.teamabnormals.blueprint.common.network.entity.UpdateEntityDataPayload;
import com.teamabnormals.blueprint.common.network.particle.SpawnParticlesPayload;
import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.blueprint.core.endimator.Endimatable;
import com.teamabnormals.blueprint.core.endimator.PlayableEndimation;
import com.teamabnormals.blueprint.core.endimator.PlayableEndimationManager;
import java.util.List;
import java.util.Set;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public final class NetworkUtil {
    public static void spawnParticle(ServerLevel level, ParticleOptions options, List<SpawnParticlesPayload.ParticleInstance> instances) {
        PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SpawnParticlesPayload(options, instances), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void teleportEntity(Entity entity, double posX, double posY, double posZ) {
        entity.moveTo(posX, posY, posZ, entity.getYRot(), entity.getXRot());
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PacketDistributor.sendToPlayersInDimension((ServerLevel)serverLevel, (CustomPacketPayload)new TeleportEntityPayload(entity.getId(), posX, posY, posZ), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static <E extends Entity> void setPlayingAnimation(E entity, PlayableEndimation endimationToPlay) {
        if (!entity.level().isClientSide) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf(entity, (CustomPacketPayload)new UpdateEndimationPayload(entity.getId(), PlayableEndimationManager.INSTANCE.getID(endimationToPlay)), (CustomPacketPayload[])new CustomPacketPayload[0]);
            ((Endimatable)entity).setPlayingEndimation(endimationToPlay);
        }
    }

    public static void updateTrackedData(ServerPlayer player, int targetID, Set<IDataManager.DataEntry<?>> entries) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new UpdateEntityDataPayload(targetID, List.copyOf(entries)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void updateTrackedData(Entity entity, Set<IDataManager.DataEntry<?>> entries) {
        PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)new UpdateEntityDataPayload(entity.getId(), List.copyOf(entries)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void updateSlabfish(byte setting) {
        if (ClientInfo.getClientPlayer() != null) {
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateSlabfishHatPayload(setting), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

