/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.modification;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamabnormals.blueprint.core.Blueprint;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifier;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifierSerializerRegistry;
import com.teamabnormals.blueprint.core.util.modification.selection.ConditionedResourceSelector;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.GsonHelper;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.ICondition;

public record ObjectModifierGroup<T, S, D>(ConditionedResourceSelector selector, List<ObjectModifier<T, S, D, ?>> modifiers, EventPriority priority) {
    public static EventPriority deserializePriority(JsonObject object) {
        if (object.has("priority")) {
            String priorityName = GsonHelper.getAsString((JsonObject)object, (String)"priority").toUpperCase();
            for (EventPriority priority : EventPriority.values()) {
                if (!priority.name().equals(priorityName)) continue;
                return priority;
            }
            throw new JsonParseException("Unknown priority type: " + priorityName);
        }
        return EventPriority.NORMAL;
    }

    public static <T, S, D> ObjectModifierGroup<T, S, D> deserialize(String name, JsonObject object, D additional, ObjectModifierSerializerRegistry<T, S, D> registry, boolean logSkipping, boolean allowPriority) throws JsonParseException {
        EventPriority priority = allowPriority ? ObjectModifierGroup.deserializePriority(object) : EventPriority.NORMAL;
        ConditionedResourceSelector selector = ConditionedResourceSelector.deserialize("selector", object.get("selector"));
        if (selector == ConditionedResourceSelector.EMPTY) {
            if (logSkipping) {
                Blueprint.LOGGER.info("Skipped modifier group named '" + name + "' as its conditions were not met");
            }
            return new ObjectModifierGroup<T, S, D>(selector, ImmutableList.of(), priority);
        }
        ArrayList objectModifiers = new ArrayList();
        GsonHelper.getAsJsonArray((JsonObject)object, (String)"modifiers").forEach(element -> {
            JsonObject entry = element.getAsJsonObject();
            if (!GsonHelper.isValidNode((JsonObject)entry, (String)"conditions") || ICondition.getWithConditionalCodec((Codec)ConditionalOps.createConditionalCodec((Codec)Codec.unit((Object)Unit.INSTANCE), (String)"conditions"), (DynamicOps)JsonOps.INSTANCE, (Object)entry).isPresent()) {
                String type = GsonHelper.getAsString((JsonObject)entry, (String)"type");
                ObjectModifier.Serializer serializer = registry.getSerializer(type);
                if (serializer == null) {
                    throw new JsonParseException("Unknown modifier type: " + type);
                }
                JsonElement config = entry.get("config");
                if (config == null) {
                    throw new JsonParseException("Missing 'config' element!");
                }
                objectModifiers.add(serializer.deserialize(config, additional));
            } else if (logSkipping) {
                Blueprint.LOGGER.info("Skipped modifier named '" + name + "' as its conditions were not met");
            }
        });
        return new ObjectModifierGroup<T, S, D>(selector, objectModifiers, priority);
    }

    public JsonObject serialize(S additional, ObjectModifierSerializerRegistry<T, S, D> registry, ICondition[][] conditions) throws JsonParseException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("selector", this.selector.serialize());
        jsonObject.addProperty("priority", this.priority.toString().toLowerCase());
        List<ObjectModifier<T, S, D, ?>> objectModifiers = this.modifiers;
        JsonArray modifiers = new JsonArray();
        for (int i = 0; i < objectModifiers.size(); ++i) {
            ObjectModifier<T, S, D, ?> modifier = objectModifiers.get(i);
            ObjectModifier.Serializer<?, S, D> serializer = modifier.getSerializer();
            String name = registry.getName(serializer);
            if (name == null) {
                throw new JsonParseException("Could not find name for modifier serializer: " + String.valueOf(serializer));
            }
            JsonObject modifierObject = new JsonObject();
            modifierObject.addProperty("type", name);
            modifierObject.add("config", modifier.serialize(additional));
            ICondition[] modifierConditions = conditions[i];
            if (modifierConditions.length > 0) {
                JsonArray conditionsObject = new JsonArray();
                for (ICondition condition : modifierConditions) {
                    conditionsObject.add((JsonElement)ICondition.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)condition).getOrThrow(JsonParseException::new));
                }
                modifierObject.add("conditions", (JsonElement)conditionsObject);
            }
            modifiers.add((JsonElement)modifierObject);
        }
        jsonObject.add("modifiers", (JsonElement)modifiers);
        return jsonObject;
    }
}

