/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanping.bukkit;

import com.github.Anon8281.universalScheduler.UniversalScheduler;
import com.github.Anon8281.universalScheduler.scheduling.schedulers.TaskScheduler;
import com.tchristofferson.configupdater.ConfigUpdater;
import it.frafol.cleanping.bukkit.Metrics;
import it.frafol.cleanping.bukkit.UpdateCheck;
import it.frafol.cleanping.bukkit.commands.ReloadCommand;
import it.frafol.cleanping.bukkit.commands.legacy.PingCommand;
import it.frafol.cleanping.bukkit.commands.utils.TabComplete;
import it.frafol.cleanping.bukkit.enums.SpigotConfig;
import it.frafol.cleanping.bukkit.enums.SpigotMessages;
import it.frafol.cleanping.bukkit.enums.SpigotVersion;
import it.frafol.cleanping.bukkit.hooks.PlaceholderHook;
import it.frafol.cleanping.bukkit.objects.Lag;
import it.frafol.cleanping.bukkit.objects.Placeholder;
import it.frafol.cleanping.bukkit.objects.TextFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import net.byteflux.libby.BukkitLibraryManager;
import net.byteflux.libby.Library;
import net.byteflux.libby.relocation.Relocation;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.simpleyaml.configuration.file.YamlFile;

public class CleanPing
extends JavaPlugin {
    private TextFile configTextFile;
    private TextFile messagesTextFile;
    private TextFile versionTextFile;
    private static Field recentTps;
    public static CleanPing instance;
    boolean isWindows = System.getProperty("os.name").startsWith("Windows");
    public boolean updated = false;

    public void onEnable() {
        instance = this;
        BukkitLibraryManager bukkitLibraryManager = new BukkitLibraryManager((Plugin)this);
        Relocation yamlrelocation = new Relocation("yaml", "it{}frafol{}libs{}yaml");
        Library yaml = Library.builder().groupId("me{}carleslc{}Simple-YAML").artifactId("Simple-Yaml").relocate(yamlrelocation).version("1.8.4").build();
        Relocation updaterrelocation = new Relocation("updater", "it{}frafol{}libs{}updater");
        Library updater = Library.builder().groupId("com{}tchristofferson").artifactId("ConfigUpdater").version("2.1-SNAPSHOT").relocate(updaterrelocation).url("https://github.com/frafol/Config-Updater/releases/download/compile/ConfigUpdater-2.1-SNAPSHOT.jar").build();
        Relocation schedulerrelocation = new Relocation("scheduler", "it{}frafol{}libs{}scheduler");
        Library scheduler = Library.builder().groupId("com{}github{}Anon8281").artifactId("UniversalScheduler").version("0.1.6").relocate(schedulerrelocation).build();
        bukkitLibraryManager.addJitPack();
        try {
            bukkitLibraryManager.loadLibrary(yaml);
        }
        catch (RuntimeException ignored) {
            this.getLogger().severe("Failed to load Simple-YAML library. Trying to download it from GitHub...");
            yaml = Library.builder().groupId("me{}carleslc{}Simple-YAML").artifactId("Simple-Yaml").relocate(yamlrelocation).version("1.8.4").url("https://github.com/Carleslc/Simple-YAML/releases/download/1.8.4/Simple-Yaml-1.8.4.jar").build();
        }
        bukkitLibraryManager.loadLibrary(yaml);
        bukkitLibraryManager.loadLibrary(updater);
        bukkitLibraryManager.loadLibrary(scheduler);
        this.getLogger().info("\n   ___ _                 ___ _           \n  / __| |___ __ _ _ _   | _ (_)_ _  __ _ \n | (__| / -_) _` | ' \\  |  _/ | ' \\/ _` |\n  \\___|_\\___\\__,_|_||_| |_| |_|_||_\\__, |\n                                   |___/ \n");
        this.getLogger().info("Server version: " + this.getServer().getBukkitVersion());
        this.getLogger().info("Loading configuration...");
        this.configTextFile = new TextFile(this.getDataFolder().toPath(), "config.yml");
        this.messagesTextFile = new TextFile(this.getDataFolder().toPath(), "messages.yml");
        this.versionTextFile = new TextFile(this.getDataFolder().toPath(), "version.yml");
        File configFile = new File(this.getDataFolder(), "config.yml");
        File messagesFile = new File(this.getDataFolder(), "messages.yml");
        if (!this.getDescription().getVersion().equals(SpigotVersion.VERSION.get(String.class))) {
            this.getLogger().info("Creating new configurations...");
            try {
                ConfigUpdater.update((Plugin)this, (String)"config.yml", (File)configFile, Collections.emptyList());
                ConfigUpdater.update((Plugin)this, (String)"messages.yml", (File)messagesFile, Collections.emptyList());
            }
            catch (IOException exception) {
                this.getLogger().severe("Unable to update configuration file, please update it manually.");
            }
            this.versionTextFile.getConfig().set("version", (Object)this.getDescription().getVersion());
            this.versionTextFile.getConfig().save();
            this.configTextFile = new TextFile(this.getDataFolder().toPath(), "config.yml");
            this.messagesTextFile = new TextFile(this.getDataFolder().toPath(), "messages.yml");
            this.versionTextFile = new TextFile(this.getDataFolder().toPath(), "version.yml");
        }
        if (!CleanPing.hasGetPingMethod()) {
            this.getLogger().info("Loading commands for legacy versions...");
            Objects.requireNonNull(this.getCommand("ping")).setExecutor((CommandExecutor)new PingCommand(this));
            Objects.requireNonNull(this.getCommand("cleanping")).setExecutor((CommandExecutor)new PingCommand(this));
            Objects.requireNonNull(this.getCommand("pingreload")).setExecutor((CommandExecutor)new it.frafol.cleanping.bukkit.commands.legacy.ReloadCommand(this));
            Objects.requireNonNull(this.getCommand("cleanpingreload")).setExecutor((CommandExecutor)new it.frafol.cleanping.bukkit.commands.legacy.ReloadCommand(this));
        } else {
            this.getLogger().info("Loading commands...");
            Objects.requireNonNull(this.getCommand("ping")).setExecutor((CommandExecutor)new it.frafol.cleanping.bukkit.commands.PingCommand(this));
            Objects.requireNonNull(this.getCommand("cleanping")).setExecutor((CommandExecutor)new it.frafol.cleanping.bukkit.commands.PingCommand(this));
            Objects.requireNonNull(this.getCommand("pingreload")).setExecutor((CommandExecutor)new ReloadCommand(this));
            Objects.requireNonNull(this.getCommand("cleanpingreload")).setExecutor((CommandExecutor)new ReloadCommand(this));
        }
        Objects.requireNonNull(this.getCommand("ping")).setTabCompleter((TabCompleter)new TabComplete());
        Objects.requireNonNull(this.getCommand("cleanping")).setTabCompleter((TabCompleter)new TabComplete());
        if (SpigotConfig.MONITOR.get(Boolean.class).booleanValue()) {
            this.monitorPing();
        }
        if (SpigotConfig.STATS.get(Boolean.class).booleanValue()) {
            new Metrics(this, 16505);
            this.getLogger().info("Metrics loaded successfully!");
        }
        if (SpigotConfig.UPDATE_CHECK.get(Boolean.class).booleanValue()) {
            new UpdateCheck(this).getVersion(version -> {
                if (Integer.parseInt(this.getDescription().getVersion().replace(".", "")) < Integer.parseInt(version.replace(".", ""))) {
                    if (SpigotConfig.AUTO_UPDATE.get(Boolean.class).booleanValue() && !this.updated) {
                        this.autoUpdate();
                        return;
                    }
                    if (!this.updated) {
                        this.getLogger().warning("\u00a7eThere is a new update available, download it on SpigotMC!");
                    }
                }
                if (Integer.parseInt(this.getDescription().getVersion().replace(".", "")) > Integer.parseInt(version.replace(".", ""))) {
                    this.getLogger().warning("\u00a7eYou are using a development version, please report any bugs!");
                }
            });
        }
        if (this.isPAPI()) {
            new PlaceholderHook(this).register();
            this.getLogger().info("PlaceholderAPI found, placeholders enabled.");
        }
        this.getLogger().info("Plugin successfully loaded!");
    }

    public YamlFile getConfigTextFile() {
        return this.configTextFile.getConfig();
    }

    public YamlFile getMessagesTextFile() {
        return this.messagesTextFile.getConfig();
    }

    public YamlFile getVersionTextFile() {
        return this.versionTextFile.getConfig();
    }

    public static boolean hasGetPingMethod() {
        try {
            Player.class.getDeclaredMethod("getPing", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private boolean isPAPI() {
        return this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null;
    }

    public int getPing(Player player) {
        if (CleanPing.hasGetPingMethod()) {
            return player.getPing();
        }
        String v = this.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
        try {
            Class<?> CraftPlayerClass = Class.forName("org.bukkit.craftbukkit." + v + ".entity.CraftPlayer");
            Object CraftPlayer = CraftPlayerClass.cast(player);
            Method getHandle = CraftPlayer.getClass().getMethod("getHandle", new Class[0]);
            Object EntityPlayer = getHandle.invoke(CraftPlayer, new Object[0]);
            Field ping = EntityPlayer.getClass().getDeclaredField("ping");
            return ping.getInt(EntityPlayer);
        }
        catch (Exception ignored) {
            this.getLogger().severe("Unable to get a player's ping, please report this error on the Discord Server.");
            return 0;
        }
    }

    private void monitorPing() {
        TaskScheduler scheduler = UniversalScheduler.getScheduler((Plugin)this);
        scheduler.runTaskTimer((Runnable)new Lag(), 100L, 1L);
        HashMap lagging = new HashMap();
        scheduler.runTaskTimerAsynchronously(() -> {
            for (Player players : this.getServer().getOnlinePlayers()) {
                if (this.getPing(players) < SpigotConfig.MAX_PING.get(Integer.class) || Lag.getTPS() < 19.5) continue;
                if (lagging.containsKey(players.getUniqueId())) {
                    lagging.replace(players.getUniqueId(), (Integer)lagging.get(players.getUniqueId()) + 1);
                } else {
                    lagging.put(players.getUniqueId(), 1);
                }
                if (!((Integer)lagging.get(players.getUniqueId())).equals(SpigotConfig.MAX_FLAGS.get(Integer.class))) continue;
                this.sendLaggingMessage(players, this.getPing(players));
            }
        }, (long)SpigotConfig.FLAG_DELAY.get(Integer.class).intValue() * 20L, (long)SpigotConfig.FLAG_DELAY.get(Integer.class).intValue() * 20L);
    }

    private void sendLaggingMessage(Player player, Integer ping) {
        if (!CleanPing.hasGetPingMethod()) {
            player.sendMessage(SpigotMessages.LAGGING.color().replace("%prefix%", SpigotMessages.PREFIX.color()).replace("%ping%", String.valueOf(ping)));
            return;
        }
        player.sendMessage(Placeholder.translate(SpigotMessages.LAGGING.get(String.class).replace("%prefix%", SpigotMessages.PREFIX.color()).replace("%ping%", String.valueOf(ping))));
    }

    public void autoUpdate() {
        if (this.isWindows) {
            return;
        }
        String fileUrl = "https://github.com/frafol/CleanPing/releases/download/release/CleanPing.jar";
        String destination = "./plugins/";
        String fileName = this.getFileNameFromUrl(fileUrl);
        File outputFile = new File(destination, fileName);
        this.downloadFile(fileUrl, outputFile);
        this.updated = true;
        this.getLogger().warning("CleanPing successfully updated, a restart is required.");
    }

    private String getFileNameFromUrl(String fileUrl) {
        int slashIndex = fileUrl.lastIndexOf(47);
        if (slashIndex != -1 && slashIndex < fileUrl.length() - 1) {
            return fileUrl.substring(slashIndex + 1);
        }
        throw new IllegalArgumentException("Invalid file URL");
    }

    private void downloadFile(String fileUrl, File outputFile) {
        URL url = new URL(fileUrl);
        try (InputStream inputStream = url.openStream();){
            Files.copy(inputStream, outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public void onDisable() {
        this.getLogger().info("Clearing instances...");
        instance = null;
        this.getLogger().info("Plugin successfully disabled!");
    }

    public static CleanPing getInstance() {
        return instance;
    }
}

