/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanping.bukkit.commands;

import it.frafol.cleanping.bukkit.CleanPing;
import it.frafol.cleanping.bukkit.enums.SpigotConfig;
import it.frafol.cleanping.bukkit.enums.SpigotMessages;
import it.frafol.cleanping.bukkit.objects.Placeholder;
import java.util.Objects;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PingCommand
implements CommandExecutor {
    public final CleanPing plugin;

    public PingCommand(CleanPing plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender source, @NotNull Command command, @NotNull String s, String @NotNull [] args) {
        if (args.length == 0) {
            if (!(source instanceof Player)) {
                source.sendMessage(Placeholder.translate(SpigotMessages.ONLY_PLAYERS.get(String.class)).replace("%prefix%", Placeholder.translate(SpigotMessages.PREFIX.get(String.class))));
                return false;
            }
            Player player = (Player)source;
            long ping = player.getPing();
            if (source.isOp() || source.hasPermission(SpigotConfig.PING_PERMISSION.get(String.class))) {
                if (!SpigotConfig.DYNAMIC_PING.get(Boolean.class).booleanValue()) {
                    source.sendMessage(Placeholder.translate(SpigotMessages.PING.get(String.class)).replace("%prefix%", Placeholder.translate(SpigotMessages.PREFIX.get(String.class))).replace("%ping%", String.valueOf(player.getPing())));
                    return false;
                }
                source.sendMessage(Placeholder.translate(SpigotMessages.PING.get(String.class)).replace("%prefix%", Placeholder.translate(SpigotMessages.PREFIX.get(String.class))).replace("%ping%", PingCommand.colorBasedOnPing(ping) + ping));
            } else {
                source.sendMessage(Placeholder.translate(SpigotMessages.NO_PERMISSION.get(String.class)).replace("%prefix%", Placeholder.translate(SpigotMessages.PREFIX.get(String.class))));
            }
        } else if (args.length == 1) {
            if (!source.isOp() && !source.hasPermission(Placeholder.translate(SpigotConfig.PING_OTHERS_PERMISSION.get(String.class)))) {
                source.sendMessage(Placeholder.translate(SpigotMessages.NO_PERMISSION.get(String.class)).replace("%prefix%", Placeholder.translate(SpigotMessages.PREFIX.get(String.class))));
                return false;
            }
            if (this.plugin.getServer().getPlayer(args[0]) == null) {
                source.sendMessage(Placeholder.translate(SpigotMessages.NOT_ONLINE.get(String.class)).replace("%prefix%", Placeholder.translate(SpigotMessages.PREFIX.get(String.class))).replace("%user%", args[0]));
                return false;
            }
            if (!SpigotConfig.OTHERS_PING_OPTION.get(Boolean.class).booleanValue()) {
                source.sendMessage(Placeholder.translate(SpigotMessages.USAGE.get(String.class)).replace("%prefix%", Placeholder.translate(SpigotMessages.PREFIX.get(String.class))));
                return false;
            }
            long ping = Objects.requireNonNull(this.plugin.getServer().getPlayer(args[0])).getPing();
            if (!SpigotConfig.DYNAMIC_PING.get(Boolean.class).booleanValue()) {
                source.sendMessage(Placeholder.translate(SpigotMessages.OTHERS_PING.get(String.class)).replace("%prefix%", Placeholder.translate(SpigotMessages.PREFIX.get(String.class))).replace("%user%", args[0]).replace("%ping%", String.valueOf(ping)));
                return false;
            }
            source.sendMessage(Placeholder.translate(SpigotMessages.OTHERS_PING.get(String.class)).replace("%prefix%", Placeholder.translate(SpigotMessages.PREFIX.get(String.class))).replace("%user%", args[0]).replace("%ping%", PingCommand.colorBasedOnPing(ping) + ping));
        } else {
            if (args.length == 2) {
                if (!source.isOp() && !source.hasPermission(Placeholder.translate(SpigotConfig.DIFFERENCE_PING_PERMISSION.get(String.class)))) {
                    source.sendMessage(Placeholder.translate(SpigotMessages.NO_PERMISSION.get(String.class)).replace("%prefix%", Placeholder.translate(SpigotMessages.PREFIX.get(String.class))));
                    return false;
                }
                if (this.plugin.getServer().getPlayer(args[0]) == null) {
                    source.sendMessage(Placeholder.translate(SpigotMessages.NOT_ONLINE.get(String.class)).replace("%prefix%", Placeholder.translate(SpigotMessages.PREFIX.get(String.class))).replace("%user%", args[0]));
                    return false;
                }
                if (this.plugin.getServer().getPlayer(args[1]) == null) {
                    source.sendMessage(Placeholder.translate(SpigotMessages.NOT_ONLINE.get(String.class)).replace("%prefix%", Placeholder.translate(SpigotMessages.PREFIX.get(String.class))).replace("%user%", args[0]));
                    return false;
                }
                if (!SpigotConfig.DIFFERENCE_PING_OPTION.get(Boolean.class).booleanValue()) {
                    source.sendMessage(Placeholder.translate(SpigotMessages.USAGE.get(String.class)).replace("%prefix%", Placeholder.translate(SpigotMessages.PREFIX.get(String.class))));
                    return false;
                }
                long ping1 = Objects.requireNonNull(this.plugin.getServer().getPlayer(args[0])).getPing();
                long ping2 = Objects.requireNonNull(this.plugin.getServer().getPlayer(args[1])).getPing();
                long difference = this.getDifference(ping1, ping2).intValue();
                source.sendMessage(Placeholder.translate(SpigotMessages.PING_DIFFERENCE.get(String.class)).replace("%prefix%", Placeholder.translate(SpigotMessages.PREFIX.get(String.class))).replace("%arg1%", args[0]).replace("%arg2%", args[1]).replace("%difference%", String.valueOf(difference)));
                return false;
            }
            source.sendMessage(Placeholder.translate(SpigotMessages.USAGE.get(String.class)).replace("%prefix%", Placeholder.translate(SpigotMessages.PREFIX.get(String.class))));
        }
        return false;
    }

    private static String colorBasedOnPing(long ping) {
        if (ping < (long)SpigotConfig.MEDIUM_MS.get(Integer.class).intValue()) {
            return SpigotConfig.LOW_MS_COLOR.color();
        }
        if (ping > (long)SpigotConfig.MEDIUM_MS.get(Integer.class).intValue() && ping < (long)SpigotConfig.HIGH_MS.get(Integer.class).intValue()) {
            return SpigotConfig.MEDIUM_MS_COLOR.color();
        }
        return SpigotConfig.HIGH_MS_COLOR.color();
    }

    private Integer getDifference(long ping1, long ping2) {
        if (ping1 > ping2) {
            return (int)Math.abs(ping1 - ping2);
        }
        return (int)Math.abs(ping2 - ping1);
    }
}

