/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanping.bukkit.hooks;

import it.frafol.cleanping.bukkit.CleanPing;
import it.frafol.cleanping.bukkit.enums.SpigotConfig;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class PlaceholderHook
extends PlaceholderExpansion {
    public final CleanPing plugin;

    public PlaceholderHook(CleanPing plugin) {
        this.plugin = plugin;
    }

    public String getIdentifier() {
        return "cleanping";
    }

    public String getAuthor() {
        return "frafol";
    }

    public String getVersion() {
        return "1.0";
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(OfflinePlayer player, String placeholder) {
        if (placeholder.equalsIgnoreCase("ping")) {
            if (player.getPlayer() == null || !player.getPlayer().isOnline()) {
                return "";
            }
            if (CleanPing.hasGetPingMethod()) {
                return "" + player.getPlayer().getPing();
            }
            return "" + this.plugin.getPing(player.getPlayer());
        }
        if (placeholder.equalsIgnoreCase("coloured_ping")) {
            if (player.getPlayer() == null || !player.getPlayer().isOnline()) {
                return "";
            }
            if (CleanPing.hasGetPingMethod()) {
                return PlaceholderHook.colorBasedOnPing(player.getPlayer().getPing()) + player.getPlayer().getPing();
            }
            return PlaceholderHook.colorBasedOnPing(this.plugin.getPing(player.getPlayer())) + this.plugin.getPing(player.getPlayer());
        }
        for (Player players : this.plugin.getServer().getOnlinePlayers()) {
            if (player == null || !player.isOnline() || player.getPlayer() == null) {
                return "";
            }
            if (placeholder.equalsIgnoreCase("ping_" + players.getName())) {
                if (!players.isOnline()) {
                    return "";
                }
                if (CleanPing.hasGetPingMethod()) {
                    return "" + players.getPing();
                }
                return "" + this.plugin.getPing(players);
            }
            if (placeholder.equalsIgnoreCase("coloured_ping_" + players.getName())) {
                if (!players.isOnline()) {
                    return "";
                }
                if (CleanPing.hasGetPingMethod()) {
                    return PlaceholderHook.colorBasedOnPing(players.getPing()) + players.getPing();
                }
                return PlaceholderHook.colorBasedOnPing(this.plugin.getPing(players)) + this.plugin.getPing(players);
            }
            if (placeholder.equalsIgnoreCase("difference_" + players.getName())) {
                if (!players.isOnline()) {
                    return "";
                }
                if (CleanPing.hasGetPingMethod()) {
                    return "" + this.getDifference(players.getPing(), player.getPlayer().getPing());
                }
                return "" + this.getDifference(this.plugin.getPing(players), this.plugin.getPing(player.getPlayer()));
            }
            for (Player players2 : this.plugin.getServer().getOnlinePlayers()) {
                if (!placeholder.equalsIgnoreCase("difference_" + players.getName() + "_" + players2.getName())) continue;
                if (!players.isOnline() || !players2.isOnline()) {
                    return "";
                }
                if (CleanPing.hasGetPingMethod()) {
                    return "" + this.getDifference(players.getPing(), players2.getPing());
                }
                return "" + this.getDifference(this.plugin.getPing(players), this.plugin.getPing(players2));
            }
        }
        return null;
    }

    private static String colorBasedOnPing(long ping) {
        if (ping < (long)SpigotConfig.MEDIUM_MS.get(Integer.class).intValue()) {
            return SpigotConfig.LOW_MS_COLOR.color();
        }
        if (ping > (long)SpigotConfig.MEDIUM_MS.get(Integer.class).intValue() && ping < (long)SpigotConfig.HIGH_MS.get(Integer.class).intValue()) {
            return SpigotConfig.MEDIUM_MS_COLOR.color();
        }
        return SpigotConfig.HIGH_MS_COLOR.color();
    }

    private int getDifference(long ping1, long ping2) {
        if (ping1 > ping2) {
            return (int)Math.abs(ping1 - ping2);
        }
        return (int)Math.abs(ping2 - ping1);
    }
}

