/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanping.bukkit.objects;

import it.frafol.cleanping.bukkit.enums.SpigotConfig;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class Placeholder {
    private final String key;
    private final String value;

    public Placeholder(String key, String value) {
        this.key = "%" + key + "%";
        this.value = value;
    }

    public static String translate(String message) {
        if (Placeholder.supportsMiniMessage() && SpigotConfig.MINIMESSAGE.get(Boolean.class).booleanValue()) {
            MiniMessage miniMessage = MiniMessage.miniMessage();
            Component component = miniMessage.deserialize((Object)message);
            return LegacyComponentSerializer.legacySection().serialize(component);
        }
        if (!Placeholder.containsHexColor(message)) {
            return message.replace("&", "\u00a7");
        }
        Pattern pattern = Pattern.compile("#[a-fA-F0-9]{6}");
        Matcher matcher = pattern.matcher(message);
        while (matcher.find()) {
            String hexCode = message.substring(matcher.start(), matcher.end());
            String replaceSharp = hexCode.replace('#', 'x');
            char[] ch = replaceSharp.toCharArray();
            StringBuilder builder = new StringBuilder();
            for (char c : ch) {
                builder.append("&").append(c);
            }
            message = message.replace(hexCode, builder.toString());
            matcher = pattern.matcher(message);
        }
        return message.replace("&", "\u00a7");
    }

    private static boolean containsHexColor(String message) {
        String hexColorPattern = "(?i)&#[a-f0-9]{6}";
        return message.matches(".*" + hexColorPattern + ".*");
    }

    private static boolean supportsMiniMessage() {
        try {
            MiniMessage mm = MiniMessage.miniMessage();
            mm.deserialize((Object)"supports");
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }
}

