/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanping.bungee;

import com.imaginarycode.minecraft.redisbungee.RedisBungeeAPI;
import it.frafol.cleanping.bungee.Metrics;
import it.frafol.cleanping.bungee.UpdateCheck;
import it.frafol.cleanping.bungee.commands.PingCommand;
import it.frafol.cleanping.bungee.commands.ReloadCommand;
import it.frafol.cleanping.bungee.enums.BungeeConfig;
import it.frafol.cleanping.bungee.enums.BungeeMessages;
import it.frafol.cleanping.bungee.enums.BungeeRedis;
import it.frafol.cleanping.bungee.enums.BungeeVersion;
import it.frafol.cleanping.bungee.hooks.RedisListener;
import it.frafol.cleanping.bungee.objects.TextFile;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.byteflux.libby.BungeeLibraryManager;
import net.byteflux.libby.Library;
import net.byteflux.libby.relocation.Relocation;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import org.simpleyaml.configuration.file.YamlFile;
import ru.vyarus.yaml.updater.YamlUpdater;
import ru.vyarus.yaml.updater.profile.ProdConfigurator;
import ru.vyarus.yaml.updater.util.FileUtils;

public class CleanPing
extends Plugin {
    private TextFile configTextFile;
    private TextFile messagesTextFile;
    private TextFile redisTextFile;
    private TextFile versionTextFile;
    public static CleanPing instance;
    boolean isWindows = System.getProperty("os.name").startsWith("Windows");
    public boolean updated = false;

    public void onEnable() {
        instance = this;
        BungeeLibraryManager bungeeLibraryManager = new BungeeLibraryManager(this);
        Relocation yamlrelocation = new Relocation("yaml", "it{}frafol{}libs{}yaml");
        Library yaml = Library.builder().groupId("me{}carleslc{}Simple-YAML").artifactId("Simple-Yaml").relocate(yamlrelocation).version("1.8.4").build();
        Relocation updatereolocation = new Relocation("updater", "it{}frafol{}libs{}updater");
        Library updater = Library.builder().groupId("ru{}vyarus").artifactId("yaml-config-updater").relocate(updatereolocation).version("1.4.2").build();
        bungeeLibraryManager.addJitPack();
        bungeeLibraryManager.addMavenCentral();
        bungeeLibraryManager.loadLibrary(updater);
        try {
            bungeeLibraryManager.loadLibrary(yaml);
        }
        catch (RuntimeException ignored) {
            this.getLogger().severe("Failed to load Simple-YAML library. Trying to download it from GitHub...");
            yaml = Library.builder().groupId("me{}carleslc{}Simple-YAML").artifactId("Simple-Yaml").relocate(yamlrelocation).version("1.8.4").url("https://github.com/Carleslc/Simple-YAML/releases/download/1.8.4/Simple-Yaml-1.8.4.jar").build();
        }
        bungeeLibraryManager.loadLibrary(yaml);
        this.getLogger().info("\n\u00a7d   ___ _                 ___ _           \n  / __| |___ __ _ _ _   | _ (_)_ _  __ _ \n | (__| / -_) _` | ' \\  |  _/ | ' \\/ _` |\n  \\___|_\\___\\__,_|_||_| |_| |_|_||_\\__, |\n                                   |___/ \n");
        this.getLogger().info("\u00a77Loading \u00a7dconfiguration\u00a77...");
        this.loadFiles();
        this.updateConfig();
        this.getLogger().info("\u00a77Loading \u00a7dcommands\u00a77...");
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new PingCommand());
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new ReloadCommand());
        if (BungeeRedis.REDIS.get(Boolean.class).booleanValue() && this.getProxy().getPluginManager().getPlugin("RedisBungee") != null) {
            RedisBungeeAPI redisBungeeAPI = RedisBungeeAPI.getRedisBungeeApi();
            this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new RedisListener(this));
            redisBungeeAPI.registerPubSubChannels(new String[]{"CleanPing-Request"});
            redisBungeeAPI.registerPubSubChannels(new String[]{"CleanPing-Response"});
            this.getLogger().info("\u00a77Hooked into RedisBungee \u00a7dsuccessfully\u00a77!");
        }
        if (BungeeConfig.MONITOR.get(Boolean.class).booleanValue()) {
            this.monitorPing();
        }
        if (BungeeConfig.STATS.get(Boolean.class).booleanValue()) {
            new Metrics(this, 16459);
            this.getLogger().info("\u00a77Metrics loaded \u00a7dsuccessfully\u00a77!");
        }
        if (BungeeConfig.UPDATE_CHECK.get(Boolean.class).booleanValue()) {
            new UpdateCheck(this).getVersion(version -> {
                if (Integer.parseInt(this.getDescription().getVersion().replace(".", "")) < Integer.parseInt(version.replace(".", ""))) {
                    if (BungeeConfig.AUTO_UPDATE.get(Boolean.class).booleanValue() && !this.updated) {
                        this.autoUpdate();
                        return;
                    }
                    if (!this.updated) {
                        this.getLogger().warning("\u00a7eThere is a new update available, download it on SpigotMC!");
                    }
                }
                if (Integer.parseInt(this.getDescription().getVersion().replace(".", "")) > Integer.parseInt(version.replace(".", ""))) {
                    this.getLogger().warning("\u00a7eYou are using a development version, please report any bugs!");
                }
            });
        }
        this.getLogger().info("\u00a77Plugin \u00a7dsuccessfully \u00a77loaded!");
    }

    public YamlFile getConfigTextFile() {
        return CleanPing.getInstance().configTextFile.getConfig();
    }

    public YamlFile getMessagesTextFile() {
        return CleanPing.getInstance().messagesTextFile.getConfig();
    }

    public YamlFile getRedisTextFile() {
        return CleanPing.getInstance().redisTextFile.getConfig();
    }

    public YamlFile getVersionTextFile() {
        return CleanPing.getInstance().versionTextFile.getConfig();
    }

    public void onDisable() {
        this.getLogger().info("\u00a77Clearing \u00a7dinstances\u00a77...");
        instance = null;
        this.getLogger().info("\u00a77Plugin successfully \u00a7ddisabled\u00a77!");
    }

    private void loadFiles() {
        this.configTextFile = new TextFile(this.getDataFolder().toPath(), "config.yml");
        this.messagesTextFile = new TextFile(this.getDataFolder().toPath(), "messages.yml");
        this.redisTextFile = new TextFile(this.getDataFolder().toPath(), "redis.yml");
        this.versionTextFile = new TextFile(this.getDataFolder().toPath(), "version.yml");
    }

    private void monitorPing() {
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        HashMap lagging = new HashMap();
        scheduler.scheduleAtFixedRate(() -> {
            for (ProxiedPlayer players : this.getProxy().getPlayers()) {
                if (players.getPing() < BungeeConfig.MAX_PING.get(Integer.class)) continue;
                if (lagging.containsKey(players.getUniqueId())) {
                    lagging.replace(players.getUniqueId(), (Integer)lagging.get(players.getUniqueId()) + 1);
                } else {
                    lagging.put(players.getUniqueId(), 1);
                }
                if (!((Integer)lagging.get(players.getUniqueId())).equals(BungeeConfig.MAX_FLAGS.get(Integer.class))) continue;
                this.sendLaggingMessage(players, players.getPing());
            }
        }, BungeeConfig.FLAG_DELAY.get(Integer.class).intValue(), BungeeConfig.FLAG_DELAY.get(Integer.class).intValue(), TimeUnit.SECONDS);
    }

    private void sendLaggingMessage(ProxiedPlayer player, Integer ping) {
        player.sendMessage(TextComponent.fromLegacy((String)BungeeMessages.LAGGING.color().replace("%prefix%", BungeeMessages.PREFIX.color()).replace("%ping%", String.valueOf(ping))));
    }

    public void autoUpdate() {
        if (this.isWindows) {
            return;
        }
        String fileUrl = "https://github.com/frafol/CleanPing/releases/download/release/CleanPing.jar";
        String destination = "./plugins/";
        String fileName = this.getFileNameFromUrl(fileUrl);
        File outputFile = new File(destination, fileName);
        this.downloadFile(fileUrl, outputFile);
        this.updated = true;
        this.getLogger().warning("\u00a7eCleanPing successfully updated, a restart is required.");
    }

    private String getFileNameFromUrl(String fileUrl) {
        int slashIndex = fileUrl.lastIndexOf(47);
        if (slashIndex != -1 && slashIndex < fileUrl.length() - 1) {
            return fileUrl.substring(slashIndex + 1);
        }
        throw new IllegalArgumentException("Invalid file URL");
    }

    private void downloadFile(String fileUrl, File outputFile) {
        URL url = new URL(fileUrl);
        try (InputStream inputStream = url.openStream();){
            Files.copy(inputStream, outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private void updateConfig() {
        if (!this.getDescription().getVersion().equals(BungeeVersion.VERSION.get(String.class))) {
            this.getLogger().info("\u00a77Creating new \u00a7dconfigurations\u00a77...");
            ((ProdConfigurator)YamlUpdater.create((File)new File(String.valueOf(this.getDataFolder().toPath()) + "/config.yml"), (InputStream)FileUtils.findFile((String)"https://raw.githubusercontent.com/frafol/CleanPing/refs/heads/main/bungeecord/src/main/resources/config.yml")).backup(true)).update();
            ((ProdConfigurator)YamlUpdater.create((File)new File(String.valueOf(this.getDataFolder().toPath()) + "/messages.yml"), (InputStream)FileUtils.findFile((String)"https://raw.githubusercontent.com/frafol/CleanPing/refs/heads/main/bungeecord/src/main/resources/messages.yml")).backup(true)).update();
            ((ProdConfigurator)YamlUpdater.create((File)new File(String.valueOf(this.getDataFolder().toPath()) + "/redis.yml"), (InputStream)FileUtils.findFile((String)"https://raw.githubusercontent.com/frafol/CleanPing/refs/heads/main/bungeecord/src/main/resources/redis.yml")).backup(true)).update();
            this.versionTextFile.getConfig().set("version", (Object)this.getDescription().getVersion());
            this.versionTextFile.getConfig().save();
            this.loadFiles();
        }
    }

    public static CleanPing getInstance() {
        return instance;
    }
}

