/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanping.bungee.commands;

import com.imaginarycode.minecraft.redisbungee.RedisBungeeAPI;
import it.frafol.cleanping.bungee.enums.BungeeConfig;
import it.frafol.cleanping.bungee.enums.BungeeMessages;
import it.frafol.cleanping.bungee.enums.BungeeRedis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.TabExecutor;

public class PingCommand
extends Command
implements TabExecutor {
    public PingCommand() {
        super("cleanping", "", new String[]{"ping"});
    }

    public void execute(CommandSender source, String[] args) {
        if (args.length == 0) {
            if (!(source instanceof ProxiedPlayer)) {
                source.sendMessage(TextComponent.fromLegacy((String)BungeeMessages.ONLY_PLAYERS.color().replace("%prefix%", BungeeMessages.PREFIX.color())));
                return;
            }
            ProxiedPlayer player = (ProxiedPlayer)source;
            long ping = player.getPing();
            if (source.hasPermission(BungeeConfig.PING_PERMISSION.get(String.class))) {
                if (!BungeeConfig.DYNAMIC_PING.get(Boolean.class).booleanValue()) {
                    source.sendMessage(TextComponent.fromLegacy((String)BungeeMessages.PING.color().replace("%prefix%", BungeeMessages.PREFIX.color()).replace("%ping%", String.valueOf(ping))));
                    return;
                }
                source.sendMessage(TextComponent.fromLegacy((String)BungeeMessages.PING.color().replace("%prefix%", BungeeMessages.PREFIX.color()).replace("%ping%", PingCommand.colorBasedOnPing(ping) + ping)));
            } else {
                source.sendMessage(TextComponent.fromLegacy((String)BungeeMessages.NO_PERMISSION.color().replace("%prefix%", BungeeMessages.PREFIX.color())));
            }
        } else if (args.length == 1) {
            if (!BungeeRedis.REDIS.get(Boolean.class).booleanValue() && ProxyServer.getInstance().getPluginManager().getPlugin("RedisBungee") == null || ProxyServer.getInstance().getPlayer(args[0]) != null) {
                if (!source.hasPermission(BungeeConfig.PING_OTHERS_PERMISSION.get(String.class))) {
                    source.sendMessage(TextComponent.fromLegacy((String)BungeeMessages.NO_PERMISSION.color().replace("%prefix%", BungeeMessages.PREFIX.color())));
                    return;
                }
                if (ProxyServer.getInstance().getPlayer(args[0]) == null) {
                    source.sendMessage(TextComponent.fromLegacy((String)BungeeMessages.NOT_ONLINE.color().replace("%prefix%", BungeeMessages.PREFIX.color()).replace("%user%", args[0])));
                    return;
                }
                if (!BungeeConfig.OTHERS_PING_OPTION.get(Boolean.class).booleanValue()) {
                    source.sendMessage(TextComponent.fromLegacy((String)BungeeMessages.USAGE.color().replace("%prefix%", BungeeMessages.PREFIX.color())));
                    return;
                }
                long ping = ProxyServer.getInstance().getPlayer(args[0]).getPing();
                if (!BungeeConfig.DYNAMIC_PING.get(Boolean.class).booleanValue()) {
                    source.sendMessage(TextComponent.fromLegacy((String)BungeeMessages.OTHERS_PING.color().replace("%prefix%", BungeeMessages.PREFIX.color()).replace("%user%", args[0]).replace("%ping%", String.valueOf(ping))));
                    return;
                }
                source.sendMessage(TextComponent.fromLegacy((String)BungeeMessages.OTHERS_PING.color().replace("%prefix%", BungeeMessages.PREFIX.color()).replace("%user%", args[0]).replace("%ping%", PingCommand.colorBasedOnPing(ping) + ping)));
            } else {
                String target;
                if (!source.hasPermission(BungeeConfig.PING_OTHERS_PERMISSION.get(String.class))) {
                    source.sendMessage(TextComponent.fromLegacy((String)BungeeMessages.NO_PERMISSION.color().replace("%prefix%", BungeeMessages.PREFIX.color())));
                    return;
                }
                RedisBungeeAPI redisBungeeAPI = RedisBungeeAPI.getRedisBungeeApi();
                if (redisBungeeAPI.getUuidFromName(target = args[0]) == null) {
                    return;
                }
                UUID uuid = redisBungeeAPI.getUuidFromName(target);
                if (!redisBungeeAPI.isPlayerOnline(uuid)) {
                    source.sendMessage(TextComponent.fromLegacy((String)BungeeMessages.NOT_ONLINE.color().replace("%prefix%", BungeeMessages.PREFIX.color()).replace("%user%", args[0])));
                    return;
                }
                if (!(source instanceof ProxiedPlayer)) {
                    return;
                }
                ProxiedPlayer player = (ProxiedPlayer)source;
                String send_message = target + ";" + String.valueOf(uuid) + ";" + redisBungeeAPI.getProxy(uuid) + ";" + String.valueOf(player.getUniqueId()) + ";false";
                redisBungeeAPI.sendChannelMessage("CleanPing-Request", send_message);
            }
        } else if (args.length == 2) {
            if (!source.hasPermission(BungeeConfig.DIFFERENCE_PING_PERMISSION.get(String.class))) {
                source.sendMessage(TextComponent.fromLegacy((String)BungeeMessages.NO_PERMISSION.color().replace("%prefix%", BungeeMessages.PREFIX.color())));
                return;
            }
            if (ProxyServer.getInstance().getPlayer(args[0]) == null) {
                source.sendMessage(TextComponent.fromLegacy((String)BungeeMessages.NOT_ONLINE.color().replace("%prefix%", BungeeMessages.PREFIX.color()).replace("%user%", args[0])));
                return;
            }
            if (ProxyServer.getInstance().getPlayer(args[1]) == null) {
                source.sendMessage(TextComponent.fromLegacy((String)BungeeMessages.NOT_ONLINE.color().replace("%prefix%", BungeeMessages.PREFIX.color()).replace("%user%", args[0])));
                return;
            }
            if (!BungeeConfig.DIFFERENCE_PING_OPTION.get(Boolean.class).booleanValue()) {
                source.sendMessage(TextComponent.fromLegacy((String)BungeeMessages.USAGE.color().replace("%prefix%", BungeeMessages.PREFIX.color())));
                return;
            }
            long ping1 = ProxyServer.getInstance().getPlayer(args[0]).getPing();
            long ping2 = ProxyServer.getInstance().getPlayer(args[1]).getPing();
            source.sendMessage(TextComponent.fromLegacy((String)BungeeMessages.PING_DIFFERENCE.color().replace("%prefix%", BungeeMessages.PREFIX.color()).replace("%arg1%", args[0]).replace("%arg2%", args[1]).replace("%difference%", this.getDifference(ping1, ping2).toString())));
        } else {
            source.sendMessage(TextComponent.fromLegacy((String)BungeeMessages.USAGE.color().replace("%prefix%", BungeeMessages.PREFIX.color())));
        }
    }

    public Iterable<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length != 1) {
            return Collections.emptyList();
        }
        String partialName = args[0].toLowerCase();
        ArrayList<String> completions = new ArrayList<String>();
        for (ProxiedPlayer player : ProxyServer.getInstance().getPlayers()) {
            if (!player.getName().toLowerCase().startsWith(partialName)) continue;
            completions.add(player.getName());
        }
        return completions;
    }

    private static String colorBasedOnPing(long ping) {
        if (ping < (long)BungeeConfig.MEDIUM_MS.get(Integer.class).intValue()) {
            return BungeeConfig.LOW_MS_COLOR.color();
        }
        if (ping > (long)BungeeConfig.MEDIUM_MS.get(Integer.class).intValue() && ping < (long)BungeeConfig.HIGH_MS.get(Integer.class).intValue()) {
            return BungeeConfig.MEDIUM_MS_COLOR.color();
        }
        return BungeeConfig.HIGH_MS_COLOR.color();
    }

    private Integer getDifference(long ping1, long ping2) {
        if (ping1 > ping2) {
            return (int)Math.abs(ping1 - ping2);
        }
        return (int)Math.abs(ping2 - ping1);
    }
}

