/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanping.bungee.hooks;

import com.imaginarycode.minecraft.redisbungee.RedisBungeeAPI;
import com.imaginarycode.minecraft.redisbungee.events.PubSubMessageEvent;
import it.frafol.cleanping.bungee.CleanPing;
import it.frafol.cleanping.bungee.enums.BungeeConfig;
import it.frafol.cleanping.bungee.enums.BungeeMessages;
import java.util.UUID;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;

public class RedisListener
implements Listener {
    public final CleanPing PLUGIN;

    public RedisListener(CleanPing plugin) {
        this.PLUGIN = plugin;
    }

    @EventHandler
    public void onRedisBungeeMessage(PubSubMessageEvent event) {
        String player_name;
        String received_message;
        RedisBungeeAPI redisBungeeAPI = RedisBungeeAPI.getRedisBungeeApi();
        if (event.getChannel().equals("CleanPing-Request")) {
            received_message = event.getMessage();
            player_name = received_message.split(";")[0];
            UUID player_uuid = UUID.fromString(received_message.split(";")[1]);
            String player_server = received_message.split(";")[2];
            UUID source = UUID.fromString(received_message.split(";")[3]);
            if (!redisBungeeAPI.getProxyId().equals(player_server)) {
                return;
            }
            if (this.PLUGIN.getProxy().getPlayer(player_uuid) == null) {
                return;
            }
            ProxiedPlayer final_player = this.PLUGIN.getProxy().getPlayer(player_uuid);
            if (final_player == null) {
                return;
            }
            long ping = final_player.getPing();
            String response_message = player_name + ";" + String.valueOf(player_uuid) + ";" + redisBungeeAPI.getProxy(player_uuid) + ";" + String.valueOf(source) + ";" + ping;
            redisBungeeAPI.sendChannelMessage("CleanPing-Response", response_message);
        }
        if (event.getChannel().equals("CleanPing-Response")) {
            received_message = event.getMessage();
            player_name = received_message.split(";")[0];
            String player_server = received_message.split(";")[2];
            UUID source = UUID.fromString(received_message.split(";")[3]);
            long ping = Long.parseLong(received_message.split(";")[4]);
            if (redisBungeeAPI.getProxyId().equals(player_server)) {
                return;
            }
            if (this.PLUGIN.getProxy().getPlayer(source) == null) {
                return;
            }
            if (!BungeeConfig.DYNAMIC_PING.get(Boolean.class).booleanValue()) {
                this.PLUGIN.getProxy().getPlayer(source).sendMessage(TextComponent.fromLegacy((String)BungeeMessages.OTHERS_PING.color().replace("%prefix%", BungeeMessages.PREFIX.color()).replace("%user%", player_name).replace("%ping%", String.valueOf(ping))));
                return;
            }
            this.PLUGIN.getProxy().getPlayer(source).sendMessage(TextComponent.fromLegacy((String)BungeeMessages.OTHERS_PING.color().replace("%prefix%", BungeeMessages.PREFIX.color()).replace("%user%", player_name).replace("%ping%", RedisListener.colorBasedOnPing(ping) + ping)));
        }
    }

    private static String colorBasedOnPing(long ping) {
        if (ping < (long)BungeeConfig.MEDIUM_MS.get(Integer.class).intValue()) {
            return BungeeConfig.LOW_MS_COLOR.color();
        }
        if (ping > (long)BungeeConfig.MEDIUM_MS.get(Integer.class).intValue() && ping < (long)BungeeConfig.HIGH_MS.get(Integer.class).intValue()) {
            return BungeeConfig.MEDIUM_MS_COLOR.color();
        }
        return BungeeConfig.HIGH_MS_COLOR.color();
    }
}

