/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanping.bungee.objects;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import org.simpleyaml.configuration.file.YamlFile;

public class TextFile {
    private final YamlFile yamlFile;
    private static final List<TextFile> list = Lists.newArrayList();

    public TextFile(Path path, String fileName) {
        Path configPath;
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectory(path, new FileAttribute[0]);
        }
        if (!Files.exists(configPath = path.resolve(fileName), new LinkOption[0])) {
            try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(fileName);){
                Files.copy(Objects.requireNonNull(in), configPath, new CopyOption[0]);
            }
        }
        this.yamlFile = new YamlFile(configPath.toFile());
        this.yamlFile.load();
        list.add(this);
    }

    public YamlFile getConfig() {
        return this.yamlFile;
    }

    public void reload() {
        this.yamlFile.load();
    }

    public static void reloadAll() {
        list.forEach(TextFile::reload);
    }
}

