/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanping.velocity;

import com.google.inject.Inject;
import com.imaginarycode.minecraft.redisbungee.RedisBungeeAPI;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import it.frafol.cleanping.velocity.Metrics;
import it.frafol.cleanping.velocity.UpdateCheck;
import it.frafol.cleanping.velocity.commands.PingCommand;
import it.frafol.cleanping.velocity.commands.ReloadCommand;
import it.frafol.cleanping.velocity.enums.VelocityConfig;
import it.frafol.cleanping.velocity.enums.VelocityMessages;
import it.frafol.cleanping.velocity.enums.VelocityRedis;
import it.frafol.cleanping.velocity.enums.VelocityVersion;
import it.frafol.cleanping.velocity.hooks.RedisListener;
import it.frafol.cleanping.velocity.objects.TextFile;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import net.byteflux.libby.Library;
import net.byteflux.libby.VelocityLibraryManager;
import net.byteflux.libby.relocation.Relocation;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.slf4j.Logger;
import ru.vyarus.yaml.updater.YamlUpdater;
import ru.vyarus.yaml.updater.profile.ProdConfigurator;
import ru.vyarus.yaml.updater.util.FileUtils;

@Plugin(id="cleanping", name="CleanPing", version="1.7.1", dependencies={@Dependency(id="redisbungee", optional=true)}, description="Adds /ping command to check your and player's ping.", authors={"frafol"})
public class CleanPing {
    private final Logger logger;
    private final ProxyServer server;
    private final Path path;
    private final Metrics.Factory metricsFactory;
    boolean isWindows = System.getProperty("os.name").startsWith("Windows");
    private TextFile messagesTextFile;
    private TextFile configTextFile;
    private TextFile redisTextFile;
    private TextFile versionTextFile;
    private static CleanPing instance;
    public boolean updated = false;
    @Inject
    public PluginContainer container;

    @Inject
    public CleanPing(Logger logger, ProxyServer server, @DataDirectory Path path, Metrics.Factory metricsFactory) {
        this.server = server;
        this.logger = logger;
        this.path = path;
        this.metricsFactory = metricsFactory;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        instance = this;
        VelocityLibraryManager<CleanPing> velocityLibraryManager = new VelocityLibraryManager<CleanPing>(this.getLogger(), this.path, this.getServer().getPluginManager(), this);
        Relocation yamlrelocation = new Relocation("yaml", "it{}frafol{}libs{}yaml");
        Library yaml = Library.builder().groupId("me{}carleslc{}Simple-YAML").artifactId("Simple-Yaml").relocate(yamlrelocation).version("1.8.4").build();
        Relocation updaterelocation = new Relocation("updater", "it{}frafol{}libs{}updater");
        Library updater = Library.builder().groupId("ru{}vyarus").artifactId("yaml-config-updater").relocate(updaterelocation).version("1.4.2").build();
        velocityLibraryManager.addJitPack();
        velocityLibraryManager.addMavenCentral();
        velocityLibraryManager.loadLibrary(updater);
        try {
            velocityLibraryManager.loadLibrary(yaml);
        }
        catch (RuntimeException ignored) {
            this.logger.error("Failed to load Simple-YAML library. Trying to download it from GitHub...");
            yaml = Library.builder().groupId("me{}carleslc{}Simple-YAML").artifactId("Simple-Yaml").relocate(yamlrelocation).version("1.8.4").url("https://github.com/Carleslc/Simple-YAML/releases/download/1.8.4/Simple-Yaml-1.8.4.jar").build();
        }
        velocityLibraryManager.loadLibrary(yaml);
        this.logger.info("\n   ___ _                 ___ _           \n  / __| |___ __ _ _ _   | _ (_)_ _  __ _ \n | (__| / -_) _` | ' \\  |  _/ | ' \\/ _` |\n  \\___|_\\___\\__,_|_||_| |_| |_|_||_\\__, |\n                                   |___/ \n");
        this.logger.info("Loading configuration...");
        this.loadFiles();
        this.updateConfig();
        this.logger.info("Loading commands...");
        PingCommand.register(this.server, this);
        ReloadCommand.register(this.server, this);
        if (VelocityConfig.MONITOR.get(Boolean.class).booleanValue()) {
            this.monitorPing();
        }
        if (VelocityConfig.STATS.get(Boolean.class).booleanValue()) {
            this.metricsFactory.make(this, 16458);
            this.logger.info("Metrics loaded successfully!");
        }
        if (VelocityRedis.REDIS.get(Boolean.class).booleanValue() && this.server.getPluginManager().isLoaded("redisbungee")) {
            RedisBungeeAPI redisBungeeAPI = RedisBungeeAPI.getRedisBungeeApi();
            this.server.getEventManager().register((Object)this, (Object)new RedisListener(this));
            redisBungeeAPI.registerPubSubChannels(new String[]{"CleanPing-Request"});
            redisBungeeAPI.registerPubSubChannels(new String[]{"CleanPing-Response"});
            this.logger.info("Hooked into RedisBungee successfully!");
        }
        if (VelocityConfig.UPDATE_CHECK.get(Boolean.class).booleanValue()) {
            new UpdateCheck(this).getVersion(version -> {
                if (!this.container.getDescription().getVersion().isPresent()) {
                    return;
                }
                if (Integer.parseInt(((String)this.container.getDescription().getVersion().get()).replace(".", "")) < Integer.parseInt(version.replace(".", ""))) {
                    if (VelocityConfig.AUTO_UPDATE.get(Boolean.class).booleanValue() && !this.updated) {
                        this.autoUpdate();
                        return;
                    }
                    if (!this.updated) {
                        this.logger.warn("There is a new update available, download it on SpigotMC!");
                    }
                }
                if (Integer.parseInt(((String)this.container.getDescription().getVersion().get()).replace(".", "")) > Integer.parseInt(version.replace(".", ""))) {
                    this.logger.warn("You are using a development version, please report any bugs!");
                }
            });
        }
        this.logger.info("Plugin successfully loaded!");
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        this.logger.info("Clearing instances...");
        instance = null;
        this.logger.info("Plugin successfully disabled!");
    }

    private void monitorPing() {
        HashMap lagging = new HashMap();
        this.getServer().getScheduler().buildTask((Object)this, () -> {
            for (Player players : this.getServer().getAllPlayers()) {
                if (players.getPing() < (long)VelocityConfig.MAX_PING.get(Integer.class).intValue()) continue;
                if (lagging.containsKey(players.getUniqueId())) {
                    lagging.replace(players.getUniqueId(), (Integer)lagging.get(players.getUniqueId()) + 1);
                } else {
                    lagging.put(players.getUniqueId(), 1);
                }
                if (!((Integer)lagging.get(players.getUniqueId())).equals(VelocityConfig.MAX_FLAGS.get(Integer.class))) continue;
                this.sendLaggingMessage(players, (int)players.getPing());
            }
        }).delay((long)VelocityConfig.FLAG_DELAY.get(Integer.class).intValue(), TimeUnit.SECONDS).repeat((long)VelocityConfig.FLAG_DELAY.get(Integer.class).intValue(), TimeUnit.SECONDS).schedule();
    }

    private void sendLaggingMessage(Player player, Integer ping) {
        player.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.LAGGING.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%ping%", String.valueOf(ping))));
    }

    private void loadFiles() {
        this.configTextFile = new TextFile(this.path, "config.yml");
        this.messagesTextFile = new TextFile(this.path, "messages.yml");
        this.redisTextFile = new TextFile(this.path, "redis.yml");
        this.versionTextFile = new TextFile(this.path, "version.yml");
    }

    private String getFileNameFromUrl(String fileUrl) {
        int slashIndex = fileUrl.lastIndexOf(47);
        if (slashIndex != -1 && slashIndex < fileUrl.length() - 1) {
            return fileUrl.substring(slashIndex + 1);
        }
        throw new IllegalArgumentException("Invalid file URL");
    }

    private void downloadFile(String fileUrl, File outputFile) {
        URL url = new URL(fileUrl);
        try (InputStream inputStream = url.openStream();){
            Files.copy(inputStream, outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private void updateConfig() {
        if (this.container.getDescription().getVersion().isPresent() && !((String)this.container.getDescription().getVersion().get()).equals(VelocityVersion.VERSION.get(String.class))) {
            this.logger.info("Creating new configurations...");
            ((ProdConfigurator)YamlUpdater.create((File)new File(String.valueOf(this.path) + "/config.yml"), (InputStream)FileUtils.findFile((String)"https://raw.githubusercontent.com/frafol/CleanPing/refs/heads/main/velocity/src/main/resources/config.yml")).backup(true)).update();
            ((ProdConfigurator)YamlUpdater.create((File)new File(String.valueOf(this.path) + "/messages.yml"), (InputStream)FileUtils.findFile((String)"https://raw.githubusercontent.com/frafol/CleanPing/refs/heads/main/velocity/src/main/resources/messages.yml")).backup(true)).update();
            ((ProdConfigurator)YamlUpdater.create((File)new File(String.valueOf(this.path) + "/redis.yml"), (InputStream)FileUtils.findFile((String)"https://raw.githubusercontent.com/frafol/CleanPing/refs/heads/main/velocity/src/main/resources/redis.yml")).backup(true)).update();
            this.versionTextFile.getConfig().set("version", this.container.getDescription().getVersion().get());
            this.versionTextFile.getConfig().save();
            this.loadFiles();
        }
    }

    public void autoUpdate() {
        if (this.isWindows) {
            return;
        }
        String fileUrl = "https://github.com/frafol/CleanPing/releases/download/release/CleanPing.jar";
        String destination = "./plugins/";
        String fileName = this.getFileNameFromUrl(fileUrl);
        File outputFile = new File(destination, fileName);
        this.downloadFile(fileUrl, outputFile);
        this.updated = true;
        this.logger.warn("CleanPing successfully updated, a restart is required.");
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ProxyServer getServer() {
        return this.server;
    }

    public Path getPath() {
        return this.path;
    }

    public Metrics.Factory getMetricsFactory() {
        return this.metricsFactory;
    }

    public boolean isWindows() {
        return this.isWindows;
    }

    public TextFile getMessagesTextFile() {
        return this.messagesTextFile;
    }

    public TextFile getConfigTextFile() {
        return this.configTextFile;
    }

    public TextFile getRedisTextFile() {
        return this.redisTextFile;
    }

    public TextFile getVersionTextFile() {
        return this.versionTextFile;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public PluginContainer getContainer() {
        return this.container;
    }

    public static CleanPing getInstance() {
        return instance;
    }
}

