/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanping.velocity.commands;

import com.imaginarycode.minecraft.redisbungee.RedisBungeeAPI;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import it.frafol.cleanping.velocity.CleanPing;
import it.frafol.cleanping.velocity.enums.VelocityConfig;
import it.frafol.cleanping.velocity.enums.VelocityMessages;
import it.frafol.cleanping.velocity.enums.VelocityRedis;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public final class PingCommand {
    public static void register(ProxyServer proxyServer, CleanPing plugin) {
        LiteralCommandNode node = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"cleanping").executes(ctx -> {
            if (!((CommandSource)ctx.getSource()).hasPermission(VelocityConfig.PING_PERMISSION.get(String.class))) {
                ((CommandSource)ctx.getSource()).sendMessage((Component)LegacyComponentSerializer.legacySection().deserialize(VelocityMessages.NO_PERMISSION.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
                return 1;
            }
            if (!(ctx.getSource() instanceof Player)) {
                ((CommandSource)ctx.getSource()).sendMessage((Component)LegacyComponentSerializer.legacySection().deserialize(VelocityMessages.ONLY_PLAYERS.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
                return 1;
            }
            Player player = (Player)ctx.getSource();
            long ping = player.getPing();
            String color = PingCommand.colorBasedOnPing(ping);
            player.sendMessage((Component)LegacyComponentSerializer.legacySection().deserialize(VelocityMessages.PING.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%ping%", color + player.getPing())));
            return 1;
        })).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"player1", (ArgumentType)StringArgumentType.word()).requires(src -> src.hasPermission(VelocityConfig.PING_OTHERS_PERMISSION.get(String.class)))).suggests((ctx, builder) -> {
            String partialName;
            try {
                partialName = ((String)ctx.getArgument("player1", String.class)).toLowerCase();
            }
            catch (IllegalArgumentException ignored) {
                partialName = "";
            }
            if (partialName.isEmpty()) {
                proxyServer.getAllPlayers().stream().map(Player::getUsername).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
                return builder.buildFuture();
            }
            String finalPartialName = partialName;
            proxyServer.getAllPlayers().stream().map(Player::getUsername).filter(name -> name.toLowerCase().startsWith(finalPartialName)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).executes(ctx -> {
            long ping;
            Player target;
            String argument = StringArgumentType.getString((CommandContext)ctx, (String)"player1");
            if (VelocityRedis.REDIS.get(Boolean.class).booleanValue() && proxyServer.getPluginManager().isLoaded("redisbungee")) {
                RedisBungeeAPI redisBungeeAPI = RedisBungeeAPI.getRedisBungeeApi();
                UUID uuid = redisBungeeAPI.getUuidFromName(argument);
                if (uuid == null) {
                    return -1;
                }
                if (!redisBungeeAPI.isPlayerOnline(uuid)) {
                    ((CommandSource)ctx.getSource()).sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.NOT_ONLINE.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%user%", argument)));
                    return 1;
                }
                if (!(ctx.getSource() instanceof Player)) {
                    return 1;
                }
                Player player = (Player)ctx.getSource();
                String send_message = argument + ";" + String.valueOf(uuid) + ";" + redisBungeeAPI.getProxy(uuid) + ";" + String.valueOf(player.getUniqueId());
                redisBungeeAPI.sendChannelMessage("CleanPing-Request", send_message);
                return 1;
            }
            Optional optionalTarget = proxyServer.getPlayer(argument);
            if (optionalTarget.isPresent()) {
                target = (Player)optionalTarget.get();
                if (!VelocityConfig.OTHERS_PING_OPTION.get(Boolean.class).booleanValue()) {
                    ((CommandSource)ctx.getSource()).sendMessage((Component)LegacyComponentSerializer.legacySection().deserialize(VelocityMessages.USAGE.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
                    return 1;
                }
                ping = target.getPing();
                if (!VelocityConfig.DYNAMIC_PING.get(Boolean.class).booleanValue()) {
                    ((CommandSource)ctx.getSource()).sendMessage((Component)LegacyComponentSerializer.legacySection().deserialize(VelocityMessages.OTHERS_PING.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%user%", argument).replace("%ping%", Long.toString(target.getPing()))));
                    return 1;
                }
            } else {
                ((CommandSource)ctx.getSource()).sendMessage((Component)LegacyComponentSerializer.legacySection().deserialize(VelocityMessages.NOT_ONLINE.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%user%", argument)));
                return -1;
            }
            String color = PingCommand.colorBasedOnPing(ping);
            ((CommandSource)ctx.getSource()).sendMessage((Component)LegacyComponentSerializer.legacySection().deserialize(VelocityMessages.OTHERS_PING.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%user%", argument).replace("%ping%", color + target.getPing())));
            return 1;
        })).then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"player2", (ArgumentType)StringArgumentType.word()).requires(src -> src.hasPermission(VelocityConfig.DIFFERENCE_PING_PERMISSION.get(String.class)))).suggests((ctx, builder) -> {
            String partialName;
            try {
                partialName = ((String)ctx.getArgument("player2", String.class)).toLowerCase();
            }
            catch (IllegalArgumentException ignored) {
                partialName = "";
            }
            if (partialName.isEmpty()) {
                proxyServer.getAllPlayers().stream().map(Player::getUsername).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
                return builder.buildFuture();
            }
            String finalPartialName = partialName;
            proxyServer.getAllPlayers().stream().map(Player::getUsername).filter(name -> name.toLowerCase().startsWith(finalPartialName)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).executes(ctx -> {
            String argument = StringArgumentType.getString((CommandContext)ctx, (String)"player1");
            String argument2 = StringArgumentType.getString((CommandContext)ctx, (String)"player2");
            Optional optionalTarget = proxyServer.getPlayer(argument);
            Optional optionalTarget2 = proxyServer.getPlayer(argument2);
            if (optionalTarget.isPresent() && optionalTarget2.isPresent()) {
                Player target = (Player)optionalTarget.get();
                Player target2 = (Player)optionalTarget2.get();
                if (!VelocityConfig.DIFFERENCE_PING_OPTION.get(Boolean.class).booleanValue()) {
                    ((CommandSource)ctx.getSource()).sendMessage((Component)LegacyComponentSerializer.legacySection().deserialize(VelocityMessages.USAGE.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
                    return 1;
                }
                long ping = target.getPing();
                long ping2 = target2.getPing();
                long difference = PingCommand.getDifference(ping, ping2).intValue();
                ((CommandSource)ctx.getSource()).sendMessage((Component)LegacyComponentSerializer.legacySection().deserialize(VelocityMessages.PING_DIFFERENCE.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%arg1%", argument).replace("%arg2%", argument2).replace("%ping%", Long.toString(difference)).replace("%difference%", Long.toString(difference))));
            } else {
                ((CommandSource)ctx.getSource()).sendMessage((Component)LegacyComponentSerializer.legacySection().deserialize(VelocityMessages.NOT_ONLINE.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%user%", argument)));
            }
            return 1;
        })))).build();
        BrigadierCommand command = new BrigadierCommand(node);
        CommandMeta meta = proxyServer.getCommandManager().metaBuilder(command).aliases(new String[]{"ping"}).plugin((Object)plugin).build();
        proxyServer.getCommandManager().register(meta, (Command)command);
    }

    private static String colorBasedOnPing(long ping) {
        if (ping < (long)VelocityConfig.MEDIUM_MS.get(Integer.class).intValue()) {
            return VelocityConfig.LOW_MS_COLOR.color();
        }
        if (ping > (long)VelocityConfig.MEDIUM_MS.get(Integer.class).intValue() && ping < (long)VelocityConfig.HIGH_MS.get(Integer.class).intValue()) {
            return VelocityConfig.MEDIUM_MS_COLOR.color();
        }
        return VelocityConfig.HIGH_MS_COLOR.color();
    }

    private static Integer getDifference(long ping1, long ping2) {
        if (ping1 > ping2) {
            return (int)Math.abs(ping1 - ping2);
        }
        return (int)Math.abs(ping2 - ping1);
    }
}

