/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanping.velocity.hooks;

import com.imaginarycode.minecraft.redisbungee.RedisBungeeAPI;
import com.imaginarycode.minecraft.redisbungee.events.PubSubMessageEvent;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.proxy.Player;
import it.frafol.cleanping.velocity.CleanPing;
import it.frafol.cleanping.velocity.enums.VelocityConfig;
import it.frafol.cleanping.velocity.enums.VelocityMessages;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.jetbrains.annotations.NotNull;

public class RedisListener {
    public final CleanPing PLUGIN;

    public RedisListener(CleanPing plugin) {
        this.PLUGIN = plugin;
    }

    @Subscribe(priority=32767)
    public void onRedisBungeeMessage(@NotNull PubSubMessageEvent event) {
        String player_name;
        String received_message;
        RedisBungeeAPI redisBungeeAPI = RedisBungeeAPI.getRedisBungeeApi();
        if (event.getChannel().equals("CleanPing-Request")) {
            received_message = event.getMessage();
            player_name = received_message.split(";")[0];
            UUID player_uuid = UUID.fromString(received_message.split(";")[1]);
            String player_server = received_message.split(";")[2];
            UUID source = UUID.fromString(received_message.split(";")[3]);
            if (!redisBungeeAPI.getProxyId().equals(player_server)) {
                return;
            }
            if (this.PLUGIN.getServer().getPlayer(player_uuid).isEmpty()) {
                return;
            }
            Optional final_player = this.PLUGIN.getServer().getPlayer(player_uuid);
            if (final_player.isEmpty()) {
                return;
            }
            long ping = ((Player)final_player.get()).getPing();
            String response_message = player_name + ";" + String.valueOf(player_uuid) + ";" + redisBungeeAPI.getProxy(player_uuid) + ";" + String.valueOf(source) + ";" + ping;
            redisBungeeAPI.sendChannelMessage("CleanPing-Response", response_message);
        }
        if (event.getChannel().equals("CleanPing-Response")) {
            received_message = event.getMessage();
            player_name = received_message.split(";")[0];
            String player_server = received_message.split(";")[2];
            UUID source = UUID.fromString(received_message.split(";")[3]);
            long ping = Long.parseLong(received_message.split(";")[4]);
            if (redisBungeeAPI.getProxyId().equals(player_server)) {
                return;
            }
            if (this.PLUGIN.getServer().getPlayer(source).isEmpty()) {
                return;
            }
            if (!VelocityConfig.DYNAMIC_PING.get(Boolean.class).booleanValue()) {
                ((Player)this.PLUGIN.getServer().getPlayer(source).get()).sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.OTHERS_PING.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%user%", player_name).replace("%ping%", String.valueOf(ping))));
                return;
            }
            ((Player)this.PLUGIN.getServer().getPlayer(source).get()).sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.OTHERS_PING.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%user%", player_name).replace("%ping%", RedisListener.colorBasedOnPing(ping) + ping)));
        }
    }

    private static String colorBasedOnPing(long ping) {
        if (ping < (long)VelocityConfig.MEDIUM_MS.get(Integer.class).intValue()) {
            return VelocityConfig.LOW_MS_COLOR.color();
        }
        if (ping > (long)VelocityConfig.MEDIUM_MS.get(Integer.class).intValue() && ping < (long)VelocityConfig.HIGH_MS.get(Integer.class).intValue()) {
            return VelocityConfig.MEDIUM_MS_COLOR.color();
        }
        return VelocityConfig.HIGH_MS_COLOR.color();
    }
}

