/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.aitools.common.blocks.entities;

import com.st0x0ef.aitools.common.components.AIToolData;
import com.st0x0ef.aitools.common.menus.ComputerMenu;
import com.st0x0ef.aitools.common.recipes.ComputerInput;
import com.st0x0ef.aitools.common.recipes.ComputerRecipe;
import com.st0x0ef.aitools.common.registries.BlockEntitiesRegistry;
import com.st0x0ef.aitools.common.registries.DataComponentsRegistry;
import com.st0x0ef.aitools.common.registries.RecipesRegistry;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ComputerBlockEntity
extends BaseContainerBlockEntity {
    private NonNullList<ItemStack> items = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    private final RecipeManager.CachedCheck<ComputerInput, ComputerRecipe> quickCheck = RecipeManager.createCheck((RecipeType)((RecipeType)RecipesRegistry.COMPUTER_TYPE.get()));

    public ComputerBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)BlockEntitiesRegistry.COMPUTER.get(), pos, blockState);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.aitools.computer");
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> newItems) {
        this.items = NonNullList.copyOf(newItems);
    }

    protected AbstractContainerMenu createMenu(int i, Inventory inventory) {
        return new ComputerMenu(i, inventory, (Container)this);
    }

    public int getContainerSize() {
        return 4;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)provider);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)provider);
    }

    public void tick(Level level) {
        Optional recipeHolder;
        if (level.isClientSide()) {
            return;
        }
        ItemStack outputStack = this.getItem(3);
        if (outputStack.isEmpty() && (recipeHolder = this.quickCheck.getRecipeFor((RecipeInput)new ComputerInput(this.getLevel().getBlockEntity(this.getBlockPos()), this.getItems()), level)).isPresent()) {
            ComputerRecipe recipe = (ComputerRecipe)((RecipeHolder)recipeHolder.get()).value();
            ItemStack resultStack = recipe.getResultItem((HolderLookup.Provider)level.registryAccess()).copy();
            ArrayList<AIToolData> AIToolDataList = new ArrayList<AIToolData>();
            for (int i = 0; i < 3; ++i) {
                ItemStack stack = this.getItem(i);
                if (stack.has(DataComponentsRegistry.AI_TOOL_DATA.get())) {
                    AIToolDataList.add((AIToolData)stack.get(DataComponentsRegistry.AI_TOOL_DATA.get()));
                }
                stack.shrink(1);
                if (!stack.isEmpty()) continue;
                this.setItem(i, ItemStack.EMPTY);
            }
            if (AIToolDataList.size() == 2) {
                resultStack.set(DataComponentsRegistry.AI_TOOL_DATA.get(), (Object)AIToolData.add((AIToolData)AIToolDataList.get(0), (AIToolData)AIToolDataList.get(1)));
            }
            this.setItem(3, resultStack);
            this.setChanged();
        }
    }
}

