/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.aitools.common.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.st0x0ef.aitools.common.config.Config;
import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public record AIToolData(Map<ResourceLocation, Integer> blocksBrokenData, int fortuneLevel, int radiusLevel, int efficiencyLevel) implements Serializable
{
    public static final Codec<AIToolData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)Codec.INT).fieldOf("blocksBrokenData").forGetter(AIToolData::blocksBrokenData), (App)Codec.INT.fieldOf("fortuneLevel").forGetter(AIToolData::fortuneLevel), (App)Codec.INT.fieldOf("radiusLevel").forGetter(AIToolData::radiusLevel), (App)Codec.INT.fieldOf("efficiencyLevel").forGetter(AIToolData::efficiencyLevel)).apply((Applicative)instance, AIToolData::new));
    public static final StreamCodec<ByteBuf, AIToolData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ResourceLocation.STREAM_CODEC, (StreamCodec)ByteBufCodecs.VAR_INT), AIToolData::blocksBrokenData, (StreamCodec)ByteBufCodecs.INT, AIToolData::fortuneLevel, (StreamCodec)ByteBufCodecs.INT, AIToolData::radiusLevel, (StreamCodec)ByteBufCodecs.INT, AIToolData::efficiencyLevel, AIToolData::new);

    public static AIToolData add(AIToolData data1, AIToolData data2) {
        int newFortuneLevel = Math.min(data1.fortuneLevel() + data2.fortuneLevel(), Config.MAX_FORTUNE_LEVEL.getAsInt());
        int newRadiusLevel = Math.min(data1.radiusLevel() + data2.radiusLevel(), Config.MAX_RADIUS_LEVEL.getAsInt());
        int newEfficiencyLevel = Math.min(data1.efficiencyLevel() + data2.efficiencyLevel(), Config.MAX_EFFICIENCY_LEVEL.getAsInt());
        AIToolData dataToReturn = new AIToolData(data1.blocksBrokenData(), newFortuneLevel, newRadiusLevel, newEfficiencyLevel);
        data2.blocksBrokenData().forEach((location, amount) -> {
            dataToReturn.blocksBrokenData.computeIfPresent((ResourceLocation)location, (location1, actualAmount) -> actualAmount + amount);
            dataToReturn.blocksBrokenData.putIfAbsent((ResourceLocation)location, (Integer)amount);
        });
        return dataToReturn;
    }

    public static AIToolData empty() {
        return new AIToolData(new HashMap<ResourceLocation, Integer>(), 0, 0, 0);
    }
}

