/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.aitools.common.items;

import com.st0x0ef.aitools.common.items.AIItemsUtils;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class AIAxe
extends AxeItem {
    public AIAxe(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        ResourceLocation blockLocation = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
        float miningSpeedMultiplier = AIItemsUtils.getMiningSpeedMultiplier(stack, blockLocation);
        return super.getDestroySpeed(stack, state) * miningSpeedMultiplier;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return state.is(BlockTags.MINEABLE_WITH_AXE);
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        ResourceLocation blockLocation;
        if (level.isClientSide || !state.is(BlockTags.MINEABLE_WITH_AXE)) {
            return true;
        }
        HashMap<ResourceLocation, Integer> blocksBrokenMap = new HashMap<ResourceLocation, Integer>(AIItemsUtils.getBlocksBrokenMap(stack));
        if (blocksBrokenMap.containsKey(blockLocation = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()))) {
            blocksBrokenMap.compute(blockLocation, (k, currentCount) -> currentCount + 1);
        } else {
            blocksBrokenMap.put(blockLocation, 1);
        }
        if (AIItemsUtils.getMiningRadiusLevel(stack) > 0) {
            List<ResourceLocation> blocksBroken = AIItemsUtils.mineRadius(level, pos, (Entity)miningEntity, (TagKey<Block>)BlockTags.MINEABLE_WITH_AXE, AIItemsUtils.getMiningRadiusLevel(stack));
            for (ResourceLocation location : blocksBroken) {
                if (blocksBrokenMap.containsKey(location)) {
                    blocksBrokenMap.compute(location, (k, currentCount) -> currentCount + 1);
                    continue;
                }
                blocksBrokenMap.put(location, 1);
            }
        }
        AIItemsUtils.setData(stack, blocksBrokenMap);
        AIItemsUtils.syncFortuneToVanillaEnchantments(stack, (HolderLookup.Provider)level.registryAccess());
        return true;
    }

    public int getEnchantmentLevel(ItemStack stack, Holder<Enchantment> enchantment) {
        if (enchantment.is(Enchantments.FORTUNE)) {
            return AIItemsUtils.getFortuneLevel(stack);
        }
        return 0;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        AIItemsUtils.createTooltip(stack, tooltipComponents);
    }
}

