/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.aitools.common.items;

import com.st0x0ef.aitools.common.components.AIToolData;
import com.st0x0ef.aitools.common.config.Config;
import com.st0x0ef.aitools.common.registries.DataComponentsRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class AIItemsUtils {
    public static float getMiningSpeedMultiplier(ItemStack stack, ResourceLocation blockLocation) {
        int blocksBroken = AIItemsUtils.getBlocksBrokenMap(stack).getOrDefault(blockLocation, 0);
        float speedMultiplier = blocksBroken < 110 ? 1.0f : (blocksBroken < 500 ? (float)blocksBroken / 390.0f + 0.71794873f : (float)Math.log10((float)blocksBroken - 400.0f));
        return Math.min(speedMultiplier *= 1.0f + (float)AIItemsUtils.getEfficiencyLevel(stack) * 0.2f, (float)Config.MAX_SPEED_MULTIPLIER.getAsInt());
    }

    public static void syncFortuneToVanillaEnchantments(ItemStack stack, HolderLookup.Provider registries) {
        int level = AIItemsUtils.getFortuneLevel(stack);
        ItemEnchantments current = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(current);
        HolderLookup.RegistryLookup registry = registries.lookupOrThrow(Registries.ENCHANTMENT);
        Holder.Reference fortune = registry.getOrThrow(Enchantments.FORTUNE);
        if (level > 0) {
            mutable.set((Holder)fortune, level);
        } else {
            mutable.removeIf(enchantmentHolder -> enchantmentHolder.equals((Object)fortune));
        }
        stack.set(DataComponents.ENCHANTMENTS, (Object)mutable.toImmutable());
        stack.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)false);
    }

    public static Map<ResourceLocation, Integer> getBlocksBrokenMap(ItemStack stack) {
        AIToolData blocksBroken = (AIToolData)stack.get(DataComponentsRegistry.AI_TOOL_DATA.get());
        if (blocksBroken == null) {
            blocksBroken = AIToolData.empty();
            stack.set(DataComponentsRegistry.AI_TOOL_DATA.get(), (Object)blocksBroken);
        }
        return blocksBroken.blocksBrokenData();
    }

    public static int getFortuneLevel(ItemStack stack) {
        return Math.min(((AIToolData)stack.getOrDefault(DataComponentsRegistry.AI_TOOL_DATA.get(), (Object)AIToolData.empty())).fortuneLevel(), Config.MAX_FORTUNE_LEVEL.getAsInt());
    }

    public static int getMiningRadiusLevel(ItemStack stack) {
        return Math.min(((AIToolData)stack.getOrDefault(DataComponentsRegistry.AI_TOOL_DATA.get(), (Object)AIToolData.empty())).radiusLevel(), Config.MAX_RADIUS_LEVEL.getAsInt());
    }

    public static int getEfficiencyLevel(ItemStack stack) {
        return Math.min(((AIToolData)stack.getOrDefault(DataComponentsRegistry.AI_TOOL_DATA.get(), (Object)AIToolData.empty())).efficiencyLevel(), Config.MAX_EFFICIENCY_LEVEL.getAsInt());
    }

    public static void createTooltip(ItemStack stack, List<Component> tooltipComponents) {
        Map<ResourceLocation, Integer> blocksBrokenMap;
        int efficiencyLevel;
        int radiusLevel;
        int fortuneLevel = AIItemsUtils.getFortuneLevel(stack);
        if (fortuneLevel > 0) {
            tooltipComponents.add((Component)Component.literal((String)("Fortune level : " + fortuneLevel)).withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.LIGHT_PURPLE));
        }
        if ((radiusLevel = AIItemsUtils.getMiningRadiusLevel(stack)) > 0) {
            tooltipComponents.add((Component)Component.literal((String)("Mining radius : " + (radiusLevel * 2 + 1) + "x" + (radiusLevel * 2 + 1))).withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.RED));
        }
        if ((efficiencyLevel = AIItemsUtils.getEfficiencyLevel(stack)) > 0) {
            tooltipComponents.add((Component)Component.literal((String)("Efficiency level : " + efficiencyLevel)).withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.GREEN));
        }
        if (!(blocksBrokenMap = AIItemsUtils.getBlocksBrokenMap(stack)).isEmpty()) {
            tooltipComponents.add((Component)Component.literal((String)"Blocks broken : ").withStyle(ChatFormatting.GRAY));
            AtomicInteger i = new AtomicInteger();
            blocksBrokenMap.forEach((location, amount) -> {
                if (i.incrementAndGet() <= 10) {
                    tooltipComponents.add((Component)Component.literal((String)(location.toString() + " x " + amount)).withStyle(ChatFormatting.GRAY));
                }
            });
        }
    }

    public static List<ResourceLocation> mineRadius(Level level, BlockPos origin, Entity entity, TagKey<Block> mineableTag, int radius) {
        Direction faceDir = entity.getDirection();
        Direction.Axis axis = faceDir.getAxis();
        ArrayList<ResourceLocation> blocksBroken = new ArrayList<ResourceLocation>();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos targetPos;
                    BlockState targetState;
                    if (!AIItemsUtils.isInPlane(axis, dx, dy, dz) || dx == 0 && dy == 0 && dz == 0 || (targetState = level.getBlockState(targetPos = origin.offset(dx, dy, dz))).isAir() || !targetState.is(mineableTag) || targetState.getDestroySpeed((BlockGetter)level, targetPos) < 0.0f) continue;
                    blocksBroken.add(BuiltInRegistries.BLOCK.getKey((Object)targetState.getBlock()));
                    level.destroyBlock(targetPos, true, entity);
                }
            }
        }
        return blocksBroken;
    }

    public static boolean isInPlane(Direction.Axis axis, int dx, int dy, int dz) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> {
                if (dy != Integer.MIN_VALUE && dz != Integer.MIN_VALUE && dx == 0) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Y -> {
                if (dx != Integer.MIN_VALUE && dz != Integer.MIN_VALUE && dy == 0) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Z -> dx != Integer.MIN_VALUE && dy != Integer.MIN_VALUE && dz == 0;
        };
    }

    public static int getRandomChangeToGetFortuneUpgrade(ItemStack stack) {
        int actualFortuneLevel = AIItemsUtils.getFortuneLevel(stack);
        Map<ResourceLocation, Integer> blocksBrokenMap = AIItemsUtils.getBlocksBrokenMap(stack);
        if (actualFortuneLevel >= Config.MAX_FORTUNE_LEVEL.getAsInt()) {
            return 0;
        }
        int numberOfBlocksBroken = blocksBrokenMap.values().stream().mapToInt(Integer::intValue).sum();
        double chance = Math.min(0.25f, ((float)numberOfBlocksBroken / 10000.0f - (float)actualFortuneLevel) * 0.01f);
        return Math.random() < chance ? 1 : 0;
    }

    public static int getRandomChangeToGetRadiusUpgrade(ItemStack stack) {
        int actualRadiusLevel = AIItemsUtils.getMiningRadiusLevel(stack);
        Map<ResourceLocation, Integer> blocksBrokenMap = AIItemsUtils.getBlocksBrokenMap(stack);
        if (actualRadiusLevel >= Config.MAX_RADIUS_LEVEL.getAsInt()) {
            return 0;
        }
        int numberOfBlocksBroken = blocksBrokenMap.values().stream().mapToInt(Integer::intValue).sum();
        double chance = Math.min(0.25f, ((float)numberOfBlocksBroken / 10000.0f - (float)actualRadiusLevel) * 0.01f);
        return Math.random() < chance ? 1 : 0;
    }

    public static int getRandomChangeToGetEfficiencyUpgrade(ItemStack stack) {
        int actualEfficiencyLevel = AIItemsUtils.getEfficiencyLevel(stack);
        Map<ResourceLocation, Integer> blocksBrokenMap = AIItemsUtils.getBlocksBrokenMap(stack);
        if (actualEfficiencyLevel >= Config.MAX_EFFICIENCY_LEVEL.getAsInt()) {
            return 0;
        }
        int numberOfBlocksBroken = blocksBrokenMap.values().stream().mapToInt(Integer::intValue).sum();
        double chance = Math.min(0.25f, ((float)numberOfBlocksBroken / 10000.0f - (float)actualEfficiencyLevel) * 0.01f);
        return Math.random() < chance ? 1 : 0;
    }

    public static void setData(ItemStack stack, Map<ResourceLocation, Integer> newBlocksBrokenMap) {
        stack.set(DataComponentsRegistry.AI_TOOL_DATA.get(), (Object)new AIToolData(newBlocksBrokenMap, AIItemsUtils.getFortuneLevel(stack) + AIItemsUtils.getRandomChangeToGetFortuneUpgrade(stack), AIItemsUtils.getMiningRadiusLevel(stack) + AIItemsUtils.getRandomChangeToGetRadiusUpgrade(stack), AIItemsUtils.getEfficiencyLevel(stack) + AIItemsUtils.getRandomChangeToGetEfficiencyUpgrade(stack)));
    }
}

