/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.aitools.common.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.LootModifier;

public class AddItemToChestsModifier
extends LootModifier {
    public static final MapCodec<AddItemToChestsModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(m -> m.item)).and((App)Codec.INT.fieldOf("min").forGetter(m -> m.min)).and((App)Codec.INT.fieldOf("max").forGetter(m -> m.max)).and((App)Codec.FLOAT.fieldOf("chance").forGetter(m -> Float.valueOf(m.chance))).and((App)ResourceLocation.CODEC.listOf().fieldOf("tables").forGetter(m -> m.tables)).apply((Applicative)inst, AddItemToChestsModifier::new));
    private final Item item;
    private final int min;
    private final int max;
    private final float chance;
    private final List<ResourceLocation> tables;

    public AddItemToChestsModifier(LootItemCondition[] conditions, Item item, int min, int max, float chance, List<ResourceLocation> tables) {
        super(conditions);
        this.item = item;
        this.min = min;
        this.max = max;
        this.chance = chance;
        this.tables = tables;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ResourceLocation tableId = context.getQueriedLootTableId();
        if (this.tables.contains(tableId) && context.getRandom().nextFloat() < this.chance) {
            int bound = Math.max(1, this.max - this.min + 1);
            int count = this.min + context.getRandom().nextInt(bound);
            if (count > 0) {
                generatedLoot.add((Object)new ItemStack((ItemLike)this.item, count));
            }
        }
        return generatedLoot;
    }

    public MapCodec<? extends LootModifier> codec() {
        return CODEC;
    }
}

