/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.aitools.common.menus;

import com.st0x0ef.aitools.common.menus.ResultSlot;
import com.st0x0ef.aitools.common.registries.MenuTypesRegistry;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ComputerMenu
extends AbstractContainerMenu {
    private final Container inventory;

    public ComputerMenu(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(4));
    }

    public ComputerMenu(int syncId, Inventory inventory, Container container) {
        super((MenuType)MenuTypesRegistry.COMPUTER.get(), syncId);
        ComputerMenu.checkContainerSize((Container)container, (int)4);
        this.inventory = container;
        this.addSlots(container);
        this.addPlayerHotbar(inventory);
        this.addPlayerInventory(inventory);
    }

    public ItemStack quickMoveStack(Player player, int invSlot) {
        ItemStack newStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(invSlot);
        if (slot.hasItem()) {
            ItemStack originalStack = slot.getItem();
            newStack = originalStack.copy();
            if (invSlot < this.inventory.getContainerSize() ? !this.moveItemStackTo(originalStack, this.inventory.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(originalStack, 0, this.inventory.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (originalStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return newStack;
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    private void addSlots(Container inventory) {
        this.addSlot(new Slot(inventory, 0, 26, 44));
        this.addSlot(new Slot(inventory, 1, 57, 44));
        this.addSlot(new Slot(inventory, 2, 88, 44));
        this.addSlot(new ResultSlot(inventory, 3, 135, 44));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

