/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.aitools.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.st0x0ef.aitools.common.blocks.entities.ComputerBlockEntity;
import com.st0x0ef.aitools.common.recipes.ComputerInput;
import com.st0x0ef.aitools.common.registries.RecipesRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record ComputerRecipe(List<Ingredient> recipeItems, ItemStack output) implements Recipe<ComputerInput>
{
    public static RecipeType<?> TYPE = (RecipeType)RecipesRegistry.COMPUTER_TYPE.get();

    public boolean matches(ComputerInput container, Level level) {
        for (int i = 0; i < ((ComputerBlockEntity)container.entity()).getContainerSize() - 1; ++i) {
            if (this.recipeItems.get(i).test(container.getItem(i))) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(ComputerInput container, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int i, int j) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.createWithCapacity((int)this.recipeItems.size());
        list.addAll(this.recipeItems);
        return list;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipesRegistry.COMPUTER_SERIALIZED.get();
    }

    public RecipeType<?> getType() {
        return TYPE;
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<ComputerRecipe> {
        public static final MapCodec<ComputerRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.listOf(1, 3).fieldOf("ingredients").forGetter(r -> r.recipeItems), (App)ItemStack.CODEC.fieldOf("output").forGetter(r -> r.output)).apply((Applicative)instance, ComputerRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, List<Ingredient>> INGREDIENT_LIST_STREAM_CODEC = ByteBufCodecs.collection(ArrayList::new, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, (int)3);
        public static final StreamCodec<RegistryFriendlyByteBuf, ComputerRecipe> STREAM_CODEC = StreamCodec.of((buf, recipe) -> {
            INGREDIENT_LIST_STREAM_CODEC.encode(buf, recipe.recipeItems);
            ItemStack.STREAM_CODEC.encode(buf, (Object)recipe.output);
        }, buf -> new ComputerRecipe((List)INGREDIENT_LIST_STREAM_CODEC.decode(buf), (ItemStack)ItemStack.STREAM_CODEC.decode(buf)));

        public MapCodec<ComputerRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ComputerRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

