/*
 * Decompiled with CFR 0.152.
 */
package pk.ajneb97;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import pk.ajneb97.PlayerKits2;
import pk.ajneb97.configs.MainConfigManager;
import pk.ajneb97.managers.MessagesManager;
import pk.ajneb97.model.Kit;
import pk.ajneb97.model.internal.GiveKitInstructions;
import pk.ajneb97.model.internal.PlayerKitsMessageResult;
import pk.ajneb97.model.inventory.InventoryPlayer;
import pk.ajneb97.model.inventory.KitInventory;
import pk.ajneb97.utils.PlayerUtils;

public class MainCommand
implements CommandExecutor,
TabCompleter {
    private PlayerKits2 plugin;

    public MainCommand(PlayerKits2 plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        MessagesManager msgManager = this.plugin.getMessagesManager();
        FileConfiguration messagesConfig = this.plugin.getConfigsManager().getMessagesConfigManager().getConfig();
        if (!(sender instanceof Player)) {
            if (args.length >= 1) {
                if (args[0].equalsIgnoreCase("reload")) {
                    this.reload(sender, args, messagesConfig, msgManager);
                } else if (args[0].equalsIgnoreCase("give")) {
                    this.give(sender, args, messagesConfig, msgManager);
                } else if (args[0].equalsIgnoreCase("delete")) {
                    this.delete(sender, args, messagesConfig, msgManager);
                } else if (args[0].equalsIgnoreCase("reset")) {
                    this.reset(sender, args, messagesConfig, msgManager);
                } else if (args[0].equalsIgnoreCase("migrate")) {
                    this.migrate(sender, args, messagesConfig, msgManager);
                } else if (args[0].equalsIgnoreCase("open")) {
                    this.open(sender, args, messagesConfig, msgManager);
                } else if (args[0].equalsIgnoreCase("preview")) {
                    this.preview(sender, args, messagesConfig, msgManager);
                } else {
                    this.help(sender, msgManager, messagesConfig);
                }
            }
            return true;
        }
        Player player = (Player)sender;
        boolean claimKitShortCommand = this.plugin.getConfigsManager().getMainConfigManager().getConfig().getBoolean("claim_kit_short_command");
        if (args.length >= 1) {
            if (args[0].equalsIgnoreCase("claim") && !claimKitShortCommand) {
                this.claim(player, args, messagesConfig, msgManager);
            } else if (args[0].equalsIgnoreCase("preview")) {
                this.preview((CommandSender)player, args, messagesConfig, msgManager);
            } else if (args[0].equalsIgnoreCase("create")) {
                this.create(player, args, messagesConfig, msgManager);
            } else if (args[0].equalsIgnoreCase("give")) {
                this.give((CommandSender)player, args, messagesConfig, msgManager);
            } else if (args[0].equalsIgnoreCase("delete")) {
                this.delete((CommandSender)player, args, messagesConfig, msgManager);
            } else if (args[0].equalsIgnoreCase("reload")) {
                this.reload((CommandSender)player, args, messagesConfig, msgManager);
            } else if (args[0].equalsIgnoreCase("reset")) {
                this.reset(sender, args, messagesConfig, msgManager);
            } else if (args[0].equalsIgnoreCase("edit")) {
                this.edit(player, args, messagesConfig, msgManager);
            } else if (args[0].equalsIgnoreCase("verify")) {
                this.verify(player, messagesConfig, msgManager);
            } else if (args[0].equalsIgnoreCase("migrate")) {
                this.migrate(sender, args, messagesConfig, msgManager);
            } else if (args[0].equalsIgnoreCase("open")) {
                this.open(sender, args, messagesConfig, msgManager);
            } else {
                if (claimKitShortCommand) {
                    this.claimKitShortCommand(player, messagesConfig, msgManager, args[0]);
                    return true;
                }
                this.help(sender, msgManager, messagesConfig);
            }
        } else {
            if (this.plugin.getVerifyManager().isCriticalErrors()) {
                msgManager.sendMessage((CommandSender)player, messagesConfig.getString("pluginCriticalErrors"), true);
                return true;
            }
            this.plugin.getInventoryManager().openInventory(new InventoryPlayer(player, "main_inventory"));
        }
        return true;
    }

    public void help(CommandSender sender, MessagesManager msgManager, FileConfiguration messagesConfig) {
        if (!PlayerUtils.isPlayerKitsAdmin(sender)) {
            msgManager.sendMessage(sender, messagesConfig.getString("commandDoesNotExists"), true);
            return;
        }
        sender.sendMessage(MessagesManager.getColoredMessage("&7[ [ &8[&bPlayerKits&a\u00b2&8] &7] ]"));
        sender.sendMessage(MessagesManager.getColoredMessage(" "));
        sender.sendMessage(MessagesManager.getColoredMessage("&6/kit &8Opens the GUI."));
        sender.sendMessage(MessagesManager.getColoredMessage("&6/kit claim <kit> &8Claims a kit outside the GUI."));
        sender.sendMessage(MessagesManager.getColoredMessage("&6/kit create <kit> (optional)original &8Creates a new kit using the items in your inventory."));
        sender.sendMessage(MessagesManager.getColoredMessage("&6/kit edit <kit> &8Edits a kit."));
        sender.sendMessage(MessagesManager.getColoredMessage("&6/kit give <kit> <player> &8Gives a kit to a player."));
        sender.sendMessage(MessagesManager.getColoredMessage("&6/kit delete <kit> &8Deletes a kit."));
        sender.sendMessage(MessagesManager.getColoredMessage("&6/kit reset <kit> <player>/* &8Resets kit data for a player."));
        sender.sendMessage(MessagesManager.getColoredMessage("&6/kit preview <kit> (optional)<player> &8Previews a kit."));
        sender.sendMessage(MessagesManager.getColoredMessage("&6/kit open <inventory> <player> &8Opens a specific inventory for a player."));
        sender.sendMessage(MessagesManager.getColoredMessage("&6/kit reload &8Reloads the config."));
        sender.sendMessage(MessagesManager.getColoredMessage("&6/kit verify &8Checks the plugin for errors."));
        sender.sendMessage(MessagesManager.getColoredMessage(" "));
        sender.sendMessage(MessagesManager.getColoredMessage("&7[ [ &8[&bPlayerKits&a\u00b2&8] &7] ]"));
    }

    public void migrate(CommandSender sender, String[] args, FileConfiguration messagesConfig, MessagesManager msgManager) {
        if (!PlayerUtils.isPlayerKitsAdmin(sender)) {
            msgManager.sendMessage(sender, messagesConfig.getString("noPermissions"), true);
            return;
        }
        this.plugin.getMigrationManager().migrate(sender);
    }

    public void verify(Player player, FileConfiguration messagesConfig, MessagesManager msgManager) {
        if (!PlayerUtils.isPlayerKitsAdmin((CommandSender)player)) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("noPermissions"), true);
            return;
        }
        this.plugin.getVerifyManager().sendVerification(player);
    }

    public void reload(CommandSender sender, String[] args, FileConfiguration messagesConfig, MessagesManager msgManager) {
        if (!PlayerUtils.isPlayerKitsAdmin(sender)) {
            msgManager.sendMessage(sender, messagesConfig.getString("noPermissions"), true);
            return;
        }
        if (!this.plugin.getConfigsManager().reload()) {
            sender.sendMessage(PlayerKits2.prefix + MessagesManager.getColoredMessage(" &cThere was an error reloading the config, check the console."));
            return;
        }
        msgManager.sendMessage(sender, messagesConfig.getString("commandReload"), true);
    }

    public void reset(CommandSender sender, String[] args, FileConfiguration messagesConfig, MessagesManager msgManager) {
        if (!PlayerUtils.isPlayerKitsAdmin(sender)) {
            msgManager.sendMessage(sender, messagesConfig.getString("noPermissions"), true);
            return;
        }
        if (args.length < 3) {
            msgManager.sendMessage(sender, messagesConfig.getString("commandResetError"), true);
            return;
        }
        String kitName = args[1];
        String playerName = args[2];
        PlayerKitsMessageResult result = this.plugin.getPlayerDataManager().resetKitForPlayer(playerName, kitName, playerName.equals("*"));
        if (result.isError()) {
            msgManager.sendMessage(sender, result.getMessage(), true);
        } else if (playerName.equals("*")) {
            msgManager.sendMessage(sender, messagesConfig.getString("kitResetCorrectAll").replace("%kit%", kitName), true);
        } else {
            msgManager.sendMessage(sender, messagesConfig.getString("kitResetCorrect").replace("%kit%", kitName).replace("%player%", playerName), true);
        }
    }

    public void open(CommandSender sender, String[] args, FileConfiguration messagesConfig, MessagesManager msgManager) {
        if (!PlayerUtils.isPlayerKitsAdmin(sender)) {
            msgManager.sendMessage(sender, messagesConfig.getString("noPermissions"), true);
            return;
        }
        if (args.length < 3) {
            msgManager.sendMessage(sender, messagesConfig.getString("commandOpenError"), true);
            return;
        }
        String inventoryName = args[1];
        String playerName = args[2];
        if (this.plugin.getInventoryManager().getInventory(inventoryName) == null) {
            msgManager.sendMessage(sender, messagesConfig.getString("inventoryNotExists"), true);
            return;
        }
        Player player = Bukkit.getPlayer((String)playerName);
        if (player == null) {
            msgManager.sendMessage(sender, messagesConfig.getString("playerNotOnline").replace("%player%", playerName), true);
            return;
        }
        InventoryPlayer inventoryPlayer = new InventoryPlayer(player, inventoryName);
        this.plugin.getInventoryManager().openInventory(inventoryPlayer);
    }

    public void give(CommandSender sender, String[] args, FileConfiguration messagesConfig, MessagesManager msgManager) {
        if (!PlayerUtils.isPlayerKitsAdmin(sender)) {
            msgManager.sendMessage(sender, messagesConfig.getString("noPermissions"), true);
            return;
        }
        if (args.length < 3) {
            msgManager.sendMessage(sender, messagesConfig.getString("commandGiveError"), true);
            return;
        }
        String kitName = args[1];
        Player player = Bukkit.getPlayer((String)args[2]);
        if (player == null) {
            msgManager.sendMessage(sender, messagesConfig.getString("playerNotOnline").replace("%player%", args[2]), true);
            return;
        }
        PlayerKitsMessageResult result = this.plugin.getKitsManager().giveKit(player, kitName, new GiveKitInstructions(true, false, false, false));
        if (result.isError()) {
            msgManager.sendMessage(sender, messagesConfig.getString("commandGiveError2").replace("%error%", result.getMessage()), true);
        } else {
            msgManager.sendMessage(sender, messagesConfig.getString("commandGiveCorrect").replace("%kit%", kitName).replace("%player%", args[2]), true);
        }
    }

    public void claim(Player player, String[] args, FileConfiguration messagesConfig, MessagesManager msgManager) {
        if (args.length < 2) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("commandClaimError"), true);
            return;
        }
        String kitName = args[1];
        this.claimKitShortCommand(player, messagesConfig, msgManager, kitName);
    }

    public void preview(CommandSender sender, String[] args, FileConfiguration messagesConfig, MessagesManager msgManager) {
        Player player;
        MainConfigManager mainConfigManager = this.plugin.getConfigsManager().getMainConfigManager();
        if (!mainConfigManager.isKitPreview()) {
            msgManager.sendMessage(sender, messagesConfig.getString("kitPreviewDisabled"), true);
            return;
        }
        if (args.length < 2) {
            msgManager.sendMessage(sender, messagesConfig.getString("commandPreviewError"), true);
            return;
        }
        Kit kit = this.plugin.getKitsManager().getKitByName(args[1]);
        if (kit == null) {
            msgManager.sendMessage(sender, messagesConfig.getString("kitDoesNotExists").replace("%kit%", args[1]), true);
            return;
        }
        if (args.length > 2) {
            if (!PlayerUtils.isPlayerKitsAdmin(sender)) {
                msgManager.sendMessage(sender, messagesConfig.getString("noPermissions"), true);
                return;
            }
            player = Bukkit.getPlayer((String)args[2]);
            if (player == null) {
                msgManager.sendMessage(sender, messagesConfig.getString("playerNotOnline").replace("%player%", args[2]), true);
                return;
            }
            msgManager.sendMessage(sender, messagesConfig.getString("commandPreviewOtherCorrect").replace("%kit%", args[1]).replace("%player%", args[2]), true);
        } else {
            if (kit.isPermissionRequired() && mainConfigManager.isKitPreviewRequiresKitPermission() && !kit.playerHasPermission(sender)) {
                msgManager.sendMessage(sender, messagesConfig.getString("cantPreviewError"), true);
                return;
            }
            if (!(sender instanceof Player)) {
                msgManager.sendMessage(sender, messagesConfig.getString("onlyPlayerCommand"), true);
                return;
            }
            player = (Player)sender;
        }
        InventoryPlayer inventoryPlayer = new InventoryPlayer(player, "preview_inventory");
        inventoryPlayer.setKitName(args[1]);
        inventoryPlayer.setPreviousInventoryName("main_inventory");
        this.plugin.getInventoryManager().openInventory(inventoryPlayer);
    }

    public void claimKitShortCommand(Player player, FileConfiguration messagesConfig, MessagesManager msgManager, String kitName) {
        PlayerKitsMessageResult result = this.plugin.getKitsManager().giveKit(player, kitName, new GiveKitInstructions());
        if (result.isError()) {
            msgManager.sendMessage((CommandSender)player, result.getMessage(), true);
        } else {
            if (result.isProceedToBuy()) {
                InventoryPlayer inventoryPlayer = new InventoryPlayer(player, "buy_requirements_inventory");
                inventoryPlayer.setKitName(kitName);
                inventoryPlayer.setPreviousInventoryName("main_inventory");
                this.plugin.getInventoryManager().openInventory(inventoryPlayer);
                return;
            }
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("kitReceived").replace("%kit%", kitName), true);
        }
    }

    public void create(Player player, String[] args, FileConfiguration messagesConfig, MessagesManager msgManager) {
        if (!PlayerUtils.isPlayerKitsAdmin((CommandSender)player)) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("noPermissions"), true);
            return;
        }
        if (args.length < 2) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("commandCreateError"), true);
            return;
        }
        boolean saveOriginalItems = this.plugin.getConfigsManager().getMainConfigManager().isNewKitDefaultSaveModeOriginal();
        if (args.length >= 3) {
            if (args[2].equalsIgnoreCase("original")) {
                saveOriginalItems = true;
            } else if (args[2].equalsIgnoreCase("configurable")) {
                saveOriginalItems = false;
            } else {
                msgManager.sendMessage((CommandSender)player, messagesConfig.getString("commandCreateError"), true);
                return;
            }
        }
        this.plugin.getKitsManager().createKit(args[1], player, saveOriginalItems);
    }

    public void delete(CommandSender sender, String[] args, FileConfiguration messagesConfig, MessagesManager msgManager) {
        if (!PlayerUtils.isPlayerKitsAdmin(sender)) {
            msgManager.sendMessage(sender, messagesConfig.getString("noPermissions"), true);
            return;
        }
        if (args.length < 2) {
            msgManager.sendMessage(sender, messagesConfig.getString("commandDeleteError"), true);
            return;
        }
        this.plugin.getKitsManager().deleteKit(args[1], sender);
    }

    public void edit(Player player, String[] args, FileConfiguration messagesConfig, MessagesManager msgManager) {
        if (!PlayerUtils.isPlayerKitsAdmin((CommandSender)player)) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("noPermissions"), true);
            return;
        }
        if (args.length < 2) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("commandEditError"), true);
            return;
        }
        if (this.plugin.getKitsManager().getKitByName(args[1]) == null) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("kitDoesNotExists").replace("%kit%", args[1]), true);
            return;
        }
        InventoryPlayer inventoryPlayer = new InventoryPlayer(player, null);
        inventoryPlayer.setKitName(args[1]);
        this.plugin.getInventoryEditManager().openInventory(inventoryPlayer);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        MainConfigManager mainConfigManager = this.plugin.getConfigsManager().getMainConfigManager();
        boolean claimKitShortCommand = mainConfigManager.isClaimKitShortCommand();
        boolean kitPreviewEnabled = mainConfigManager.isKitPreview();
        ArrayList<String> completions = new ArrayList<String>();
        ArrayList<String> commands = new ArrayList<String>();
        if (args.length == 1) {
            if (claimKitShortCommand) {
                List<String> kitCompletions = this.getKitCompletions(sender, args, 0);
                if (kitCompletions != null) {
                    commands.addAll(kitCompletions);
                }
            } else {
                commands.add("claim");
            }
            if (kitPreviewEnabled) {
                commands.add("preview");
            }
            if (PlayerUtils.isPlayerKitsAdmin(sender)) {
                commands.add("give");
                commands.add("delete");
                commands.add("create");
                commands.add("reload");
                commands.add("reset");
                commands.add("edit");
                commands.add("verify");
                commands.add("migrate");
                commands.add("open");
            }
            for (String c : commands) {
                if (!args[0].isEmpty() && !c.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                completions.add(c);
            }
            return completions;
        }
        if (args.length == 2) {
            if (!claimKitShortCommand) {
                commands.add("claim");
            }
            if (kitPreviewEnabled) {
                commands.add("preview");
            }
            if (PlayerUtils.isPlayerKitsAdmin(sender)) {
                commands.add("give");
                commands.add("delete");
                commands.add("reset");
                commands.add("edit");
                commands.add("open");
            }
            for (String c : commands) {
                if (!args[0].equalsIgnoreCase(c)) continue;
                if (c.equals("open")) {
                    return this.getInventoryCompletions(args, 1);
                }
                return this.getKitCompletions(sender, args, 1);
            }
        } else if (args.length == 3 && PlayerUtils.isPlayerKitsAdmin(sender)) {
            if (args[0].equalsIgnoreCase("create")) {
                commands.add("original");
                commands.add("configurable");
                for (String c : commands) {
                    if (!args[2].isEmpty() && !c.startsWith(args[2].toLowerCase())) continue;
                    completions.add(c);
                }
                return completions;
            }
            if (args[0].equalsIgnoreCase("reset")) {
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (!args[2].isEmpty() && !p.getName().toLowerCase().startsWith(args[2].toLowerCase())) continue;
                    completions.add(p.getName());
                }
                if (args[2].isEmpty() || "*".startsWith(args[2].toLowerCase())) {
                    completions.add("*");
                }
                return completions;
            }
        }
        return null;
    }

    public List<String> getKitCompletions(CommandSender sender, String[] args, int argKitPos) {
        ArrayList<String> completions = new ArrayList<String>();
        String argKit = args[argKitPos];
        ArrayList<Kit> kits = this.plugin.getKitsManager().getKits();
        for (Kit kit : kits) {
            if (!argKit.isEmpty() && !kit.getName().toLowerCase().startsWith(argKit.toLowerCase()) || !kit.playerHasPermission(sender)) continue;
            completions.add(kit.getName());
        }
        if (completions.isEmpty()) {
            return null;
        }
        return completions;
    }

    public List<String> getInventoryCompletions(String[] args, int argInvPos) {
        ArrayList<String> completions = new ArrayList<String>();
        String argInv = args[argInvPos];
        ArrayList<KitInventory> inventories = this.plugin.getInventoryManager().getInventories();
        for (KitInventory inv : inventories) {
            if (!argInv.isEmpty() && !inv.getName().toLowerCase().startsWith(argInv.toLowerCase()) || inv.getName().equals("preview_inventory") || inv.getName().equals("buy_requirements_inventory")) continue;
            completions.add(inv.getName());
        }
        if (completions.isEmpty()) {
            return null;
        }
        return completions;
    }
}

