/*
 * Decompiled with CFR 0.152.
 */
package pk.ajneb97.configs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import pk.ajneb97.PlayerKits2;
import pk.ajneb97.configs.DataFolderConfigManager;
import pk.ajneb97.configs.model.CommonConfig;
import pk.ajneb97.model.PlayerData;
import pk.ajneb97.model.PlayerDataKit;

public class PlayersConfigManager
extends DataFolderConfigManager {
    public PlayersConfigManager(PlayerKits2 plugin, String folderName) {
        super(plugin, folderName);
    }

    @Override
    public void createFiles() {
    }

    @Override
    public void loadConfigs() {
        HashMap<UUID, PlayerData> players = new HashMap<UUID, PlayerData>();
        ArrayList<CommonConfig> configs = this.getConfigs();
        for (CommonConfig commonConfig : configs) {
            FileConfiguration config = commonConfig.getConfig();
            String uuidString = commonConfig.getPath().replace(".yml", "");
            String name = config.getString("name");
            ArrayList<PlayerDataKit> playerDataKits = new ArrayList<PlayerDataKit>();
            if (config.contains("kits")) {
                for (String key : config.getConfigurationSection("kits").getKeys(false)) {
                    long cooldown = config.getLong("kits." + key + ".cooldown");
                    boolean oneTime = config.getBoolean("kits." + key + ".one_time");
                    boolean bought = config.getBoolean("kits." + key + ".bought");
                    PlayerDataKit playerDataKit = new PlayerDataKit(key);
                    playerDataKit.setCooldown(cooldown);
                    playerDataKit.setOneTime(oneTime);
                    playerDataKit.setBought(bought);
                    playerDataKits.add(playerDataKit);
                }
            }
            UUID uuid = UUID.fromString(uuidString);
            PlayerData playerData = new PlayerData(uuid, name);
            playerData.setKits(playerDataKits);
            players.put(uuid, playerData);
        }
        this.plugin.getPlayerDataManager().setPlayers(players);
    }

    public void saveConfig(PlayerData playerData) {
        String playerName = playerData.getName();
        CommonConfig playerConfig = this.getConfigFile(playerData.getUuid() + ".yml");
        FileConfiguration config = playerConfig.getConfig();
        config.set("name", (Object)playerName);
        config.set("kits", null);
        for (PlayerDataKit playerDataKit : playerData.getKits()) {
            String kitName = playerDataKit.getName();
            config.set("kits." + kitName + ".cooldown", (Object)playerDataKit.getCooldown());
            config.set("kits." + kitName + ".one_time", (Object)playerDataKit.isOneTime());
            config.set("kits." + kitName + ".bought", (Object)playerDataKit.isBought());
        }
        playerConfig.saveConfig();
    }

    @Override
    public void saveConfigs() {
        Map<UUID, PlayerData> players = this.plugin.getPlayerDataManager().getPlayers();
        boolean isMySQL = this.plugin.getConfigsManager().getMainConfigManager().isMySQL();
        if (!isMySQL) {
            for (Map.Entry<UUID, PlayerData> entry : players.entrySet()) {
                PlayerData playerData = entry.getValue();
                if (playerData.isModified()) {
                    this.saveConfig(playerData);
                }
                playerData.setModified(false);
            }
        }
    }
}

