/*
 * Decompiled with CFR 0.152.
 */
package pk.ajneb97.listeners;

import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import pk.ajneb97.PlayerKits2;
import pk.ajneb97.managers.InventoryManager;
import pk.ajneb97.managers.MessagesManager;
import pk.ajneb97.model.inventory.InventoryPlayer;
import pk.ajneb97.utils.InventoryUtils;

public class PlayerListener
implements Listener {
    private PlayerKits2 plugin;

    public PlayerListener(PlayerKits2 plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.plugin.getPlayerDataManager().manageJoin(player);
        String latestVersion = this.plugin.getUpdateCheckerManager().getLatestVersion();
        if (player.isOp() && this.plugin.getConfigsManager().getMainConfigManager().isUpdateNotify() && !this.plugin.version.equals(latestVersion)) {
            player.sendMessage(MessagesManager.getColoredMessage(PlayerKits2.prefix + "&cThere is a new version available. &e(&7" + latestVersion + "&e)"));
            player.sendMessage(MessagesManager.getColoredMessage("&cYou can download it at: &ahttps://modrinth.com/plugin/playerkits-2"));
        }
    }

    @EventHandler
    public void closeInventory(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        this.plugin.getInventoryManager().removeInventoryPlayer(player);
    }

    @EventHandler
    public void clickInventory(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        InventoryManager invManager = this.plugin.getInventoryManager();
        InventoryPlayer inventoryPlayer = invManager.getInventoryPlayer(player);
        if (inventoryPlayer != null) {
            event.setCancelled(true);
            if (event.getCurrentItem() == null || event.getSlotType() == null) {
                return;
            }
            if (event.getClickedInventory().equals((Object)InventoryUtils.getTopInventory(player))) {
                ClickType clickType = event.getClick();
                invManager.clickInventory(inventoryPlayer, event.getCurrentItem(), clickType);
            }
        }
    }
}

