/*
 * Decompiled with CFR 0.152.
 */
package pk.ajneb97.managers;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import pk.ajneb97.PlayerKits2;
import pk.ajneb97.database.MySQLConnection;
import pk.ajneb97.model.PlayerData;
import pk.ajneb97.model.internal.PlayerKitsMessageResult;
import pk.ajneb97.utils.OtherUtils;

public class PlayerDataManager {
    private PlayerKits2 plugin;
    private Map<UUID, PlayerData> players;
    private Map<String, UUID> playerNames;

    public PlayerDataManager(PlayerKits2 plugin) {
        this.plugin = plugin;
        this.playerNames = new HashMap<String, UUID>();
    }

    public Map<UUID, PlayerData> getPlayers() {
        return this.players;
    }

    public void setPlayers(Map<UUID, PlayerData> players) {
        this.players = players;
        for (Map.Entry<UUID, PlayerData> entry : players.entrySet()) {
            this.playerNames.put(entry.getValue().getName(), entry.getKey());
        }
    }

    public void addPlayer(PlayerData p) {
        this.players.put(p.getUuid(), p);
        this.playerNames.put(p.getName(), p.getUuid());
    }

    public PlayerData getPlayer(Player player, boolean create) {
        PlayerData playerData = this.players.get(player.getUniqueId());
        if (playerData == null && create) {
            playerData = new PlayerData(player.getUniqueId(), player.getName());
            this.addPlayer(playerData);
        }
        return playerData;
    }

    private void updatePlayerName(String oldName, String newName, UUID uuid) {
        if (oldName != null) {
            this.playerNames.remove(oldName);
        }
        this.playerNames.put(newName, uuid);
    }

    public PlayerData getPlayerByUUID(UUID uuid) {
        return this.players.get(uuid);
    }

    private UUID getPlayerUUID(String name) {
        return this.playerNames.get(name);
    }

    public PlayerData getPlayerByName(String name) {
        UUID uuid = this.getPlayerUUID(name);
        return this.players.get(uuid);
    }

    public void removePlayerByUUID(UUID uuid) {
        this.players.remove(uuid);
    }

    public void setKitCooldown(Player player, String kitName, long cooldown) {
        PlayerData playerData = this.getPlayer(player, true);
        boolean creating = playerData.setKitCooldown(kitName, cooldown);
        playerData.setModified(true);
        if (this.plugin.getMySQLConnection() != null) {
            this.plugin.getMySQLConnection().updateKit(playerData, playerData.getKit(kitName), creating);
        }
    }

    public long getKitCooldown(Player player, String kitName) {
        PlayerData playerData = this.getPlayerByUUID(player.getUniqueId());
        if (playerData == null) {
            return 0L;
        }
        return playerData.getKitCooldown(kitName);
    }

    public String getKitCooldownString(long playerCooldown) {
        long currentMillis = System.currentTimeMillis();
        long millisDif = playerCooldown - currentMillis;
        String timeStringMillisDif = OtherUtils.getTime(millisDif / 1000L, this.plugin.getMessagesManager());
        return timeStringMillisDif;
    }

    public void setKitOneTime(Player player, String kitName) {
        PlayerData playerData = this.getPlayer(player, true);
        boolean creating = playerData.setKitOneTime(kitName);
        playerData.setModified(true);
        if (this.plugin.getMySQLConnection() != null) {
            this.plugin.getMySQLConnection().updateKit(playerData, playerData.getKit(kitName), creating);
        }
    }

    public boolean isKitOneTime(Player player, String kitName) {
        PlayerData playerData = this.getPlayerByUUID(player.getUniqueId());
        if (playerData == null) {
            return false;
        }
        return playerData.getKitOneTime(kitName);
    }

    public void setKitBought(Player player, String kitName) {
        PlayerData playerData = this.getPlayer(player, true);
        boolean creating = playerData.setKitBought(kitName);
        playerData.setModified(true);
        if (this.plugin.getMySQLConnection() != null) {
            this.plugin.getMySQLConnection().updateKit(playerData, playerData.getKit(kitName), creating);
        }
    }

    public boolean isKitBought(Player player, String kitName) {
        PlayerData playerData = this.getPlayerByUUID(player.getUniqueId());
        if (playerData == null) {
            return false;
        }
        return playerData.getKitHasBought(kitName);
    }

    public PlayerKitsMessageResult resetKitForPlayer(String name, String kitName, boolean all) {
        PlayerData playerData = this.getPlayerByName(name);
        FileConfiguration messagesConfig = this.plugin.getConfigsManager().getMessagesConfigManager().getConfig();
        if (playerData == null && !all) {
            return PlayerKitsMessageResult.error(messagesConfig.getString("playerDataNotFound").replace("%player%", name));
        }
        if (all) {
            for (Map.Entry<UUID, PlayerData> entry : this.players.entrySet()) {
                entry.getValue().resetKit(kitName);
            }
        } else {
            playerData.resetKit(kitName);
        }
        if (this.plugin.getMySQLConnection() != null) {
            if (all) {
                this.plugin.getMySQLConnection().resetKit(null, kitName, true);
            } else {
                this.plugin.getMySQLConnection().resetKit(playerData.getUuid().toString(), kitName, false);
            }
        }
        return PlayerKitsMessageResult.success();
    }

    public void manageJoin(Player player) {
        if (this.plugin.getMySQLConnection() != null) {
            MySQLConnection mySQLConnection = this.plugin.getMySQLConnection();
            UUID uuid = player.getUniqueId();
            mySQLConnection.getPlayer(uuid.toString(), playerData -> {
                this.removePlayerByUUID(uuid);
                if (playerData != null) {
                    this.addPlayer(playerData);
                    if (!playerData.getName().equals(player.getName())) {
                        this.updatePlayerName(playerData.getName(), player.getName(), player.getUniqueId());
                        playerData.setName(player.getName());
                        mySQLConnection.updatePlayerName(playerData);
                    }
                } else {
                    playerData = new PlayerData(uuid, player.getName());
                    this.addPlayer(playerData);
                    mySQLConnection.createPlayer(playerData, () -> this.plugin.getKitsManager().giveFirstJoinKit(player));
                }
            });
        } else {
            PlayerData playerData2 = this.getPlayer(player, false);
            if (playerData2 == null) {
                playerData2 = new PlayerData(player.getUniqueId(), player.getName());
                playerData2.setModified(true);
                this.addPlayer(playerData2);
                this.plugin.getKitsManager().giveFirstJoinKit(player);
            } else if (playerData2.getName() == null || !playerData2.getName().equals(player.getName())) {
                this.updatePlayerName(playerData2.getName(), player.getName(), player.getUniqueId());
                playerData2.setName(player.getName());
                playerData2.setModified(true);
            }
        }
    }
}

