/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.rollable.config;

import com.iafenvoy.jupiter.config.container.AutoInitConfigContainer;
import com.iafenvoy.jupiter.config.entry.BooleanEntry;
import com.iafenvoy.jupiter.config.entry.DoubleEntry;
import com.iafenvoy.jupiter.config.entry.SeparatorEntry;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.rollable.config.entry.ExpressionParserEntry;
import com.iafenvoy.rollable.config.entry.RotateStateEntry;
import com.iafenvoy.rollable.expression.ExpressionParser;
import com.iafenvoy.rollable.flight.RotateState;
import net.minecraft.class_2960;

public class RollableClientConfig
extends AutoInitConfigContainer {
    private static final String CONFIG_PATH = "./config/%s_client.json".formatted("rollable");
    public static final RollableClientConfig INSTANCE = new RollableClientConfig();
    public final Generals generals = new Generals();
    public final Swim swim = new Swim();
    public final Banking banking = new Banking();
    public final SensitivityConfig sensitivity = new SensitivityConfig();
    public final AdvancedConfig advanced = new AdvancedConfig();

    public RollableClientConfig() {
        super(class_2960.method_43902((String)"rollable", (String)"client"), "config.%s.client.title".formatted("rollable"), CONFIG_PATH);
    }

    private static String format(String category, String jsonKey) {
        return "config.%s.%s.%s".formatted("rollable", category, jsonKey);
    }

    public static class Generals
    extends AutoInitConfigContainer.AutoInitConfigCategoryBase {
        public final IConfigEntry<Boolean> enabled = new BooleanEntry(RollableClientConfig.format("generals", "enabled"), true).json("enabled");
        public final SeparatorEntry s = new SeparatorEntry();
        public final IConfigEntry<Boolean> switchRollAndYaw = new BooleanEntry(RollableClientConfig.format("generals", "switchRollAndYaw"), false).json("switchRollAndYaw");
        public final IConfigEntry<Boolean> invertPitch = new BooleanEntry(RollableClientConfig.format("generals", "invertPitch"), false).json("invertPitch");
        public final IConfigEntry<Boolean> momentumBasedMouse = new BooleanEntry(RollableClientConfig.format("generals", "momentumBasedMouse"), false).json("momentumBasedMouse");
        public final IConfigEntry<Double> momentumMouseDeadzone = new DoubleEntry(RollableClientConfig.format("generals", "momentumMouseDeadzone"), 0.2, 0.0, 2.147483647E9).json("momentumMouseDeadzone");
        public final IConfigEntry<Boolean> disableWhenSubmerged = new BooleanEntry(RollableClientConfig.format("generals", "disableWhenSubmerged"), true).json("disableWhenSubmerged");

        public Generals() {
            super("generals", RollableClientConfig.format("generals", "title"));
        }
    }

    public static class Swim
    extends AutoInitConfigContainer.AutoInitConfigCategoryBase {
        public final IConfigEntry<Boolean> enabled = new BooleanEntry(RollableClientConfig.format("swim", "enabled"), true).json("enabled");
        public final SeparatorEntry s = new SeparatorEntry();
        public final IConfigEntry<Double> strafeRollStrength = new DoubleEntry(RollableClientConfig.format("swim", "strafeRollStrength"), 2.5, 0.0, 2.147483647E9).json("strafeRollStrength");
        public final IConfigEntry<Double> strafeYawStrength = new DoubleEntry(RollableClientConfig.format("swim", "strafeYawStrength"), 1.0, 0.0, 2.147483647E9).json("strafeYawStrength");
        public final IConfigEntry<Boolean> smoothingEnabled = new BooleanEntry(RollableClientConfig.format("swim", "smoothingEnabled"), true).json("smoothingEnabled");
        public final IConfigEntry<Boolean> strafeSmoothingEnabled = new BooleanEntry(RollableClientConfig.format("swim", "strafeSmoothingEnabled"), true).json("strafeSmoothingEnabled");
        public final IConfigEntry<RotateState> smoothingValues = new RotateStateEntry(RollableClientConfig.format("swim", "smoothingValues"), 0.5, 0.5, 0.5).json("smoothingValues");

        public Swim() {
            super("swim", RollableClientConfig.format("swim", "title"));
        }
    }

    public static class Banking
    extends AutoInitConfigContainer.AutoInitConfigCategoryBase {
        public final IConfigEntry<Boolean> enabled = new BooleanEntry(RollableClientConfig.format("banking", "enabled"), true).json("enabled");
        public final IConfigEntry<Double> strength = new DoubleEntry(RollableClientConfig.format("banking", "strength"), 20.0, 0.0, 2.147483647E9).json("strength");
        public final IConfigEntry<Boolean> simulateControlSurfaceEfficacy = new BooleanEntry(RollableClientConfig.format("banking", "simulateControlSurfaceEfficacy"), false).json("simulateControlSurfaceEfficacy");
        public final IConfigEntry<Boolean> automaticRighting = new BooleanEntry(RollableClientConfig.format("banking", "automaticRighting"), false).json("automaticRighting");
        public final IConfigEntry<Double> rightingStrength = new DoubleEntry(RollableClientConfig.format("banking", "rightingStrength"), 50.0, 0.0, 2.147483647E9).json("rightingStrength");

        public Banking() {
            super("banking", RollableClientConfig.format("banking", "title"));
        }
    }

    public static class SensitivityConfig
    extends AutoInitConfigContainer.AutoInitConfigCategoryBase {
        public final IConfigEntry<RotateState> cameraSmoothing = new RotateStateEntry(RollableClientConfig.format("advanced", "cameraSmoothing"), 1.0, 2.5, 1.0).json("cameraSmoothing");
        public final IConfigEntry<RotateState> desktop = new RotateStateEntry(RollableClientConfig.format("advanced", "desktop"), 1.0, 0.4, 1.0).json("desktop");
        public final IConfigEntry<RotateState> controller = new RotateStateEntry(RollableClientConfig.format("advanced", "controller"), 1.0, 0.4, 1.0).json("controller");

        public SensitivityConfig() {
            super("sensitivity", RollableClientConfig.format("sensitivity", "title"));
        }
    }

    public static class AdvancedConfig
    extends AutoInitConfigContainer.AutoInitConfigCategoryBase {
        public final IConfigEntry<ExpressionParser> bankingXFormula = new ExpressionParserEntry(RollableClientConfig.format("advanced", "bankingXFormula"), "sin($roll * TO_RAD) * cos($pitch * TO_RAD) * 10 * $banking_strength").json("bankingXFormula");
        public final IConfigEntry<ExpressionParser> bankingYFormula = new ExpressionParserEntry(RollableClientConfig.format("advanced", "bankingYFormula"), "(-1 + cos($roll * TO_RAD)) * cos($pitch * TO_RAD) * 10 * $banking_strength").json("bankingYFormula");
        public final IConfigEntry<ExpressionParser> elevatorEfficacyFormula = new ExpressionParserEntry(RollableClientConfig.format("advanced", "elevatorEfficacyFormula"), "$velocity_x * $look_x + $velocity_y * $look_y + $velocity_z * $look_z").json("elevatorEfficacyFormula");
        public final IConfigEntry<ExpressionParser> aileronEfficacyFormula = new ExpressionParserEntry(RollableClientConfig.format("advanced", "aileronEfficacyFormula"), "$velocity_x * $look_x + $velocity_y * $look_y + $velocity_z * $look_z").json("aileronEfficacyFormula");
        public final IConfigEntry<ExpressionParser> rudderEfficacyFormula = new ExpressionParserEntry(RollableClientConfig.format("advanced", "rudderEfficacyFormula"), "$velocity_x * $look_x + $velocity_y * $look_y + $velocity_z * $look_z").json("rudderEfficacyFormula");

        public AdvancedConfig() {
            super("advanced", RollableClientConfig.format("advanced", "title"));
        }
    }
}

