/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.rollable.event;

import com.iafenvoy.rollable.Rollable;
import com.iafenvoy.rollable.RollableKeybindings;
import com.iafenvoy.rollable.config.RollableClientConfig;
import com.iafenvoy.rollable.flight.RollContext;
import com.iafenvoy.rollable.flight.RollProcessGroup;
import com.iafenvoy.rollable.flight.RotateState;
import com.iafenvoy.rollable.flight.modifier.RotationModifiers;
import com.iafenvoy.rollable.flight.modifier.StrafeRollModifiers;
import net.minecraft.class_310;
import net.minecraft.class_3540;
import net.minecraft.class_746;

public class ClientEvents {
    private static final RollProcessGroup ELYTRA_GROUP = RollProcessGroup.get(Rollable.id("elytra"));
    private static final RollProcessGroup SWIMMING_GROUP = RollProcessGroup.get(Rollable.id("swimming"));
    private static final SmoothGroup ELYTRA = new SmoothGroup();
    private static final SmoothGroup SWIMMING = new SmoothGroup();

    public static void registerEvents() {
        ELYTRA_GROUP.registerEnablePredicate(ClientEvents::isFallFlying);
        ELYTRA_GROUP.registerBeforeModifier(context -> context.useModifier(RotationModifiers.buttonControls(1800.0)));
        ELYTRA_GROUP.registerBeforeModifier(context -> context.useModifier(RotationModifiers::configureRotation));
        ELYTRA_GROUP.registerAfterModifier(context -> context.useModifier(RotationModifiers::applyControlSurfaceEfficacy, () -> RollableClientConfig.INSTANCE.banking.simulateControlSurfaceEfficacy.getValue()).useModifier(ELYTRA.smoothing((RotateState)RollableClientConfig.INSTANCE.sensitivity.cameraSmoothing.getValue())).useModifier(RotationModifiers::banking, () -> RollableClientConfig.INSTANCE.banking.enabled.getValue()).useModifier(RotationModifiers::reorient, () -> RollableClientConfig.INSTANCE.banking.automaticRighting.getValue()));
        SWIMMING_GROUP.registerEnablePredicate(ClientEvents::isSwimming);
        SWIMMING_GROUP.registerBeforeModifier(context -> context.useModifier(StrafeRollModifiers::applyStrafeRoll));
        SWIMMING_GROUP.registerBeforeModifier(context -> context.useModifier(RotationModifiers::configureRotation));
        SWIMMING_GROUP.registerAfterModifier(context -> context.useModifier(SWIMMING.smoothing((RotateState)RollableClientConfig.INSTANCE.swim.smoothingValues.getValue())));
    }

    public static void clientTick(class_310 client) {
        if (!ClientEvents.isFallFlying()) {
            ELYTRA.clear();
        }
        if (!ClientEvents.isSwimming()) {
            SWIMMING.clear();
        }
        RollableKeybindings.clientTick(client);
    }

    public static boolean isFallFlying() {
        if (!((Boolean)RollableClientConfig.INSTANCE.generals.enabled.getValue()).booleanValue()) {
            return false;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return false;
        }
        if (((Boolean)RollableClientConfig.INSTANCE.generals.disableWhenSubmerged.getValue()).booleanValue() && player.method_5869()) {
            return false;
        }
        return player.method_6128();
    }

    public static boolean isSwimming() {
        class_746 player = class_310.method_1551().field_1724;
        return (Boolean)RollableClientConfig.INSTANCE.swim.enabled.getValue() != false && player != null && player.method_5681() && player.method_5869();
    }

    private record SmoothGroup(class_3540 pitch, class_3540 yaw, class_3540 roll) {
        public SmoothGroup() {
            this(new class_3540(), new class_3540(), new class_3540());
        }

        public RollContext.ConfiguresRotation smoothing(RotateState smoothness) {
            return RotationModifiers.smoothing(this.pitch, this.yaw, this.roll, smoothness);
        }

        public void clear() {
            this.pitch.method_15428();
            this.yaw.method_15428();
            this.roll.method_15428();
        }
    }
}

